# coding: utf-8

"""
    Daytona Server API

    Daytona Server API

    The version of the OpenAPI document: v0.0.0-dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from api_client.models.provider_provider_target_property_type import (
    ProviderProviderTargetPropertyType,
)
from typing import Optional, Set
from typing_extensions import Self


class ProviderProviderTargetProperty(BaseModel):
    """
    ProviderProviderTargetProperty
    """  # noqa: E501

    default_value: Optional[StrictStr] = Field(
        default=None,
        description="DefaultValue is converted into the appropriate type based on the Type If the property is a FilePath, the DefaultValue is a path to a directory",
        alias="defaultValue",
    )
    description: Optional[StrictStr] = Field(
        default=None, description="Brief description of the property"
    )
    disabled_predicate: Optional[StrictStr] = Field(
        default=None,
        description='A regex string matched with the name of the target to determine if the property should be disabled If the regex matches the target name, the property will be disabled E.g. "^local$" will disable the property for the local target',
        alias="disabledPredicate",
    )
    input_masked: Optional[StrictBool] = Field(default=None, alias="inputMasked")
    options: Optional[List[StrictStr]] = Field(
        default=None,
        description="Options is only used if the Type is ProviderTargetPropertyTypeOption",
    )
    suggestions: Optional[List[StrictStr]] = Field(
        default=None,
        description="Suggestions is an optional list of auto-complete values to assist the user while filling the field",
    )
    type: Optional[ProviderProviderTargetPropertyType] = None
    __properties: ClassVar[List[str]] = [
        "defaultValue",
        "description",
        "disabledPredicate",
        "inputMasked",
        "options",
        "suggestions",
        "type",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProviderProviderTargetProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProviderProviderTargetProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "defaultValue": obj.get("defaultValue"),
                "description": obj.get("description"),
                "disabledPredicate": obj.get("disabledPredicate"),
                "inputMasked": obj.get("inputMasked"),
                "options": obj.get("options"),
                "suggestions": obj.get("suggestions"),
                "type": obj.get("type"),
            }
        )
        return _obj
