"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before
 * synthesis.
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     * @param scope The scope for which these aspects will apply.
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     * @param aspect The aspect to add.
     */
    add(aspect) {
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
//# sourceMappingURL=data:application/json;base64,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