"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'Rule can be used to create rules'(test) {
        const stack = new lib_1.Stack();
        const rule = new lib_1.CfnRule(stack, 'MyRule');
        rule.addAssertion(lib_1.Fn.conditionEquals('lhs', 'rhs'), 'lhs equals rhs');
        rule.addAssertion(lib_1.Fn.conditionNot(lib_1.Fn.conditionAnd(lib_1.Fn.conditionContains(['hello', 'world'], 'world'))), 'some assertion');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Rules: {
                MyRule: {
                    Assertions: [
                        {
                            Assert: { 'Fn::Equals': ['lhs', 'rhs'] },
                            AssertDescription: 'lhs equals rhs',
                        },
                        {
                            Assert: { 'Fn::Not': [{ 'Fn::And': [{ 'Fn::Contains': [['hello', 'world'], 'world'] }] }] },
                            AssertDescription: 'some assertion',
                        },
                    ],
                },
            },
        });
        test.done();
    },
    'a template can contain multiple Rules'(test) {
        const stack = new lib_1.Stack();
        new lib_1.CfnRule(stack, 'Rule1');
        new lib_1.CfnRule(stack, 'Rule2');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Rules: {
                Rule1: {},
                Rule2: {},
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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