# Generated by Django 2.0.1 on 2018-01-19 11:04

import _socket
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_revision.revision_field
import edc_model_fields.fields
import edc_model_fields.fields.hostname_modification_field
import edc_model_fields.fields.userfield
import edc_model_fields.fields.uuid_auto_field
import edc_base.model_validators.date
import edc_base.sites.managers
import edc_base.utils
import edc_protocol.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="DeathReport",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject Identifier"
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "death_datetime",
                    models.DateTimeField(
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Date and Time of Death",
                    ),
                ),
                (
                    "study_day",
                    models.IntegerField(
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Study day",
                    ),
                ),
                (
                    "death_as_inpatient",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Death as inpatient",
                    ),
                ),
                (
                    "cause_of_death",
                    models.CharField(
                        choices=[
                            ("cryptococcal_meningitis", "Cryptococcal meningitis"),
                            (
                                "Cryptococcal_meningitis_relapse_IRIS",
                                "Cryptococcal meningitis relapse/IRIS",
                            ),
                            ("TB", "TB"),
                            ("bacteraemia", "Bacteraemia"),
                            ("bacterial_pneumonia", "Bacterial pneumonia"),
                            ("malignancy", "Malignancy"),
                            ("art_toxicity", "ART toxicity"),
                            ("IRIS_non_CM", "IRIS non-CM"),
                            ("diarrhea_wasting", "Diarrhea/wasting"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        help_text="Tick only 1:(NB. Fill in AE CRF)",
                        max_length=50,
                        verbose_name="Main cause of death (opinion of local study Dr and local PI)",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify:",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("meningitis", "Meningitis"),
                            ("pulmonary", "Pulmonary"),
                            ("disseminated", "Disseminated"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If cause of death is TB, specify site of TB disease",
                    ),
                ),
                ("death_narrative", models.TextField(verbose_name="Narrative")),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name": "Death Report"},
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="DeathReportTmgOne",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death",
                    models.CharField(
                        choices=[
                            ("cryptococcal_meningitis", "Cryptococcal meningitis"),
                            (
                                "Cryptococcal_meningitis_relapse_IRIS",
                                "Cryptococcal meningitis relapse/IRIS",
                            ),
                            ("TB", "TB"),
                            ("bacteraemia", "Bacteraemia"),
                            ("bacterial_pneumonia", "Bacterial pneumonia"),
                            ("malignancy", "Malignancy"),
                            ("art_toxicity", "ART toxicity"),
                            ("IRIS_non_CM", "IRIS non-CM"),
                            ("diarrhea_wasting", "Diarrhea/wasting"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        help_text="Tick only 1:(NB. Fill in AE CRF)",
                        max_length=50,
                        verbose_name="Main cause of death (opinion of TMG member)",
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, complete Q10 below",
                        max_length=5,
                        verbose_name="Cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify:",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("meningitis", "Meningitis"),
                            ("pulmonary", "Pulmonary"),
                            ("disseminated", "Disseminated"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If cause of death is TB, specify site of TB disease",
                    ),
                ),
                ("death_narrative", models.TextField(verbose_name="Narrative")),
                (
                    "death_report",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="ambition_prn.DeathReport",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name_plural": "Death report TMG 1"},
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="DeathReportTmgTwo",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death",
                    models.CharField(
                        choices=[
                            ("cryptococcal_meningitis", "Cryptococcal meningitis"),
                            (
                                "Cryptococcal_meningitis_relapse_IRIS",
                                "Cryptococcal meningitis relapse/IRIS",
                            ),
                            ("TB", "TB"),
                            ("bacteraemia", "Bacteraemia"),
                            ("bacterial_pneumonia", "Bacterial pneumonia"),
                            ("malignancy", "Malignancy"),
                            ("art_toxicity", "ART toxicity"),
                            ("IRIS_non_CM", "IRIS non-CM"),
                            ("diarrhea_wasting", "Diarrhea/wasting"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        help_text="Tick only 1:(NB. Fill in AE CRF)",
                        max_length=50,
                        verbose_name="Main cause of death (opinion of TMG member)",
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, complete Q10 below",
                        max_length=5,
                        verbose_name="Cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify:",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("meningitis", "Meningitis"),
                            ("pulmonary", "Pulmonary"),
                            ("disseminated", "Disseminated"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If cause of death is TB, specify site of TB disease",
                    ),
                ),
                ("death_narrative", models.TextField(verbose_name="Narrative")),
                (
                    "death_report",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="ambition_prn.DeathReport",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name_plural": "Death report TMG 2"},
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="HistoricalDeathReport",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Subject Identifier"
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "death_datetime",
                    models.DateTimeField(
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Date and Time of Death",
                    ),
                ),
                (
                    "study_day",
                    models.IntegerField(
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Study day",
                    ),
                ),
                (
                    "death_as_inpatient",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Death as inpatient",
                    ),
                ),
                (
                    "cause_of_death",
                    models.CharField(
                        choices=[
                            ("cryptococcal_meningitis", "Cryptococcal meningitis"),
                            (
                                "Cryptococcal_meningitis_relapse_IRIS",
                                "Cryptococcal meningitis relapse/IRIS",
                            ),
                            ("TB", "TB"),
                            ("bacteraemia", "Bacteraemia"),
                            ("bacterial_pneumonia", "Bacterial pneumonia"),
                            ("malignancy", "Malignancy"),
                            ("art_toxicity", "ART toxicity"),
                            ("IRIS_non_CM", "IRIS non-CM"),
                            ("diarrhea_wasting", "Diarrhea/wasting"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        help_text="Tick only 1:(NB. Fill in AE CRF)",
                        max_length=50,
                        verbose_name="Main cause of death (opinion of local study Dr and local PI)",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify:",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("meningitis", "Meningitis"),
                            ("pulmonary", "Pulmonary"),
                            ("disseminated", "Disseminated"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If cause of death is TB, specify site of TB disease",
                    ),
                ),
                ("death_narrative", models.TextField(verbose_name="Narrative")),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalDeathReportTmgOne",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death",
                    models.CharField(
                        choices=[
                            ("cryptococcal_meningitis", "Cryptococcal meningitis"),
                            (
                                "Cryptococcal_meningitis_relapse_IRIS",
                                "Cryptococcal meningitis relapse/IRIS",
                            ),
                            ("TB", "TB"),
                            ("bacteraemia", "Bacteraemia"),
                            ("bacterial_pneumonia", "Bacterial pneumonia"),
                            ("malignancy", "Malignancy"),
                            ("art_toxicity", "ART toxicity"),
                            ("IRIS_non_CM", "IRIS non-CM"),
                            ("diarrhea_wasting", "Diarrhea/wasting"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        help_text="Tick only 1:(NB. Fill in AE CRF)",
                        max_length=50,
                        verbose_name="Main cause of death (opinion of TMG member)",
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, complete Q10 below",
                        max_length=5,
                        verbose_name="Cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify:",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("meningitis", "Meningitis"),
                            ("pulmonary", "Pulmonary"),
                            ("disseminated", "Disseminated"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If cause of death is TB, specify site of TB disease",
                    ),
                ),
                ("death_narrative", models.TextField(verbose_name="Narrative")),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "death_report",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="ambition_prn.DeathReport",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalDeathReportTmgTwo",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death",
                    models.CharField(
                        choices=[
                            ("cryptococcal_meningitis", "Cryptococcal meningitis"),
                            (
                                "Cryptococcal_meningitis_relapse_IRIS",
                                "Cryptococcal meningitis relapse/IRIS",
                            ),
                            ("TB", "TB"),
                            ("bacteraemia", "Bacteraemia"),
                            ("bacterial_pneumonia", "Bacterial pneumonia"),
                            ("malignancy", "Malignancy"),
                            ("art_toxicity", "ART toxicity"),
                            ("IRIS_non_CM", "IRIS non-CM"),
                            ("diarrhea_wasting", "Diarrhea/wasting"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        help_text="Tick only 1:(NB. Fill in AE CRF)",
                        max_length=50,
                        verbose_name="Main cause of death (opinion of TMG member)",
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, complete Q10 below",
                        max_length=5,
                        verbose_name="Cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify:",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("meningitis", "Meningitis"),
                            ("pulmonary", "Pulmonary"),
                            ("disseminated", "Disseminated"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If cause of death is TB, specify site of TB disease",
                    ),
                ),
                ("death_narrative", models.TextField(verbose_name="Narrative")),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "death_report",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="ambition_prn.DeathReport",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalOnSchedule",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Subject Identifier"
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "onschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalOnScheduleW10",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Subject Identifier"
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "onschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalProtocolDeviationViolation",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(max_length=50, verbose_name="Subject Identifier"),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "report_type",
                    models.CharField(
                        choices=[
                            ("protocol_violation", "Protocol violation"),
                            ("protocol_deviation", "Protocol deviation"),
                        ],
                        max_length=25,
                        verbose_name="Type of occurrence",
                    ),
                ),
                (
                    "safety_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on safety of the participant?",
                    ),
                ),
                (
                    "safety_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "study_outcomes_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on study outcomes?",
                    ),
                ),
                (
                    "study_outcomes_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "violation_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Date violation occurred",
                    ),
                ),
                (
                    "violation_type",
                    models.CharField(
                        choices=[
                            (
                                "failure_to_obtain_informed_consent",
                                "Failure to obtain informed consent",
                            ),
                            (
                                "enrollment_of_ineligible_patient",
                                "Enrollment of ineligible patient",
                            ),
                            (
                                "screening_procedure not done",
                                "Screening procedure required by protocol not done",
                            ),
                            (
                                "screening_or_on-study_procedure",
                                "Screening or on-study procedure/lab work required not done",
                            ),
                            (
                                "incorrect_research_treatment",
                                "Incorrect research treatment given to patient",
                            ),
                            (
                                "procedure_not_completed",
                                "On-study procedure required by protocol not completed",
                            ),
                            ("visit_non-compliance", "Visit non-compliance"),
                            ("medication_stopped_early", "Medication stopped early"),
                            ("medication_noncompliance", "Medication_noncompliance"),
                            (
                                "national_regulations_not_met",
                                "Standard WPD, ICH-GCP, local/national regulations not met",
                            ),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=75,
                        verbose_name="Type of violation",
                    ),
                ),
                (
                    "violation_type_other",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If other, please specify",
                    ),
                ),
                (
                    "violation_description",
                    models.TextField(
                        blank=True,
                        help_text="Describe in full. Explain how the violation happened, what occurred, etc.",
                        null=True,
                        verbose_name="Describe the violation",
                    ),
                ),
                (
                    "violation_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Explain the reason why the violation occurred",
                    ),
                ),
                (
                    "corrective_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Corrective action date and time",
                    ),
                ),
                (
                    "corrective_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Corrective action taken"
                    ),
                ),
                (
                    "preventative_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Preventative action date and time",
                    ),
                ),
                (
                    "preventative_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Preventative action taken"
                    ),
                ),
                (
                    "action_required",
                    models.CharField(
                        choices=[
                            ("remain_on_study", "Participant to remain on trial"),
                            (
                                "to_be_withdrawn",
                                "Participant to be withdrawn from trial",
                            ),
                            (
                                "remain_on_study_modified",
                                "Patient remains on study but data analysis will be modified",
                            ),
                        ],
                        max_length=45,
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalStudyTerminationConclusion",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Subject Identifier"
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "offschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Date and time subject taken off schedule",
                    ),
                ),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "last_study_fu_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of last research follow up (if different):",
                    ),
                ),
                (
                    "discharged_after_initial_admission",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=6,
                        verbose_name="Was the patient discharged after initial admission?",
                    ),
                ),
                (
                    "initial_discharge_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of initial discharge",
                    ),
                ),
                (
                    "readmission_after_initial_discharge",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=7,
                        verbose_name="Was the patient re-admitted following initial discharge?",
                    ),
                ),
                (
                    "readmission_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of readmission",
                    ),
                ),
                (
                    "discharged_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date discharged",
                    ),
                ),
                (
                    "termination_reason",
                    models.CharField(
                        choices=[
                            (
                                "10_weeks_completed_follow_up",
                                "Patient completed 10 weeks of follow-up",
                            ),
                            ("patient_lost_to_follow_up", "Patient lost to follow-up"),
                            ("dead", "Reported/known to have died"),
                            (
                                "consent_withdrawn",
                                "Withdrawal of Subject Consent for participation",
                            ),
                            (
                                "care_transferred_to_another_institution",
                                "Care transferred to another institution",
                            ),
                            (
                                "late_exclusion_criteria_met",
                                "Late exclusion criteria met",
                            ),
                            ("included_in_error", "Included in error"),
                        ],
                        help_text="If included in error, be sure to fill in protocol deviation form.",
                        max_length=75,
                        verbose_name="Reason for study termination",
                    ),
                ),
                (
                    "death_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of Death",
                    ),
                ),
                (
                    "consent_withdrawal_reason",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="Reason for withdrawing consent",
                    ),
                ),
                (
                    "willing_to_complete_10w",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=12,
                        verbose_name="Is the patient willing to complete the W10 and W16 FU visit only?",
                    ),
                ),
                (
                    "willing_to_complete_centre",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=17,
                        verbose_name="Is the patient willing to complete the W10and W16 FU visit only at their new care centre?",
                    ),
                ),
                (
                    "willing_to_complete_date",
                    models.DateField(
                        editable=False,
                        help_text="get value from Ambition visit schedule",
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date the 10W FU due",
                    ),
                ),
                (
                    "protocol_exclusion_criterion",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=12,
                        verbose_name="Late protocol exclusion met?",
                    ),
                ),
                (
                    "included_in_error_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="If included in error, date",
                    ),
                ),
                (
                    "included_in_error",
                    models.TextField(
                        blank=True,
                        max_length=300,
                        null=True,
                        verbose_name="If included in error, narrative:",
                    ),
                ),
                (
                    "rifampicin_started",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("already_on_rifampicin", "Already on Rifampicin"),
                        ],
                        max_length=30,
                        verbose_name="Rifampicin started since week 4?",
                    ),
                ),
                (
                    "first_line_regimen",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "TDF_3TC_FTC_with_EFV_or_NVP",
                                "TDF + 3TC/FTC + either EFV or NVP or DTG",
                            ),
                            (
                                "AZT_3TC_with_EFV_NVP_or_DTG",
                                "AZT+3TC+ either EFV or NVP or DTG",
                            ),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=75,
                        verbose_name="ART regimen started for naive patients (or regimen switched for those already on ARVs)",
                    ),
                ),
                (
                    "first_line_regimen_other",
                    edc_model_fields.fields.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "second_line_regimen",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "TDF_3TC_FTC_with_ATZ_r_or_Lopinavir_r",
                                "TDF + 3TC/FTC + either ATZ/r or Lopinavir/r",
                            ),
                            (
                                "AZT_3TC_with_ATZ_r_or_Lopinavir_r",
                                "AZT +3TC + either ATZ/r or Lopinavir/r",
                            ),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="Second line / second switch ARV regimen",
                    ),
                ),
                (
                    "second_line_regimen_other",
                    edc_model_fields.fields.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "arvs_switch_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="ARV switch date",
                    ),
                ),
                (
                    "first_line_choice",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("EFV", "EFV"),
                            ("DTG", "DTG"),
                            ("NVP", "NVP"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=5,
                        verbose_name="If first line:",
                    ),
                ),
                (
                    "arvs_delay_reason",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="Reason ARVs not started",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalStudyTerminationConclusionW10",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Subject Identifier"
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "offschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Date and time subject taken off schedule",
                    ),
                ),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "last_study_fu_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of last research follow up (if different):",
                    ),
                ),
                (
                    "termination_reason",
                    models.CharField(
                        choices=[
                            (
                                "16_weeks_completed_follow_up",
                                "Patient completed 16 weeks of follow-up",
                            ),
                            ("patient_lost_to_follow_up", "Patient lost to follow-up"),
                            ("dead", "Reported/known to have died"),
                            (
                                "consent_withdrawn",
                                "Withdrawal of Subject Consent for participation",
                            ),
                            (
                                "care_transferred_to_another_institution",
                                "Care transferred to another institution",
                            ),
                            ("included_in_error", "Included in error"),
                        ],
                        help_text="If included in error, be sure to fill in protocol deviation form.",
                        max_length=75,
                        verbose_name="Reason for study termination",
                    ),
                ),
                (
                    "death_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of Death",
                    ),
                ),
                (
                    "consent_withdrawal_reason",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="Reason for withdrawing consent",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="OnSchedule",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject Identifier"
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "onschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={"abstract": False},
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="OnScheduleW10",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject Identifier"
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "onschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={"abstract": False},
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="ProtocolDeviationViolation",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(max_length=50, verbose_name="Subject Identifier"),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "report_type",
                    models.CharField(
                        choices=[
                            ("protocol_violation", "Protocol violation"),
                            ("protocol_deviation", "Protocol deviation"),
                        ],
                        max_length=25,
                        verbose_name="Type of occurrence",
                    ),
                ),
                (
                    "safety_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on safety of the participant?",
                    ),
                ),
                (
                    "safety_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "study_outcomes_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on study outcomes?",
                    ),
                ),
                (
                    "study_outcomes_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "violation_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Date violation occurred",
                    ),
                ),
                (
                    "violation_type",
                    models.CharField(
                        choices=[
                            (
                                "failure_to_obtain_informed_consent",
                                "Failure to obtain informed consent",
                            ),
                            (
                                "enrollment_of_ineligible_patient",
                                "Enrollment of ineligible patient",
                            ),
                            (
                                "screening_procedure not done",
                                "Screening procedure required by protocol not done",
                            ),
                            (
                                "screening_or_on-study_procedure",
                                "Screening or on-study procedure/lab work required not done",
                            ),
                            (
                                "incorrect_research_treatment",
                                "Incorrect research treatment given to patient",
                            ),
                            (
                                "procedure_not_completed",
                                "On-study procedure required by protocol not completed",
                            ),
                            ("visit_non-compliance", "Visit non-compliance"),
                            ("medication_stopped_early", "Medication stopped early"),
                            ("medication_noncompliance", "Medication_noncompliance"),
                            (
                                "national_regulations_not_met",
                                "Standard WPD, ICH-GCP, local/national regulations not met",
                            ),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=75,
                        verbose_name="Type of violation",
                    ),
                ),
                (
                    "violation_type_other",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If other, please specify",
                    ),
                ),
                (
                    "violation_description",
                    models.TextField(
                        blank=True,
                        help_text="Describe in full. Explain how the violation happened, what occurred, etc.",
                        null=True,
                        verbose_name="Describe the violation",
                    ),
                ),
                (
                    "violation_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Explain the reason why the violation occurred",
                    ),
                ),
                (
                    "corrective_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Corrective action date and time",
                    ),
                ),
                (
                    "corrective_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Corrective action taken"
                    ),
                ),
                (
                    "preventative_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Preventative action date and time",
                    ),
                ),
                (
                    "preventative_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Preventative action taken"
                    ),
                ),
                (
                    "action_required",
                    models.CharField(
                        choices=[
                            ("remain_on_study", "Participant to remain on trial"),
                            (
                                "to_be_withdrawn",
                                "Participant to be withdrawn from trial",
                            ),
                            (
                                "remain_on_study_modified",
                                "Patient remains on study but data analysis will be modified",
                            ),
                        ],
                        max_length=45,
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Protocol Deviation/Violation",
                "verbose_name_plural": "Protocol Deviations/Violations",
            },
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="StudyTerminationConclusion",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject Identifier"
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "offschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Date and time subject taken off schedule",
                    ),
                ),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "last_study_fu_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of last research follow up (if different):",
                    ),
                ),
                (
                    "discharged_after_initial_admission",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=6,
                        verbose_name="Was the patient discharged after initial admission?",
                    ),
                ),
                (
                    "initial_discharge_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of initial discharge",
                    ),
                ),
                (
                    "readmission_after_initial_discharge",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=7,
                        verbose_name="Was the patient re-admitted following initial discharge?",
                    ),
                ),
                (
                    "readmission_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of readmission",
                    ),
                ),
                (
                    "discharged_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date discharged",
                    ),
                ),
                (
                    "termination_reason",
                    models.CharField(
                        choices=[
                            (
                                "10_weeks_completed_follow_up",
                                "Patient completed 10 weeks of follow-up",
                            ),
                            ("patient_lost_to_follow_up", "Patient lost to follow-up"),
                            ("dead", "Reported/known to have died"),
                            (
                                "consent_withdrawn",
                                "Withdrawal of Subject Consent for participation",
                            ),
                            (
                                "care_transferred_to_another_institution",
                                "Care transferred to another institution",
                            ),
                            (
                                "late_exclusion_criteria_met",
                                "Late exclusion criteria met",
                            ),
                            ("included_in_error", "Included in error"),
                        ],
                        help_text="If included in error, be sure to fill in protocol deviation form.",
                        max_length=75,
                        verbose_name="Reason for study termination",
                    ),
                ),
                (
                    "death_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of Death",
                    ),
                ),
                (
                    "consent_withdrawal_reason",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="Reason for withdrawing consent",
                    ),
                ),
                (
                    "willing_to_complete_10w",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=12,
                        verbose_name="Is the patient willing to complete the W10 and W16 FU visit only?",
                    ),
                ),
                (
                    "willing_to_complete_centre",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=17,
                        verbose_name="Is the patient willing to complete the W10and W16 FU visit only at their new care centre?",
                    ),
                ),
                (
                    "willing_to_complete_date",
                    models.DateField(
                        editable=False,
                        help_text="get value from Ambition visit schedule",
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date the 10W FU due",
                    ),
                ),
                (
                    "protocol_exclusion_criterion",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=12,
                        verbose_name="Late protocol exclusion met?",
                    ),
                ),
                (
                    "included_in_error_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="If included in error, date",
                    ),
                ),
                (
                    "included_in_error",
                    models.TextField(
                        blank=True,
                        max_length=300,
                        null=True,
                        verbose_name="If included in error, narrative:",
                    ),
                ),
                (
                    "rifampicin_started",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("already_on_rifampicin", "Already on Rifampicin"),
                        ],
                        max_length=30,
                        verbose_name="Rifampicin started since week 4?",
                    ),
                ),
                (
                    "first_line_regimen",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "TDF_3TC_FTC_with_EFV_or_NVP",
                                "TDF + 3TC/FTC + either EFV or NVP or DTG",
                            ),
                            (
                                "AZT_3TC_with_EFV_NVP_or_DTG",
                                "AZT+3TC+ either EFV or NVP or DTG",
                            ),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=75,
                        verbose_name="ART regimen started for naive patients (or regimen switched for those already on ARVs)",
                    ),
                ),
                (
                    "first_line_regimen_other",
                    edc_model_fields.fields.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "second_line_regimen",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "TDF_3TC_FTC_with_ATZ_r_or_Lopinavir_r",
                                "TDF + 3TC/FTC + either ATZ/r or Lopinavir/r",
                            ),
                            (
                                "AZT_3TC_with_ATZ_r_or_Lopinavir_r",
                                "AZT +3TC + either ATZ/r or Lopinavir/r",
                            ),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="Second line / second switch ARV regimen",
                    ),
                ),
                (
                    "second_line_regimen_other",
                    edc_model_fields.fields.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "arvs_switch_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="ARV switch date",
                    ),
                ),
                (
                    "first_line_choice",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("EFV", "EFV"),
                            ("DTG", "DTG"),
                            ("NVP", "NVP"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=5,
                        verbose_name="If first line:",
                    ),
                ),
                (
                    "arvs_delay_reason",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="Reason ARVs not started",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Study Termination/Conclusion",
                "verbose_name_plural": "Study Terminations/Conclusions",
            },
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="StudyTerminationConclusionW10",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_base.utils.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    edc_model_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject Identifier"
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "offschedule_datetime",
                    models.DateTimeField(
                        default=edc_base.utils.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_base.model_validators.date.datetime_not_future,
                        ],
                        verbose_name="Date and time subject taken off schedule",
                    ),
                ),
                ("action_identifier", models.CharField(max_length=25, null=True)),
                (
                    "last_study_fu_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of last research follow up (if different):",
                    ),
                ),
                (
                    "termination_reason",
                    models.CharField(
                        choices=[
                            (
                                "16_weeks_completed_follow_up",
                                "Patient completed 16 weeks of follow-up",
                            ),
                            ("patient_lost_to_follow_up", "Patient lost to follow-up"),
                            ("dead", "Reported/known to have died"),
                            (
                                "consent_withdrawn",
                                "Withdrawal of Subject Consent for participation",
                            ),
                            (
                                "care_transferred_to_another_institution",
                                "Care transferred to another institution",
                            ),
                            ("included_in_error", "Included in error"),
                        ],
                        help_text="If included in error, be sure to fill in protocol deviation form.",
                        max_length=75,
                        verbose_name="Reason for study termination",
                    ),
                ),
                (
                    "death_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_base.model_validators.date.date_not_future],
                        verbose_name="Date of Death",
                    ),
                ),
                (
                    "consent_withdrawal_reason",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="Reason for withdrawing consent",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "W10 Study Termination/Conclusion",
                "verbose_name_plural": "W10 Study Terminations/Conclusions",
            },
            managers=[("on_site", edc_base.sites.managers.CurrentSiteManager())],
        ),
    ]
