from edc_base.model_managers import HistoricalRecords
from edc_base.model_mixins import BaseUuidModel

from .missed_doses_model_mixin import MissedDosesManager, MissedDosesModelMixin


class FluconazoleMissedDoses(MissedDosesModelMixin, BaseUuidModel):

    objects = MissedDosesManager()

    history = HistoricalRecords()

    def natural_key(self):
        return (self.day_missed,) + self.study_termination_conclusion.natural_key()

    natural_key.dependencies = ["ambition_prn.study_termination_conclusion"]

    class Meta:
        verbose_name_plural = "Fluconazole Missed Doses"
        unique_together = ("study_termination_conclusion", "day_missed")
