/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeDatabaseRolesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#id DataSnowflakeDatabaseRoles#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The database from which to return the database roles from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#in_database DataSnowflakeDatabaseRoles#in_database}
    */
    readonly inDatabase: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#like DataSnowflakeDatabaseRoles#like}
    */
    readonly like?: string;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#limit DataSnowflakeDatabaseRoles#limit}
    */
    readonly limit?: DataSnowflakeDatabaseRolesLimit;
}
export interface DataSnowflakeDatabaseRolesDatabaseRolesShowOutput {
}
export declare function dataSnowflakeDatabaseRolesDatabaseRolesShowOutputToTerraform(struct?: DataSnowflakeDatabaseRolesDatabaseRolesShowOutput): any;
export declare function dataSnowflakeDatabaseRolesDatabaseRolesShowOutputToHclTerraform(struct?: DataSnowflakeDatabaseRolesDatabaseRolesShowOutput): any;
export declare class DataSnowflakeDatabaseRolesDatabaseRolesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabaseRolesDatabaseRolesShowOutput | undefined;
    set internalValue(value: DataSnowflakeDatabaseRolesDatabaseRolesShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get grantedDatabaseRoles(): number;
    get grantedToDatabaseRoles(): number;
    get grantedToRoles(): number;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get isInherited(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
}
export declare class DataSnowflakeDatabaseRolesDatabaseRolesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabaseRolesDatabaseRolesShowOutputOutputReference;
}
export interface DataSnowflakeDatabaseRolesDatabaseRoles {
}
export declare function dataSnowflakeDatabaseRolesDatabaseRolesToTerraform(struct?: DataSnowflakeDatabaseRolesDatabaseRoles): any;
export declare function dataSnowflakeDatabaseRolesDatabaseRolesToHclTerraform(struct?: DataSnowflakeDatabaseRolesDatabaseRoles): any;
export declare class DataSnowflakeDatabaseRolesDatabaseRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabaseRolesDatabaseRoles | undefined;
    set internalValue(value: DataSnowflakeDatabaseRolesDatabaseRoles | undefined);
    private _showOutput;
    get showOutput(): DataSnowflakeDatabaseRolesDatabaseRolesShowOutputList;
}
export declare class DataSnowflakeDatabaseRolesDatabaseRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabaseRolesDatabaseRolesOutputReference;
}
export interface DataSnowflakeDatabaseRolesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#from DataSnowflakeDatabaseRoles#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#rows DataSnowflakeDatabaseRoles#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeDatabaseRolesLimitToTerraform(struct?: DataSnowflakeDatabaseRolesLimitOutputReference | DataSnowflakeDatabaseRolesLimit): any;
export declare function dataSnowflakeDatabaseRolesLimitToHclTerraform(struct?: DataSnowflakeDatabaseRolesLimitOutputReference | DataSnowflakeDatabaseRolesLimit): any;
export declare class DataSnowflakeDatabaseRolesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeDatabaseRolesLimit | undefined;
    set internalValue(value: DataSnowflakeDatabaseRolesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles snowflake_database_roles}
*/
export declare class DataSnowflakeDatabaseRoles extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_database_roles";
    /**
    * Generates CDKTF code for importing a DataSnowflakeDatabaseRoles resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeDatabaseRoles to import
    * @param importFromId The id of the existing DataSnowflakeDatabaseRoles that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeDatabaseRoles to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/database_roles snowflake_database_roles} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeDatabaseRolesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeDatabaseRolesConfig);
    private _databaseRoles;
    get databaseRoles(): DataSnowflakeDatabaseRolesDatabaseRolesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    get inDatabaseInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _limit;
    get limit(): DataSnowflakeDatabaseRolesLimitOutputReference;
    putLimit(value: DataSnowflakeDatabaseRolesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeDatabaseRolesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
