/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeWarehousesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses#id DataSnowflakeWarehouses#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses#like DataSnowflakeWarehouses#like}
    */
    readonly like?: string;
    /**
    * Runs DESC WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses#with_describe DataSnowflakeWarehouses#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * Runs SHOW PARAMETERS FOR WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the parameters field as a map. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses#with_parameters DataSnowflakeWarehouses#with_parameters}
    */
    readonly withParameters?: boolean | cdktf.IResolvable;
}
export interface DataSnowflakeWarehousesWarehousesDescribeOutput {
}
export declare function dataSnowflakeWarehousesWarehousesDescribeOutputToTerraform(struct?: DataSnowflakeWarehousesWarehousesDescribeOutput): any;
export declare function dataSnowflakeWarehousesWarehousesDescribeOutputToHclTerraform(struct?: DataSnowflakeWarehousesWarehousesDescribeOutput): any;
export declare class DataSnowflakeWarehousesWarehousesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehousesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehousesDescribeOutput | undefined);
    get createdOn(): string;
    get kind(): string;
    get name(): string;
}
export declare class DataSnowflakeWarehousesWarehousesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesDescribeOutputOutputReference;
}
export interface DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevel {
}
export declare function dataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevelToTerraform(struct?: DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevel): any;
export declare function dataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevelToHclTerraform(struct?: DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevel): any;
export declare class DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevel | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevelOutputReference;
}
export interface DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSeconds {
}
export declare function dataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSeconds): any;
export declare function dataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSeconds): any;
export declare class DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSeconds {
}
export declare function dataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSecondsToTerraform(struct?: DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSeconds): any;
export declare function dataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSecondsToHclTerraform(struct?: DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSeconds): any;
export declare class DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSecondsOutputReference;
}
export interface DataSnowflakeWarehousesWarehousesParameters {
}
export declare function dataSnowflakeWarehousesWarehousesParametersToTerraform(struct?: DataSnowflakeWarehousesWarehousesParameters): any;
export declare function dataSnowflakeWarehousesWarehousesParametersToHclTerraform(struct?: DataSnowflakeWarehousesWarehousesParameters): any;
export declare class DataSnowflakeWarehousesWarehousesParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehousesParameters | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehousesParameters | undefined);
    private _maxConcurrencyLevel;
    get maxConcurrencyLevel(): DataSnowflakeWarehousesWarehousesParametersMaxConcurrencyLevelList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): DataSnowflakeWarehousesWarehousesParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): DataSnowflakeWarehousesWarehousesParametersStatementTimeoutInSecondsList;
}
export declare class DataSnowflakeWarehousesWarehousesParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesParametersOutputReference;
}
export interface DataSnowflakeWarehousesWarehousesShowOutput {
}
export declare function dataSnowflakeWarehousesWarehousesShowOutputToTerraform(struct?: DataSnowflakeWarehousesWarehousesShowOutput): any;
export declare function dataSnowflakeWarehousesWarehousesShowOutputToHclTerraform(struct?: DataSnowflakeWarehousesWarehousesShowOutput): any;
export declare class DataSnowflakeWarehousesWarehousesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehousesShowOutput | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehousesShowOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspend(): number;
    get available(): number;
    get comment(): string;
    get createdOn(): string;
    get enableQueryAcceleration(): cdktf.IResolvable;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get maxClusterCount(): number;
    get minClusterCount(): number;
    get name(): string;
    get other(): number;
    get owner(): string;
    get ownerRoleType(): string;
    get provisioning(): number;
    get queryAccelerationMaxScaleFactor(): number;
    get queued(): number;
    get quiescing(): number;
    get resourceMonitor(): string;
    get resumedOn(): string;
    get running(): number;
    get scalingPolicy(): string;
    get size(): string;
    get startedClusters(): number;
    get state(): string;
    get type(): string;
    get updatedOn(): string;
}
export declare class DataSnowflakeWarehousesWarehousesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesShowOutputOutputReference;
}
export interface DataSnowflakeWarehousesWarehouses {
}
export declare function dataSnowflakeWarehousesWarehousesToTerraform(struct?: DataSnowflakeWarehousesWarehouses): any;
export declare function dataSnowflakeWarehousesWarehousesToHclTerraform(struct?: DataSnowflakeWarehousesWarehouses): any;
export declare class DataSnowflakeWarehousesWarehousesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehouses | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehouses | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeWarehousesWarehousesDescribeOutputList;
    private _parameters;
    get parameters(): DataSnowflakeWarehousesWarehousesParametersList;
    private _showOutput;
    get showOutput(): DataSnowflakeWarehousesWarehousesShowOutputList;
}
export declare class DataSnowflakeWarehousesWarehousesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses snowflake_warehouses}
*/
export declare class DataSnowflakeWarehouses extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_warehouses";
    /**
    * Generates CDKTF code for importing a DataSnowflakeWarehouses resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeWarehouses to import
    * @param importFromId The id of the existing DataSnowflakeWarehouses that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeWarehouses to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/warehouses snowflake_warehouses} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeWarehousesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeWarehousesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _warehouses;
    get warehouses(): DataSnowflakeWarehousesWarehousesList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _withParameters?;
    get withParameters(): boolean | cdktf.IResolvable;
    set withParameters(value: boolean | cdktf.IResolvable);
    resetWithParameters(): void;
    get withParametersInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
