/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface Saml2IntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#allowed_email_patterns Saml2Integration#allowed_email_patterns}
    */
    readonly allowedEmailPatterns?: string[];
    /**
    * A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#allowed_user_domains Saml2Integration#allowed_user_domains}
    */
    readonly allowedUserDomains?: string[];
    /**
    * Specifies a comment for the integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#comment Saml2Integration#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#enabled Saml2Integration#enabled}
    */
    readonly enabled?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#id Saml2Integration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#name Saml2Integration#name}
    */
    readonly name: string;
    /**
    * The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_enable_sp_initiated Saml2Integration#saml2_enable_sp_initiated}
    */
    readonly saml2EnableSpInitiated?: string;
    /**
    * The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_force_authn Saml2Integration#saml2_force_authn}
    */
    readonly saml2ForceAuthn?: string;
    /**
    * The string containing the IdP EntityID / Issuer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_issuer Saml2Integration#saml2_issuer}
    */
    readonly saml2Issuer: string;
    /**
    * The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_post_logout_redirect_url Saml2Integration#saml2_post_logout_redirect_url}
    */
    readonly saml2PostLogoutRedirectUrl?: string;
    /**
    * The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_provider Saml2Integration#saml2_provider}
    */
    readonly saml2Provider: string;
    /**
    * The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_requested_nameid_format Saml2Integration#saml2_requested_nameid_format}
    */
    readonly saml2RequestedNameidFormat?: string;
    /**
    * The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_sign_request Saml2Integration#saml2_sign_request}
    */
    readonly saml2SignRequest?: string;
    /**
    * The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_snowflake_acs_url Saml2Integration#saml2_snowflake_acs_url}
    */
    readonly saml2SnowflakeAcsUrl?: string;
    /**
    * The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_snowflake_issuer_url Saml2Integration#saml2_snowflake_issuer_url}
    */
    readonly saml2SnowflakeIssuerUrl?: string;
    /**
    * The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_sp_initiated_login_page_label Saml2Integration#saml2_sp_initiated_login_page_label}
    */
    readonly saml2SpInitiatedLoginPageLabel?: string;
    /**
    * The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_sso_url Saml2Integration#saml2_sso_url}
    */
    readonly saml2SsoUrl: string;
    /**
    * The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#saml2_x509_cert Saml2Integration#saml2_x509_cert}
    */
    readonly saml2X509Cert: string;
}
export interface Saml2IntegrationDescribeOutputAllowedEmailPatterns {
}
export declare function saml2IntegrationDescribeOutputAllowedEmailPatternsToTerraform(struct?: Saml2IntegrationDescribeOutputAllowedEmailPatterns): any;
export declare function saml2IntegrationDescribeOutputAllowedEmailPatternsToHclTerraform(struct?: Saml2IntegrationDescribeOutputAllowedEmailPatterns): any;
export declare class Saml2IntegrationDescribeOutputAllowedEmailPatternsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputAllowedEmailPatterns | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputAllowedEmailPatterns | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputAllowedEmailPatternsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputAllowedEmailPatternsOutputReference;
}
export interface Saml2IntegrationDescribeOutputAllowedUserDomains {
}
export declare function saml2IntegrationDescribeOutputAllowedUserDomainsToTerraform(struct?: Saml2IntegrationDescribeOutputAllowedUserDomains): any;
export declare function saml2IntegrationDescribeOutputAllowedUserDomainsToHclTerraform(struct?: Saml2IntegrationDescribeOutputAllowedUserDomains): any;
export declare class Saml2IntegrationDescribeOutputAllowedUserDomainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputAllowedUserDomains | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputAllowedUserDomains | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputAllowedUserDomainsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputAllowedUserDomainsOutputReference;
}
export interface Saml2IntegrationDescribeOutputComment {
}
export declare function saml2IntegrationDescribeOutputCommentToTerraform(struct?: Saml2IntegrationDescribeOutputComment): any;
export declare function saml2IntegrationDescribeOutputCommentToHclTerraform(struct?: Saml2IntegrationDescribeOutputComment): any;
export declare class Saml2IntegrationDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputComment | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputCommentOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2DigestMethodsUsed {
}
export declare function saml2IntegrationDescribeOutputSaml2DigestMethodsUsedToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2DigestMethodsUsed): any;
export declare function saml2IntegrationDescribeOutputSaml2DigestMethodsUsedToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2DigestMethodsUsed): any;
export declare class Saml2IntegrationDescribeOutputSaml2DigestMethodsUsedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2DigestMethodsUsed | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2DigestMethodsUsed | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2DigestMethodsUsedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2DigestMethodsUsedOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2EnableSpInitiated {
}
export declare function saml2IntegrationDescribeOutputSaml2EnableSpInitiatedToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2EnableSpInitiated): any;
export declare function saml2IntegrationDescribeOutputSaml2EnableSpInitiatedToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2EnableSpInitiated): any;
export declare class Saml2IntegrationDescribeOutputSaml2EnableSpInitiatedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2EnableSpInitiated | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2EnableSpInitiated | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2EnableSpInitiatedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2EnableSpInitiatedOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2ForceAuthn {
}
export declare function saml2IntegrationDescribeOutputSaml2ForceAuthnToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2ForceAuthn): any;
export declare function saml2IntegrationDescribeOutputSaml2ForceAuthnToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2ForceAuthn): any;
export declare class Saml2IntegrationDescribeOutputSaml2ForceAuthnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2ForceAuthn | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2ForceAuthn | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2ForceAuthnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2ForceAuthnOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2Issuer {
}
export declare function saml2IntegrationDescribeOutputSaml2IssuerToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2Issuer): any;
export declare function saml2IntegrationDescribeOutputSaml2IssuerToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2Issuer): any;
export declare class Saml2IntegrationDescribeOutputSaml2IssuerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2Issuer | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2Issuer | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2IssuerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2IssuerOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrl {
}
export declare function saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrlToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrl): any;
export declare function saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrlToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrl): any;
export declare class Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrl | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrl | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrlOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2Provider {
}
export declare function saml2IntegrationDescribeOutputSaml2ProviderToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2Provider): any;
export declare function saml2IntegrationDescribeOutputSaml2ProviderToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2Provider): any;
export declare class Saml2IntegrationDescribeOutputSaml2ProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2Provider | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2Provider | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2ProviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2ProviderOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2RequestedNameidFormat {
}
export declare function saml2IntegrationDescribeOutputSaml2RequestedNameidFormatToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2RequestedNameidFormat): any;
export declare function saml2IntegrationDescribeOutputSaml2RequestedNameidFormatToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2RequestedNameidFormat): any;
export declare class Saml2IntegrationDescribeOutputSaml2RequestedNameidFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2RequestedNameidFormat | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2RequestedNameidFormat | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2RequestedNameidFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2RequestedNameidFormatOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SignRequest {
}
export declare function saml2IntegrationDescribeOutputSaml2SignRequestToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SignRequest): any;
export declare function saml2IntegrationDescribeOutputSaml2SignRequestToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SignRequest): any;
export declare class Saml2IntegrationDescribeOutputSaml2SignRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SignRequest | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SignRequest | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SignRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SignRequestOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsed {
}
export declare function saml2IntegrationDescribeOutputSaml2SignatureMethodsUsedToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsed): any;
export declare function saml2IntegrationDescribeOutputSaml2SignatureMethodsUsedToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsed): any;
export declare class Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsed | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsed | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsedOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrl {
}
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrlToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrl): any;
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrlToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrl): any;
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrl | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrl | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrlOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrl {
}
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrlToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrl): any;
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrlToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrl): any;
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrl | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrl | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrlOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SnowflakeMetadata {
}
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeMetadataToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeMetadata): any;
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeMetadataToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeMetadata): any;
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SnowflakeMetadata | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SnowflakeMetadata | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SnowflakeMetadataOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SnowflakeX509Cert {
}
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeX509CertToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeX509Cert): any;
export declare function saml2IntegrationDescribeOutputSaml2SnowflakeX509CertToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SnowflakeX509Cert): any;
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeX509CertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SnowflakeX509Cert | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SnowflakeX509Cert | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SnowflakeX509CertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SnowflakeX509CertOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabel {
}
export declare function saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabelToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabel): any;
export declare function saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabelToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabel): any;
export declare class Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabel | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabel | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabelOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2SsoUrl {
}
export declare function saml2IntegrationDescribeOutputSaml2SsoUrlToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SsoUrl): any;
export declare function saml2IntegrationDescribeOutputSaml2SsoUrlToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2SsoUrl): any;
export declare class Saml2IntegrationDescribeOutputSaml2SsoUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2SsoUrl | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2SsoUrl | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2SsoUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2SsoUrlOutputReference;
}
export interface Saml2IntegrationDescribeOutputSaml2X509Cert {
}
export declare function saml2IntegrationDescribeOutputSaml2X509CertToTerraform(struct?: Saml2IntegrationDescribeOutputSaml2X509Cert): any;
export declare function saml2IntegrationDescribeOutputSaml2X509CertToHclTerraform(struct?: Saml2IntegrationDescribeOutputSaml2X509Cert): any;
export declare class Saml2IntegrationDescribeOutputSaml2X509CertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutputSaml2X509Cert | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutputSaml2X509Cert | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class Saml2IntegrationDescribeOutputSaml2X509CertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputSaml2X509CertOutputReference;
}
export interface Saml2IntegrationDescribeOutput {
}
export declare function saml2IntegrationDescribeOutputToTerraform(struct?: Saml2IntegrationDescribeOutput): any;
export declare function saml2IntegrationDescribeOutputToHclTerraform(struct?: Saml2IntegrationDescribeOutput): any;
export declare class Saml2IntegrationDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationDescribeOutput | undefined;
    set internalValue(value: Saml2IntegrationDescribeOutput | undefined);
    private _allowedEmailPatterns;
    get allowedEmailPatterns(): Saml2IntegrationDescribeOutputAllowedEmailPatternsList;
    private _allowedUserDomains;
    get allowedUserDomains(): Saml2IntegrationDescribeOutputAllowedUserDomainsList;
    private _comment;
    get comment(): Saml2IntegrationDescribeOutputCommentList;
    private _saml2DigestMethodsUsed;
    get saml2DigestMethodsUsed(): Saml2IntegrationDescribeOutputSaml2DigestMethodsUsedList;
    private _saml2EnableSpInitiated;
    get saml2EnableSpInitiated(): Saml2IntegrationDescribeOutputSaml2EnableSpInitiatedList;
    private _saml2ForceAuthn;
    get saml2ForceAuthn(): Saml2IntegrationDescribeOutputSaml2ForceAuthnList;
    private _saml2Issuer;
    get saml2Issuer(): Saml2IntegrationDescribeOutputSaml2IssuerList;
    private _saml2PostLogoutRedirectUrl;
    get saml2PostLogoutRedirectUrl(): Saml2IntegrationDescribeOutputSaml2PostLogoutRedirectUrlList;
    private _saml2Provider;
    get saml2Provider(): Saml2IntegrationDescribeOutputSaml2ProviderList;
    private _saml2RequestedNameidFormat;
    get saml2RequestedNameidFormat(): Saml2IntegrationDescribeOutputSaml2RequestedNameidFormatList;
    private _saml2SignRequest;
    get saml2SignRequest(): Saml2IntegrationDescribeOutputSaml2SignRequestList;
    private _saml2SignatureMethodsUsed;
    get saml2SignatureMethodsUsed(): Saml2IntegrationDescribeOutputSaml2SignatureMethodsUsedList;
    private _saml2SnowflakeAcsUrl;
    get saml2SnowflakeAcsUrl(): Saml2IntegrationDescribeOutputSaml2SnowflakeAcsUrlList;
    private _saml2SnowflakeIssuerUrl;
    get saml2SnowflakeIssuerUrl(): Saml2IntegrationDescribeOutputSaml2SnowflakeIssuerUrlList;
    private _saml2SnowflakeMetadata;
    get saml2SnowflakeMetadata(): Saml2IntegrationDescribeOutputSaml2SnowflakeMetadataList;
    private _saml2SnowflakeX509Cert;
    get saml2SnowflakeX509Cert(): Saml2IntegrationDescribeOutputSaml2SnowflakeX509CertList;
    private _saml2SpInitiatedLoginPageLabel;
    get saml2SpInitiatedLoginPageLabel(): Saml2IntegrationDescribeOutputSaml2SpInitiatedLoginPageLabelList;
    private _saml2SsoUrl;
    get saml2SsoUrl(): Saml2IntegrationDescribeOutputSaml2SsoUrlList;
    private _saml2X509Cert;
    get saml2X509Cert(): Saml2IntegrationDescribeOutputSaml2X509CertList;
}
export declare class Saml2IntegrationDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationDescribeOutputOutputReference;
}
export interface Saml2IntegrationShowOutput {
}
export declare function saml2IntegrationShowOutputToTerraform(struct?: Saml2IntegrationShowOutput): any;
export declare function saml2IntegrationShowOutputToHclTerraform(struct?: Saml2IntegrationShowOutput): any;
export declare class Saml2IntegrationShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Saml2IntegrationShowOutput | undefined;
    set internalValue(value: Saml2IntegrationShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class Saml2IntegrationShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Saml2IntegrationShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration snowflake_saml2_integration}
*/
export declare class Saml2Integration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_saml2_integration";
    /**
    * Generates CDKTF code for importing a Saml2Integration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Saml2Integration to import
    * @param importFromId The id of the existing Saml2Integration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Saml2Integration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/saml2_integration snowflake_saml2_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Saml2IntegrationConfig
    */
    constructor(scope: Construct, id: string, config: Saml2IntegrationConfig);
    private _allowedEmailPatterns?;
    get allowedEmailPatterns(): string[];
    set allowedEmailPatterns(value: string[]);
    resetAllowedEmailPatterns(): void;
    get allowedEmailPatternsInput(): string[] | undefined;
    private _allowedUserDomains?;
    get allowedUserDomains(): string[];
    set allowedUserDomains(value: string[]);
    resetAllowedUserDomains(): void;
    get allowedUserDomainsInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): Saml2IntegrationDescribeOutputList;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _saml2EnableSpInitiated?;
    get saml2EnableSpInitiated(): string;
    set saml2EnableSpInitiated(value: string);
    resetSaml2EnableSpInitiated(): void;
    get saml2EnableSpInitiatedInput(): string | undefined;
    private _saml2ForceAuthn?;
    get saml2ForceAuthn(): string;
    set saml2ForceAuthn(value: string);
    resetSaml2ForceAuthn(): void;
    get saml2ForceAuthnInput(): string | undefined;
    private _saml2Issuer?;
    get saml2Issuer(): string;
    set saml2Issuer(value: string);
    get saml2IssuerInput(): string | undefined;
    private _saml2PostLogoutRedirectUrl?;
    get saml2PostLogoutRedirectUrl(): string;
    set saml2PostLogoutRedirectUrl(value: string);
    resetSaml2PostLogoutRedirectUrl(): void;
    get saml2PostLogoutRedirectUrlInput(): string | undefined;
    private _saml2Provider?;
    get saml2Provider(): string;
    set saml2Provider(value: string);
    get saml2ProviderInput(): string | undefined;
    private _saml2RequestedNameidFormat?;
    get saml2RequestedNameidFormat(): string;
    set saml2RequestedNameidFormat(value: string);
    resetSaml2RequestedNameidFormat(): void;
    get saml2RequestedNameidFormatInput(): string | undefined;
    private _saml2SignRequest?;
    get saml2SignRequest(): string;
    set saml2SignRequest(value: string);
    resetSaml2SignRequest(): void;
    get saml2SignRequestInput(): string | undefined;
    private _saml2SnowflakeAcsUrl?;
    get saml2SnowflakeAcsUrl(): string;
    set saml2SnowflakeAcsUrl(value: string);
    resetSaml2SnowflakeAcsUrl(): void;
    get saml2SnowflakeAcsUrlInput(): string | undefined;
    private _saml2SnowflakeIssuerUrl?;
    get saml2SnowflakeIssuerUrl(): string;
    set saml2SnowflakeIssuerUrl(value: string);
    resetSaml2SnowflakeIssuerUrl(): void;
    get saml2SnowflakeIssuerUrlInput(): string | undefined;
    private _saml2SpInitiatedLoginPageLabel?;
    get saml2SpInitiatedLoginPageLabel(): string;
    set saml2SpInitiatedLoginPageLabel(value: string);
    resetSaml2SpInitiatedLoginPageLabel(): void;
    get saml2SpInitiatedLoginPageLabelInput(): string | undefined;
    private _saml2SsoUrl?;
    get saml2SsoUrl(): string;
    set saml2SsoUrl(value: string);
    get saml2SsoUrlInput(): string | undefined;
    private _saml2X509Cert?;
    get saml2X509Cert(): string;
    set saml2X509Cert(value: string);
    get saml2X509CertInput(): string | undefined;
    private _showOutput;
    get showOutput(): Saml2IntegrationShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
