/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthenticationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of authentication methods that are allowed during login. This parameter accepts one or more of the following values: `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#authentication_methods AuthenticationPolicy#authentication_methods}
    */
    readonly authenticationMethods?: string[];
    /**
    * A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid CLIENT_TYPES, then the login attempt fails. Allowed values are `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL`. The CLIENT_TYPES property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#client_types AuthenticationPolicy#client_types}
    */
    readonly clientTypes?: string[];
    /**
    * Specifies a comment for the authentication policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#comment AuthenticationPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the authentication policy. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#database AuthenticationPolicy#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#id AuthenticationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#mfa_authentication_methods AuthenticationPolicy#mfa_authentication_methods}
    */
    readonly mfaAuthenticationMethods?: string[];
    /**
    * Determines whether a user must enroll in multi-factor authentication. Allowed values are REQUIRED and OPTIONAL. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the CLIENT_TYPES parameter must include SNOWFLAKE_UI, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#mfa_enrollment AuthenticationPolicy#mfa_enrollment}
    */
    readonly mfaEnrollment?: string;
    /**
    * Specifies the identifier for the authentication policy. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#name AuthenticationPolicy#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the authentication policy. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#schema AuthenticationPolicy#schema}
    */
    readonly schema: string;
    /**
    * A list of security integrations the authentication policy is associated with. This parameter has no effect when SAML or OAUTH are not in the AUTHENTICATION_METHODS list. All values in the SECURITY_INTEGRATIONS list must be compatible with the values in the AUTHENTICATION_METHODS list. For example, if SECURITY_INTEGRATIONS contains a SAML security integration, and AUTHENTICATION_METHODS contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use ALL as parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#security_integrations AuthenticationPolicy#security_integrations}
    */
    readonly securityIntegrations?: string[];
}
export interface AuthenticationPolicyDescribeOutput {
}
export declare function authenticationPolicyDescribeOutputToTerraform(struct?: AuthenticationPolicyDescribeOutput): any;
export declare function authenticationPolicyDescribeOutputToHclTerraform(struct?: AuthenticationPolicyDescribeOutput): any;
export declare class AuthenticationPolicyDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthenticationPolicyDescribeOutput | undefined;
    set internalValue(value: AuthenticationPolicyDescribeOutput | undefined);
    get authenticationMethods(): string;
    get clientTypes(): string;
    get comment(): string;
    get mfaAuthenticationMethods(): string;
    get mfaEnrollment(): string;
    get name(): string;
    get owner(): string;
    get securityIntegrations(): string;
}
export declare class AuthenticationPolicyDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthenticationPolicyDescribeOutputOutputReference;
}
export interface AuthenticationPolicyShowOutput {
}
export declare function authenticationPolicyShowOutputToTerraform(struct?: AuthenticationPolicyShowOutput): any;
export declare function authenticationPolicyShowOutputToHclTerraform(struct?: AuthenticationPolicyShowOutput): any;
export declare class AuthenticationPolicyShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthenticationPolicyShowOutput | undefined;
    set internalValue(value: AuthenticationPolicyShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get options(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class AuthenticationPolicyShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthenticationPolicyShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy snowflake_authentication_policy}
*/
export declare class AuthenticationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_authentication_policy";
    /**
    * Generates CDKTF code for importing a AuthenticationPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthenticationPolicy to import
    * @param importFromId The id of the existing AuthenticationPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthenticationPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/authentication_policy snowflake_authentication_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthenticationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: AuthenticationPolicyConfig);
    private _authenticationMethods?;
    get authenticationMethods(): string[];
    set authenticationMethods(value: string[]);
    resetAuthenticationMethods(): void;
    get authenticationMethodsInput(): string[] | undefined;
    private _clientTypes?;
    get clientTypes(): string[];
    set clientTypes(value: string[]);
    resetClientTypes(): void;
    get clientTypesInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): AuthenticationPolicyDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mfaAuthenticationMethods?;
    get mfaAuthenticationMethods(): string[];
    set mfaAuthenticationMethods(value: string[]);
    resetMfaAuthenticationMethods(): void;
    get mfaAuthenticationMethodsInput(): string[] | undefined;
    private _mfaEnrollment?;
    get mfaEnrollment(): string;
    set mfaEnrollment(value: string);
    resetMfaEnrollment(): void;
    get mfaEnrollmentInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _securityIntegrations?;
    get securityIntegrations(): string[];
    set securityIntegrations(value: string[]);
    resetSecurityIntegrations(): void;
    get securityIntegrationsInput(): string[] | undefined;
    private _showOutput;
    get showOutput(): AuthenticationPolicyShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
