/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeNetworkPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/network_policies#id DataSnowflakeNetworkPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/network_policies#like DataSnowflakeNetworkPolicies#like}
    */
    readonly like?: string;
    /**
    * Runs DESC NETWORK POLICY for each network policy returned by SHOW NETWORK POLICIES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/network_policies#with_describe DataSnowflakeNetworkPolicies#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
}
export interface DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutput {
}
export declare function dataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutputToTerraform(struct?: DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutput): any;
export declare function dataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutputToHclTerraform(struct?: DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutput): any;
export declare class DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutput | undefined);
    get allowedIpList(): string;
    get allowedNetworkRuleList(): string;
    get blockedIpList(): string;
    get blockedNetworkRuleList(): string;
}
export declare class DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutputOutputReference;
}
export interface DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutput {
}
export declare function dataSnowflakeNetworkPoliciesNetworkPoliciesShowOutputToTerraform(struct?: DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutput): any;
export declare function dataSnowflakeNetworkPoliciesNetworkPoliciesShowOutputToHclTerraform(struct?: DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutput): any;
export declare class DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutput | undefined;
    set internalValue(value: DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get entriesInAllowedIpList(): number;
    get entriesInAllowedNetworkRules(): number;
    get entriesInBlockedIpList(): number;
    get entriesInBlockedNetworkRules(): number;
    get name(): string;
}
export declare class DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutputOutputReference;
}
export interface DataSnowflakeNetworkPoliciesNetworkPolicies {
}
export declare function dataSnowflakeNetworkPoliciesNetworkPoliciesToTerraform(struct?: DataSnowflakeNetworkPoliciesNetworkPolicies): any;
export declare function dataSnowflakeNetworkPoliciesNetworkPoliciesToHclTerraform(struct?: DataSnowflakeNetworkPoliciesNetworkPolicies): any;
export declare class DataSnowflakeNetworkPoliciesNetworkPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeNetworkPoliciesNetworkPolicies | undefined;
    set internalValue(value: DataSnowflakeNetworkPoliciesNetworkPolicies | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeNetworkPoliciesNetworkPoliciesDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeNetworkPoliciesNetworkPoliciesShowOutputList;
}
export declare class DataSnowflakeNetworkPoliciesNetworkPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeNetworkPoliciesNetworkPoliciesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/network_policies snowflake_network_policies}
*/
export declare class DataSnowflakeNetworkPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_network_policies";
    /**
    * Generates CDKTF code for importing a DataSnowflakeNetworkPolicies resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeNetworkPolicies to import
    * @param importFromId The id of the existing DataSnowflakeNetworkPolicies that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/network_policies#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeNetworkPolicies to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/data-sources/network_policies snowflake_network_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeNetworkPoliciesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeNetworkPoliciesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _networkPolicies;
    get networkPolicies(): DataSnowflakeNetworkPoliciesNetworkPoliciesList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
