/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotificationIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#aws_sns_role_arn NotificationIntegration#aws_sns_role_arn}
    */
    readonly awsSnsRoleArn?: string;
    /**
    * AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#aws_sns_topic_arn NotificationIntegration#aws_sns_topic_arn}
    */
    readonly awsSnsTopicArn?: string;
    /**
    * AWS SQS queue ARN for notification integration to connect to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#aws_sqs_arn NotificationIntegration#aws_sqs_arn}
    */
    readonly awsSqsArn?: string;
    /**
    * AWS IAM role ARN for notification integration to assume
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#aws_sqs_role_arn NotificationIntegration#aws_sqs_role_arn}
    */
    readonly awsSqsRoleArn?: string;
    /**
    * The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE_STORAGE_QUEUE provider
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#azure_storage_queue_primary_uri NotificationIntegration#azure_storage_queue_primary_uri}
    */
    readonly azureStorageQueuePrimaryUri?: string;
    /**
    * The ID of the Azure Active Directory tenant used for identity management. Required for AZURE_STORAGE_QUEUE provider
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#azure_tenant_id NotificationIntegration#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * A comment for the integration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#comment NotificationIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#direction NotificationIntegration#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#enabled NotificationIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#gcp_pubsub_subscription_name NotificationIntegration#gcp_pubsub_subscription_name}
    */
    readonly gcpPubsubSubscriptionName?: string;
    /**
    * The topic id that Snowflake will use to push notifications.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#gcp_pubsub_topic_name NotificationIntegration#gcp_pubsub_topic_name}
    */
    readonly gcpPubsubTopicName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#id NotificationIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#name NotificationIntegration#name}
    */
    readonly name: string;
    /**
    * The third-party cloud message queuing service (supported values: AZURE_STORAGE_QUEUE, AWS_SNS, GCP_PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#notification_provider NotificationIntegration#notification_provider}
    */
    readonly notificationProvider: string;
    /**
    * A type of integration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#type NotificationIntegration#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration snowflake_notification_integration}
*/
export declare class NotificationIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_notification_integration";
    /**
    * Generates CDKTF code for importing a NotificationIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NotificationIntegration to import
    * @param importFromId The id of the existing NotificationIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NotificationIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/notification_integration snowflake_notification_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotificationIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: NotificationIntegrationConfig);
    get awsSnsExternalId(): string;
    get awsSnsIamUserArn(): string;
    private _awsSnsRoleArn?;
    get awsSnsRoleArn(): string;
    set awsSnsRoleArn(value: string);
    resetAwsSnsRoleArn(): void;
    get awsSnsRoleArnInput(): string | undefined;
    private _awsSnsTopicArn?;
    get awsSnsTopicArn(): string;
    set awsSnsTopicArn(value: string);
    resetAwsSnsTopicArn(): void;
    get awsSnsTopicArnInput(): string | undefined;
    private _awsSqsArn?;
    get awsSqsArn(): string;
    set awsSqsArn(value: string);
    resetAwsSqsArn(): void;
    get awsSqsArnInput(): string | undefined;
    get awsSqsExternalId(): string;
    get awsSqsIamUserArn(): string;
    private _awsSqsRoleArn?;
    get awsSqsRoleArn(): string;
    set awsSqsRoleArn(value: string);
    resetAwsSqsRoleArn(): void;
    get awsSqsRoleArnInput(): string | undefined;
    private _azureStorageQueuePrimaryUri?;
    get azureStorageQueuePrimaryUri(): string;
    set azureStorageQueuePrimaryUri(value: string);
    resetAzureStorageQueuePrimaryUri(): void;
    get azureStorageQueuePrimaryUriInput(): string | undefined;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    get gcpPubsubServiceAccount(): string;
    private _gcpPubsubSubscriptionName?;
    get gcpPubsubSubscriptionName(): string;
    set gcpPubsubSubscriptionName(value: string);
    resetGcpPubsubSubscriptionName(): void;
    get gcpPubsubSubscriptionNameInput(): string | undefined;
    private _gcpPubsubTopicName?;
    get gcpPubsubTopicName(): string;
    set gcpPubsubTopicName(value: string);
    resetGcpPubsubTopicName(): void;
    get gcpPubsubTopicNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notificationProvider?;
    get notificationProvider(): string;
    set notificationProvider(value: string);
    get notificationProviderInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
