"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeProvider = exports.snowflakeProviderTokenAccessorToHclTerraform = exports.snowflakeProviderTokenAccessorToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function snowflakeProviderTokenAccessorToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        client_id: cdktf.stringToTerraform(struct.clientId),
        client_secret: cdktf.stringToTerraform(struct.clientSecret),
        redirect_uri: cdktf.stringToTerraform(struct.redirectUri),
        refresh_token: cdktf.stringToTerraform(struct.refreshToken),
        token_endpoint: cdktf.stringToTerraform(struct.tokenEndpoint),
    };
}
exports.snowflakeProviderTokenAccessorToTerraform = snowflakeProviderTokenAccessorToTerraform;
function snowflakeProviderTokenAccessorToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        client_id: {
            value: cdktf.stringToHclTerraform(struct.clientId),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        client_secret: {
            value: cdktf.stringToHclTerraform(struct.clientSecret),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        redirect_uri: {
            value: cdktf.stringToHclTerraform(struct.redirectUri),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        refresh_token: {
            value: cdktf.stringToHclTerraform(struct.refreshToken),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        token_endpoint: {
            value: cdktf.stringToHclTerraform(struct.tokenEndpoint),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.snowflakeProviderTokenAccessorToHclTerraform = snowflakeProviderTokenAccessorToHclTerraform;
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs snowflake}
*/
class SnowflakeProvider extends cdktf.TerraformProvider {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a SnowflakeProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SnowflakeProvider to import
    * @param importFromId The id of the existing SnowflakeProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SnowflakeProvider to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'snowflake',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.99.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            terraformProviderSource: 'Snowflake-Labs/snowflake'
        });
        this._account = config.account;
        this._accountName = config.accountName;
        this._authenticator = config.authenticator;
        this._browserAuth = config.browserAuth;
        this._clientIp = config.clientIp;
        this._clientRequestMfaToken = config.clientRequestMfaToken;
        this._clientStoreTemporaryCredential = config.clientStoreTemporaryCredential;
        this._clientTimeout = config.clientTimeout;
        this._disableConsoleLogin = config.disableConsoleLogin;
        this._disableQueryContextCache = config.disableQueryContextCache;
        this._disableTelemetry = config.disableTelemetry;
        this._driverTracing = config.driverTracing;
        this._externalBrowserTimeout = config.externalBrowserTimeout;
        this._host = config.host;
        this._includeRetryReason = config.includeRetryReason;
        this._insecureMode = config.insecureMode;
        this._jwtClientTimeout = config.jwtClientTimeout;
        this._jwtExpireTimeout = config.jwtExpireTimeout;
        this._keepSessionAlive = config.keepSessionAlive;
        this._loginTimeout = config.loginTimeout;
        this._maxRetryCount = config.maxRetryCount;
        this._oauthAccessToken = config.oauthAccessToken;
        this._oauthClientId = config.oauthClientId;
        this._oauthClientSecret = config.oauthClientSecret;
        this._oauthEndpoint = config.oauthEndpoint;
        this._oauthRedirectUrl = config.oauthRedirectUrl;
        this._oauthRefreshToken = config.oauthRefreshToken;
        this._ocspFailOpen = config.ocspFailOpen;
        this._oktaUrl = config.oktaUrl;
        this._organizationName = config.organizationName;
        this._params = config.params;
        this._passcode = config.passcode;
        this._passcodeInPassword = config.passcodeInPassword;
        this._password = config.password;
        this._port = config.port;
        this._privateKey = config.privateKey;
        this._privateKeyPassphrase = config.privateKeyPassphrase;
        this._privateKeyPath = config.privateKeyPath;
        this._profile = config.profile;
        this._protocol = config.protocol;
        this._region = config.region;
        this._requestTimeout = config.requestTimeout;
        this._role = config.role;
        this._sessionParams = config.sessionParams;
        this._tmpDirectoryPath = config.tmpDirectoryPath;
        this._token = config.token;
        this._user = config.user;
        this._username = config.username;
        this._validateDefaultParameters = config.validateDefaultParameters;
        this._warehouse = config.warehouse;
        this._alias = config.alias;
        this._tokenAccessor = config.tokenAccessor;
    }
    get account() {
        return this._account;
    }
    set account(value) {
        this._account = value;
    }
    resetAccount() {
        this._account = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountInput() {
        return this._account;
    }
    get accountName() {
        return this._accountName;
    }
    set accountName(value) {
        this._accountName = value;
    }
    resetAccountName() {
        this._accountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountNameInput() {
        return this._accountName;
    }
    get authenticator() {
        return this._authenticator;
    }
    set authenticator(value) {
        this._authenticator = value;
    }
    resetAuthenticator() {
        this._authenticator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authenticatorInput() {
        return this._authenticator;
    }
    get browserAuth() {
        return this._browserAuth;
    }
    set browserAuth(value) {
        this._browserAuth = value;
    }
    resetBrowserAuth() {
        this._browserAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get browserAuthInput() {
        return this._browserAuth;
    }
    get clientIp() {
        return this._clientIp;
    }
    set clientIp(value) {
        this._clientIp = value;
    }
    resetClientIp() {
        this._clientIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIpInput() {
        return this._clientIp;
    }
    get clientRequestMfaToken() {
        return this._clientRequestMfaToken;
    }
    set clientRequestMfaToken(value) {
        this._clientRequestMfaToken = value;
    }
    resetClientRequestMfaToken() {
        this._clientRequestMfaToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientRequestMfaTokenInput() {
        return this._clientRequestMfaToken;
    }
    get clientStoreTemporaryCredential() {
        return this._clientStoreTemporaryCredential;
    }
    set clientStoreTemporaryCredential(value) {
        this._clientStoreTemporaryCredential = value;
    }
    resetClientStoreTemporaryCredential() {
        this._clientStoreTemporaryCredential = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientStoreTemporaryCredentialInput() {
        return this._clientStoreTemporaryCredential;
    }
    get clientTimeout() {
        return this._clientTimeout;
    }
    set clientTimeout(value) {
        this._clientTimeout = value;
    }
    resetClientTimeout() {
        this._clientTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTimeoutInput() {
        return this._clientTimeout;
    }
    get disableConsoleLogin() {
        return this._disableConsoleLogin;
    }
    set disableConsoleLogin(value) {
        this._disableConsoleLogin = value;
    }
    resetDisableConsoleLogin() {
        this._disableConsoleLogin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableConsoleLoginInput() {
        return this._disableConsoleLogin;
    }
    get disableQueryContextCache() {
        return this._disableQueryContextCache;
    }
    set disableQueryContextCache(value) {
        this._disableQueryContextCache = value;
    }
    resetDisableQueryContextCache() {
        this._disableQueryContextCache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableQueryContextCacheInput() {
        return this._disableQueryContextCache;
    }
    get disableTelemetry() {
        return this._disableTelemetry;
    }
    set disableTelemetry(value) {
        this._disableTelemetry = value;
    }
    resetDisableTelemetry() {
        this._disableTelemetry = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTelemetryInput() {
        return this._disableTelemetry;
    }
    get driverTracing() {
        return this._driverTracing;
    }
    set driverTracing(value) {
        this._driverTracing = value;
    }
    resetDriverTracing() {
        this._driverTracing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get driverTracingInput() {
        return this._driverTracing;
    }
    get externalBrowserTimeout() {
        return this._externalBrowserTimeout;
    }
    set externalBrowserTimeout(value) {
        this._externalBrowserTimeout = value;
    }
    resetExternalBrowserTimeout() {
        this._externalBrowserTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalBrowserTimeoutInput() {
        return this._externalBrowserTimeout;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get includeRetryReason() {
        return this._includeRetryReason;
    }
    set includeRetryReason(value) {
        this._includeRetryReason = value;
    }
    resetIncludeRetryReason() {
        this._includeRetryReason = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeRetryReasonInput() {
        return this._includeRetryReason;
    }
    get insecureMode() {
        return this._insecureMode;
    }
    set insecureMode(value) {
        this._insecureMode = value;
    }
    resetInsecureMode() {
        this._insecureMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureModeInput() {
        return this._insecureMode;
    }
    get jwtClientTimeout() {
        return this._jwtClientTimeout;
    }
    set jwtClientTimeout(value) {
        this._jwtClientTimeout = value;
    }
    resetJwtClientTimeout() {
        this._jwtClientTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtClientTimeoutInput() {
        return this._jwtClientTimeout;
    }
    get jwtExpireTimeout() {
        return this._jwtExpireTimeout;
    }
    set jwtExpireTimeout(value) {
        this._jwtExpireTimeout = value;
    }
    resetJwtExpireTimeout() {
        this._jwtExpireTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtExpireTimeoutInput() {
        return this._jwtExpireTimeout;
    }
    get keepSessionAlive() {
        return this._keepSessionAlive;
    }
    set keepSessionAlive(value) {
        this._keepSessionAlive = value;
    }
    resetKeepSessionAlive() {
        this._keepSessionAlive = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepSessionAliveInput() {
        return this._keepSessionAlive;
    }
    get loginTimeout() {
        return this._loginTimeout;
    }
    set loginTimeout(value) {
        this._loginTimeout = value;
    }
    resetLoginTimeout() {
        this._loginTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loginTimeoutInput() {
        return this._loginTimeout;
    }
    get maxRetryCount() {
        return this._maxRetryCount;
    }
    set maxRetryCount(value) {
        this._maxRetryCount = value;
    }
    resetMaxRetryCount() {
        this._maxRetryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetryCountInput() {
        return this._maxRetryCount;
    }
    get oauthAccessToken() {
        return this._oauthAccessToken;
    }
    set oauthAccessToken(value) {
        this._oauthAccessToken = value;
    }
    resetOauthAccessToken() {
        this._oauthAccessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthAccessTokenInput() {
        return this._oauthAccessToken;
    }
    get oauthClientId() {
        return this._oauthClientId;
    }
    set oauthClientId(value) {
        this._oauthClientId = value;
    }
    resetOauthClientId() {
        this._oauthClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientIdInput() {
        return this._oauthClientId;
    }
    get oauthClientSecret() {
        return this._oauthClientSecret;
    }
    set oauthClientSecret(value) {
        this._oauthClientSecret = value;
    }
    resetOauthClientSecret() {
        this._oauthClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientSecretInput() {
        return this._oauthClientSecret;
    }
    get oauthEndpoint() {
        return this._oauthEndpoint;
    }
    set oauthEndpoint(value) {
        this._oauthEndpoint = value;
    }
    resetOauthEndpoint() {
        this._oauthEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthEndpointInput() {
        return this._oauthEndpoint;
    }
    get oauthRedirectUrl() {
        return this._oauthRedirectUrl;
    }
    set oauthRedirectUrl(value) {
        this._oauthRedirectUrl = value;
    }
    resetOauthRedirectUrl() {
        this._oauthRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRedirectUrlInput() {
        return this._oauthRedirectUrl;
    }
    get oauthRefreshToken() {
        return this._oauthRefreshToken;
    }
    set oauthRefreshToken(value) {
        this._oauthRefreshToken = value;
    }
    resetOauthRefreshToken() {
        this._oauthRefreshToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRefreshTokenInput() {
        return this._oauthRefreshToken;
    }
    get ocspFailOpen() {
        return this._ocspFailOpen;
    }
    set ocspFailOpen(value) {
        this._ocspFailOpen = value;
    }
    resetOcspFailOpen() {
        this._ocspFailOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ocspFailOpenInput() {
        return this._ocspFailOpen;
    }
    get oktaUrl() {
        return this._oktaUrl;
    }
    set oktaUrl(value) {
        this._oktaUrl = value;
    }
    resetOktaUrl() {
        this._oktaUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaUrlInput() {
        return this._oktaUrl;
    }
    get organizationName() {
        return this._organizationName;
    }
    set organizationName(value) {
        this._organizationName = value;
    }
    resetOrganizationName() {
        this._organizationName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get organizationNameInput() {
        return this._organizationName;
    }
    get params() {
        return this._params;
    }
    set params(value) {
        this._params = value;
    }
    resetParams() {
        this._params = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get paramsInput() {
        return this._params;
    }
    get passcode() {
        return this._passcode;
    }
    set passcode(value) {
        this._passcode = value;
    }
    resetPasscode() {
        this._passcode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passcodeInput() {
        return this._passcode;
    }
    get passcodeInPassword() {
        return this._passcodeInPassword;
    }
    set passcodeInPassword(value) {
        this._passcodeInPassword = value;
    }
    resetPasscodeInPassword() {
        this._passcodeInPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passcodeInPasswordInput() {
        return this._passcodeInPassword;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get port() {
        return this._port;
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get privateKey() {
        return this._privateKey;
    }
    set privateKey(value) {
        this._privateKey = value;
    }
    resetPrivateKey() {
        this._privateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyInput() {
        return this._privateKey;
    }
    get privateKeyPassphrase() {
        return this._privateKeyPassphrase;
    }
    set privateKeyPassphrase(value) {
        this._privateKeyPassphrase = value;
    }
    resetPrivateKeyPassphrase() {
        this._privateKeyPassphrase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPassphraseInput() {
        return this._privateKeyPassphrase;
    }
    get privateKeyPath() {
        return this._privateKeyPath;
    }
    set privateKeyPath(value) {
        this._privateKeyPath = value;
    }
    resetPrivateKeyPath() {
        this._privateKeyPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPathInput() {
        return this._privateKeyPath;
    }
    get profile() {
        return this._profile;
    }
    set profile(value) {
        this._profile = value;
    }
    resetProfile() {
        this._profile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileInput() {
        return this._profile;
    }
    get protocol() {
        return this._protocol;
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get requestTimeout() {
        return this._requestTimeout;
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get role() {
        return this._role;
    }
    set role(value) {
        this._role = value;
    }
    resetRole() {
        this._role = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get sessionParams() {
        return this._sessionParams;
    }
    set sessionParams(value) {
        this._sessionParams = value;
    }
    resetSessionParams() {
        this._sessionParams = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sessionParamsInput() {
        return this._sessionParams;
    }
    get tmpDirectoryPath() {
        return this._tmpDirectoryPath;
    }
    set tmpDirectoryPath(value) {
        this._tmpDirectoryPath = value;
    }
    resetTmpDirectoryPath() {
        this._tmpDirectoryPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tmpDirectoryPathInput() {
        return this._tmpDirectoryPath;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get user() {
        return this._user;
    }
    set user(value) {
        this._user = value;
    }
    resetUser() {
        this._user = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userInput() {
        return this._user;
    }
    get username() {
        return this._username;
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get validateDefaultParameters() {
        return this._validateDefaultParameters;
    }
    set validateDefaultParameters(value) {
        this._validateDefaultParameters = value;
    }
    resetValidateDefaultParameters() {
        this._validateDefaultParameters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateDefaultParametersInput() {
        return this._validateDefaultParameters;
    }
    get warehouse() {
        return this._warehouse;
    }
    set warehouse(value) {
        this._warehouse = value;
    }
    resetWarehouse() {
        this._warehouse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseInput() {
        return this._warehouse;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get tokenAccessor() {
        return this._tokenAccessor;
    }
    set tokenAccessor(value) {
        this._tokenAccessor = value;
    }
    resetTokenAccessor() {
        this._tokenAccessor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenAccessorInput() {
        return this._tokenAccessor;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account: cdktf.stringToTerraform(this._account),
            account_name: cdktf.stringToTerraform(this._accountName),
            authenticator: cdktf.stringToTerraform(this._authenticator),
            browser_auth: cdktf.booleanToTerraform(this._browserAuth),
            client_ip: cdktf.stringToTerraform(this._clientIp),
            client_request_mfa_token: cdktf.stringToTerraform(this._clientRequestMfaToken),
            client_store_temporary_credential: cdktf.stringToTerraform(this._clientStoreTemporaryCredential),
            client_timeout: cdktf.numberToTerraform(this._clientTimeout),
            disable_console_login: cdktf.stringToTerraform(this._disableConsoleLogin),
            disable_query_context_cache: cdktf.booleanToTerraform(this._disableQueryContextCache),
            disable_telemetry: cdktf.booleanToTerraform(this._disableTelemetry),
            driver_tracing: cdktf.stringToTerraform(this._driverTracing),
            external_browser_timeout: cdktf.numberToTerraform(this._externalBrowserTimeout),
            host: cdktf.stringToTerraform(this._host),
            include_retry_reason: cdktf.stringToTerraform(this._includeRetryReason),
            insecure_mode: cdktf.booleanToTerraform(this._insecureMode),
            jwt_client_timeout: cdktf.numberToTerraform(this._jwtClientTimeout),
            jwt_expire_timeout: cdktf.numberToTerraform(this._jwtExpireTimeout),
            keep_session_alive: cdktf.booleanToTerraform(this._keepSessionAlive),
            login_timeout: cdktf.numberToTerraform(this._loginTimeout),
            max_retry_count: cdktf.numberToTerraform(this._maxRetryCount),
            oauth_access_token: cdktf.stringToTerraform(this._oauthAccessToken),
            oauth_client_id: cdktf.stringToTerraform(this._oauthClientId),
            oauth_client_secret: cdktf.stringToTerraform(this._oauthClientSecret),
            oauth_endpoint: cdktf.stringToTerraform(this._oauthEndpoint),
            oauth_redirect_url: cdktf.stringToTerraform(this._oauthRedirectUrl),
            oauth_refresh_token: cdktf.stringToTerraform(this._oauthRefreshToken),
            ocsp_fail_open: cdktf.stringToTerraform(this._ocspFailOpen),
            okta_url: cdktf.stringToTerraform(this._oktaUrl),
            organization_name: cdktf.stringToTerraform(this._organizationName),
            params: cdktf.hashMapper(cdktf.stringToTerraform)(this._params),
            passcode: cdktf.stringToTerraform(this._passcode),
            passcode_in_password: cdktf.booleanToTerraform(this._passcodeInPassword),
            password: cdktf.stringToTerraform(this._password),
            port: cdktf.numberToTerraform(this._port),
            private_key: cdktf.stringToTerraform(this._privateKey),
            private_key_passphrase: cdktf.stringToTerraform(this._privateKeyPassphrase),
            private_key_path: cdktf.stringToTerraform(this._privateKeyPath),
            profile: cdktf.stringToTerraform(this._profile),
            protocol: cdktf.stringToTerraform(this._protocol),
            region: cdktf.stringToTerraform(this._region),
            request_timeout: cdktf.numberToTerraform(this._requestTimeout),
            role: cdktf.stringToTerraform(this._role),
            session_params: cdktf.hashMapper(cdktf.stringToTerraform)(this._sessionParams),
            tmp_directory_path: cdktf.stringToTerraform(this._tmpDirectoryPath),
            token: cdktf.stringToTerraform(this._token),
            user: cdktf.stringToTerraform(this._user),
            username: cdktf.stringToTerraform(this._username),
            validate_default_parameters: cdktf.stringToTerraform(this._validateDefaultParameters),
            warehouse: cdktf.stringToTerraform(this._warehouse),
            alias: cdktf.stringToTerraform(this._alias),
            token_accessor: snowflakeProviderTokenAccessorToTerraform(this._tokenAccessor),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            account: {
                value: cdktf.stringToHclTerraform(this._account),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            account_name: {
                value: cdktf.stringToHclTerraform(this._accountName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            authenticator: {
                value: cdktf.stringToHclTerraform(this._authenticator),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            browser_auth: {
                value: cdktf.booleanToHclTerraform(this._browserAuth),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            client_ip: {
                value: cdktf.stringToHclTerraform(this._clientIp),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_request_mfa_token: {
                value: cdktf.stringToHclTerraform(this._clientRequestMfaToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_store_temporary_credential: {
                value: cdktf.stringToHclTerraform(this._clientStoreTemporaryCredential),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_timeout: {
                value: cdktf.numberToHclTerraform(this._clientTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            disable_console_login: {
                value: cdktf.stringToHclTerraform(this._disableConsoleLogin),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            disable_query_context_cache: {
                value: cdktf.booleanToHclTerraform(this._disableQueryContextCache),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            disable_telemetry: {
                value: cdktf.booleanToHclTerraform(this._disableTelemetry),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            driver_tracing: {
                value: cdktf.stringToHclTerraform(this._driverTracing),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            external_browser_timeout: {
                value: cdktf.numberToHclTerraform(this._externalBrowserTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host: {
                value: cdktf.stringToHclTerraform(this._host),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            include_retry_reason: {
                value: cdktf.stringToHclTerraform(this._includeRetryReason),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            insecure_mode: {
                value: cdktf.booleanToHclTerraform(this._insecureMode),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            jwt_client_timeout: {
                value: cdktf.numberToHclTerraform(this._jwtClientTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            jwt_expire_timeout: {
                value: cdktf.numberToHclTerraform(this._jwtExpireTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            keep_session_alive: {
                value: cdktf.booleanToHclTerraform(this._keepSessionAlive),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            login_timeout: {
                value: cdktf.numberToHclTerraform(this._loginTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            max_retry_count: {
                value: cdktf.numberToHclTerraform(this._maxRetryCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            oauth_access_token: {
                value: cdktf.stringToHclTerraform(this._oauthAccessToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oauth_client_id: {
                value: cdktf.stringToHclTerraform(this._oauthClientId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oauth_client_secret: {
                value: cdktf.stringToHclTerraform(this._oauthClientSecret),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oauth_endpoint: {
                value: cdktf.stringToHclTerraform(this._oauthEndpoint),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oauth_redirect_url: {
                value: cdktf.stringToHclTerraform(this._oauthRedirectUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oauth_refresh_token: {
                value: cdktf.stringToHclTerraform(this._oauthRefreshToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ocsp_fail_open: {
                value: cdktf.stringToHclTerraform(this._ocspFailOpen),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            okta_url: {
                value: cdktf.stringToHclTerraform(this._oktaUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            organization_name: {
                value: cdktf.stringToHclTerraform(this._organizationName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            params: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._params),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            passcode: {
                value: cdktf.stringToHclTerraform(this._passcode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            passcode_in_password: {
                value: cdktf.booleanToHclTerraform(this._passcodeInPassword),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            password: {
                value: cdktf.stringToHclTerraform(this._password),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            port: {
                value: cdktf.numberToHclTerraform(this._port),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            private_key: {
                value: cdktf.stringToHclTerraform(this._privateKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            private_key_passphrase: {
                value: cdktf.stringToHclTerraform(this._privateKeyPassphrase),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            private_key_path: {
                value: cdktf.stringToHclTerraform(this._privateKeyPath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            profile: {
                value: cdktf.stringToHclTerraform(this._profile),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            protocol: {
                value: cdktf.stringToHclTerraform(this._protocol),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            region: {
                value: cdktf.stringToHclTerraform(this._region),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            request_timeout: {
                value: cdktf.numberToHclTerraform(this._requestTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            role: {
                value: cdktf.stringToHclTerraform(this._role),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            session_params: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._sessionParams),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            tmp_directory_path: {
                value: cdktf.stringToHclTerraform(this._tmpDirectoryPath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            token: {
                value: cdktf.stringToHclTerraform(this._token),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user: {
                value: cdktf.stringToHclTerraform(this._user),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            username: {
                value: cdktf.stringToHclTerraform(this._username),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            validate_default_parameters: {
                value: cdktf.stringToHclTerraform(this._validateDefaultParameters),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            warehouse: {
                value: cdktf.stringToHclTerraform(this._warehouse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            alias: {
                value: cdktf.stringToHclTerraform(this._alias),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            token_accessor: {
                value: snowflakeProviderTokenAccessorToHclTerraform(this._tokenAccessor),
                isBlock: true,
                type: "list",
                storageClassType: "SnowflakeProviderTokenAccessorList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.SnowflakeProvider = SnowflakeProvider;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeProvider[_a] = { fqn: "@cdktf/provider-snowflake.provider.SnowflakeProvider", version: "11.15.0" };
// =================
// STATIC PROPERTIES
// =================
SnowflakeProvider.tfResourceType = "snowflake";
//# sourceMappingURL=data:application/json;base64,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