/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ScimIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#comment ScimIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Specify whether the security integration is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#enabled ScimIntegration#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#id ScimIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#name ScimIntegration#name}
    */
    readonly name: string;
    /**
    * Specifies an existing network policy that controls SCIM network traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#network_policy ScimIntegration#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#run_as_role ScimIntegration#run_as_role}
    */
    readonly runAsRole: string;
    /**
    * Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#scim_client ScimIntegration#scim_client}
    */
    readonly scimClient: string;
    /**
    * Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#sync_password ScimIntegration#sync_password}
    */
    readonly syncPassword?: string;
}
export interface ScimIntegrationDescribeOutputComment {
}
export declare function scimIntegrationDescribeOutputCommentToTerraform(struct?: ScimIntegrationDescribeOutputComment): any;
export declare function scimIntegrationDescribeOutputCommentToHclTerraform(struct?: ScimIntegrationDescribeOutputComment): any;
export declare class ScimIntegrationDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationDescribeOutputComment | undefined;
    set internalValue(value: ScimIntegrationDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ScimIntegrationDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationDescribeOutputCommentOutputReference;
}
export interface ScimIntegrationDescribeOutputEnabled {
}
export declare function scimIntegrationDescribeOutputEnabledToTerraform(struct?: ScimIntegrationDescribeOutputEnabled): any;
export declare function scimIntegrationDescribeOutputEnabledToHclTerraform(struct?: ScimIntegrationDescribeOutputEnabled): any;
export declare class ScimIntegrationDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationDescribeOutputEnabled | undefined;
    set internalValue(value: ScimIntegrationDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ScimIntegrationDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationDescribeOutputEnabledOutputReference;
}
export interface ScimIntegrationDescribeOutputNetworkPolicy {
}
export declare function scimIntegrationDescribeOutputNetworkPolicyToTerraform(struct?: ScimIntegrationDescribeOutputNetworkPolicy): any;
export declare function scimIntegrationDescribeOutputNetworkPolicyToHclTerraform(struct?: ScimIntegrationDescribeOutputNetworkPolicy): any;
export declare class ScimIntegrationDescribeOutputNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationDescribeOutputNetworkPolicy | undefined;
    set internalValue(value: ScimIntegrationDescribeOutputNetworkPolicy | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ScimIntegrationDescribeOutputNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationDescribeOutputNetworkPolicyOutputReference;
}
export interface ScimIntegrationDescribeOutputRunAsRole {
}
export declare function scimIntegrationDescribeOutputRunAsRoleToTerraform(struct?: ScimIntegrationDescribeOutputRunAsRole): any;
export declare function scimIntegrationDescribeOutputRunAsRoleToHclTerraform(struct?: ScimIntegrationDescribeOutputRunAsRole): any;
export declare class ScimIntegrationDescribeOutputRunAsRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationDescribeOutputRunAsRole | undefined;
    set internalValue(value: ScimIntegrationDescribeOutputRunAsRole | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ScimIntegrationDescribeOutputRunAsRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationDescribeOutputRunAsRoleOutputReference;
}
export interface ScimIntegrationDescribeOutputSyncPassword {
}
export declare function scimIntegrationDescribeOutputSyncPasswordToTerraform(struct?: ScimIntegrationDescribeOutputSyncPassword): any;
export declare function scimIntegrationDescribeOutputSyncPasswordToHclTerraform(struct?: ScimIntegrationDescribeOutputSyncPassword): any;
export declare class ScimIntegrationDescribeOutputSyncPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationDescribeOutputSyncPassword | undefined;
    set internalValue(value: ScimIntegrationDescribeOutputSyncPassword | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ScimIntegrationDescribeOutputSyncPasswordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationDescribeOutputSyncPasswordOutputReference;
}
export interface ScimIntegrationDescribeOutput {
}
export declare function scimIntegrationDescribeOutputToTerraform(struct?: ScimIntegrationDescribeOutput): any;
export declare function scimIntegrationDescribeOutputToHclTerraform(struct?: ScimIntegrationDescribeOutput): any;
export declare class ScimIntegrationDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationDescribeOutput | undefined;
    set internalValue(value: ScimIntegrationDescribeOutput | undefined);
    private _comment;
    get comment(): ScimIntegrationDescribeOutputCommentList;
    private _enabled;
    get enabled(): ScimIntegrationDescribeOutputEnabledList;
    private _networkPolicy;
    get networkPolicy(): ScimIntegrationDescribeOutputNetworkPolicyList;
    private _runAsRole;
    get runAsRole(): ScimIntegrationDescribeOutputRunAsRoleList;
    private _syncPassword;
    get syncPassword(): ScimIntegrationDescribeOutputSyncPasswordList;
}
export declare class ScimIntegrationDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationDescribeOutputOutputReference;
}
export interface ScimIntegrationShowOutput {
}
export declare function scimIntegrationShowOutputToTerraform(struct?: ScimIntegrationShowOutput): any;
export declare function scimIntegrationShowOutputToHclTerraform(struct?: ScimIntegrationShowOutput): any;
export declare class ScimIntegrationShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ScimIntegrationShowOutput | undefined;
    set internalValue(value: ScimIntegrationShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class ScimIntegrationShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ScimIntegrationShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration snowflake_scim_integration}
*/
export declare class ScimIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_scim_integration";
    /**
    * Generates CDKTF code for importing a ScimIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ScimIntegration to import
    * @param importFromId The id of the existing ScimIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ScimIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/scim_integration snowflake_scim_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ScimIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ScimIntegrationConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ScimIntegrationDescribeOutputList;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _runAsRole?;
    get runAsRole(): string;
    set runAsRole(value: string);
    get runAsRoleInput(): string | undefined;
    private _scimClient?;
    get scimClient(): string;
    set scimClient(value: string);
    get scimClientInput(): string | undefined;
    private _showOutput;
    get showOutput(): ScimIntegrationShowOutputList;
    private _syncPassword?;
    get syncPassword(): string;
    set syncPassword(value: string);
    resetSyncPassword(): void;
    get syncPasswordInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
