/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.context.internal;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.internal.MavenSystemHomeImpl;
import eu.maveniverse.maven.mima.context.internal.MavenUserHomeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.DefaultSessionData;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.repository.ChainedLocalRepositoryManager;

public abstract class RuntimeSupport
implements Runtime {
    public static final String UNKNOWN = "(unknown)";
    private static final String MAVEN_REPO_LOCAL_TAIL = "maven.repo.local.tail";
    private static final String MAVEN_REPO_LOCAL_TAIL_IGNORE_AVAILABILITY = "maven.repo.local.tail.ignoreAvailability";
    public static final Path DEFAULT_BASEDIR = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
    public static final Path DEFAULT_USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]).toAbsolutePath();
    public static final Path DEFAULT_MAVEN_USER_HOME = DEFAULT_USER_HOME.resolve(".m2");
    private final String name;
    private final String version;
    private final int priority;
    private final String mavenVersion;

    protected RuntimeSupport(String name, String version, int priority, String mavenVersion) {
        this.name = Objects.requireNonNull(name);
        this.version = Objects.requireNonNull(version);
        this.priority = priority;
        this.mavenVersion = Objects.requireNonNull(mavenVersion);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public String mavenVersion() {
        return this.mavenVersion;
    }

    @Override
    public abstract boolean managedRepositorySystem();

    public Context customizeContext(ContextOverrides overrides, Context context, boolean reset) {
        return this.customizeContext(this, overrides, context, reset);
    }

    protected Context customizeContext(RuntimeSupport runtime, ContextOverrides overrides, Context context, boolean reset) {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(context.repositorySystemSession());
        if (reset) {
            session.setCache(new DefaultRepositoryCache());
            session.setData(new DefaultSessionData());
        }
        if (this.managedRepositorySystem()) {
            session.setSystemProperties(overrides.getSystemProperties());
            session.setUserProperties(overrides.getUserProperties());
            session.setConfigProperties(overrides.getConfigProperties());
        }
        session.setOffline(overrides.isOffline());
        this.customizeLocalRepositoryManager(context, session);
        this.customizeChecksumPolicy(overrides, session);
        this.customizeSnapshotUpdatePolicy(overrides, session);
        if (overrides.getTransferListener() != null) {
            session.setTransferListener(overrides.getTransferListener());
        }
        if (overrides.getRepositoryListener() != null) {
            session.setRepositoryListener(overrides.getRepositoryListener());
        }
        List<RemoteRepository> remoteRepositories = this.customizeRemoteRepositories(overrides, context.remoteRepositories());
        return new Context(runtime, overrides, overrides.getBasedirOverride() != null ? overrides.getBasedirOverride() : context.basedir(), ((MavenUserHomeImpl)context.mavenUserHome()).derive(overrides), ((MavenSystemHomeImpl)context.mavenSystemHome()).derive(overrides), context.repositorySystem(), session, context.repositorySystem().newResolutionRepositories(session, remoteRepositories), context.httpProxy(), null);
    }

    protected void customizeLocalRepositoryManager(Context context, DefaultRepositorySystemSession session) {
        Path localRepoPath = session.getLocalRepository().getBasedir().toPath();
        if (context.mavenUserHome().localRepository().equals(localRepoPath)) {
            return;
        }
        this.newLocalRepositoryManager(context.mavenUserHome().localRepository(), context.repositorySystem(), session);
    }

    protected void newLocalRepositoryManager(Path localRepoPath, RepositorySystem repositorySystem, DefaultRepositorySystemSession session) {
        LocalRepository localRepo = new LocalRepository(localRepoPath.toFile());
        LocalRepositoryManager lrm = repositorySystem.newLocalRepositoryManager(session, localRepo);
        String localRepoTail = ConfigUtils.getString(session, null, MAVEN_REPO_LOCAL_TAIL);
        if (localRepoTail != null) {
            boolean ignoreTailAvailability = ConfigUtils.getBoolean(session, true, MAVEN_REPO_LOCAL_TAIL_IGNORE_AVAILABILITY);
            ArrayList<LocalRepositoryManager> tail = new ArrayList<LocalRepositoryManager>();
            List paths = Arrays.stream(localRepoTail.split(",")).filter(p -> p != null && !p.trim().isEmpty()).collect(Collectors.toList());
            for (String path : paths) {
                tail.add(repositorySystem.newLocalRepositoryManager(session, new LocalRepository(path)));
            }
            session.setLocalRepositoryManager(new ChainedLocalRepositoryManager(lrm, tail, ignoreTailAvailability));
        } else {
            session.setLocalRepositoryManager(lrm);
        }
    }

    protected void customizeChecksumPolicy(ContextOverrides overrides, DefaultRepositorySystemSession session) {
        if (overrides.getChecksumPolicy() != null) {
            switch (overrides.getChecksumPolicy()) {
                case FAIL: {
                    session.setChecksumPolicy("fail");
                    break;
                }
                case WARN: {
                    session.setChecksumPolicy("warn");
                    break;
                }
                case IGNORE: {
                    session.setChecksumPolicy("ignore");
                }
            }
        }
    }

    protected void customizeSnapshotUpdatePolicy(ContextOverrides overrides, DefaultRepositorySystemSession session) {
        if (overrides.getSnapshotUpdatePolicy() != null) {
            switch (overrides.getSnapshotUpdatePolicy()) {
                case ALWAYS: {
                    session.setUpdatePolicy("always");
                    break;
                }
                case NEVER: {
                    session.setUpdatePolicy("never");
                }
            }
        }
    }

    protected List<RemoteRepository> customizeRemoteRepositories(ContextOverrides contextOverrides, List<RemoteRepository> remoteRepositories) {
        ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>();
        if (contextOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.REPLACE) {
            result.addAll(contextOverrides.getRepositories());
        } else {
            if (contextOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.PREPEND) {
                result.addAll(contextOverrides.getRepositories());
            }
            result.addAll(remoteRepositories);
            if (contextOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.APPEND) {
                result.addAll(contextOverrides.getRepositories());
            }
        }
        return result;
    }

    protected MavenUserHomeImpl defaultMavenUserHome() {
        return new MavenUserHomeImpl(DEFAULT_MAVEN_USER_HOME);
    }

    protected static String discoverMavenVersion() {
        return RuntimeSupport.discoverArtifactVersion("org.dflib.jjava.shaded.org.apache.maven", "maven-resolver-provider", UNKNOWN);
    }

    protected static String discoverArtifactVersion(String groupId, String artifactId, String defVal) {
        Map<String, String> mavenPomProperties = RuntimeSupport.loadPomProperties(groupId, artifactId);
        String versionString = mavenPomProperties.getOrDefault("version", "").trim();
        if (!versionString.startsWith("${")) {
            return versionString;
        }
        return defVal;
    }

    protected static Map<String, String> loadPomProperties(String groupId, String artifactId) {
        return RuntimeSupport.loadClasspathProperties("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }

    protected static Map<String, String> loadClasspathProperties(String resource) {
        Properties props = new Properties();
        try (InputStream is = RuntimeSupport.class.getResourceAsStream(resource);){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', version=" + this.version + ", priority=" + this.priority + ", mavenVersion=" + this.mavenVersion + ", managedRepositorySystem=" + this.managedRepositorySystem() + "}";
    }
}

