/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import org.dflib.jjava.JavaKernel;
import org.dflib.jjava.jupyter.channels.JupyterConnection;
import org.dflib.jjava.jupyter.channels.JupyterSocket;
import org.dflib.jjava.jupyter.kernel.KernelConnectionProperties;
import org.dflib.jjava.shaded.com.google.gson.JsonObject;
import org.dflib.jjava.shaded.com.google.gson.JsonParser;

public class JJava {
    private static final String KERNEL_METADATA_FILE = "jjava-kernel-metadata.json";
    @Deprecated(since="1.0", forRemoval=true)
    public static final String COMPILER_OPTS_KEY = "IJAVA_COMPILER_OPTS";
    @Deprecated(since="1.0", forRemoval=true)
    public static final String TIMEOUT_DURATION_KEY = "IJAVA_TIMEOUT";
    @Deprecated(since="1.0", forRemoval=true)
    public static final String CLASSPATH_KEY = "IJAVA_CLASSPATH";
    @Deprecated(since="1.0", forRemoval=true)
    public static final String STARTUP_SCRIPTS_KEY = "IJAVA_STARTUP_SCRIPTS_PATH";
    @Deprecated(since="1.0", forRemoval=true)
    public static final String STARTUP_SCRIPT_KEY = "IJAVA_STARTUP_SCRIPT";
    private static JavaKernel kernel;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing connection file argument");
        }
        String version = JJava.loadKernelVersion();
        Path connectionFile = Paths.get(args[0], new String[0]);
        if (!Files.isRegularFile(connectionFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Connection file '" + String.valueOf(connectionFile) + "' isn't a file.");
        }
        String contents = new String(Files.readAllBytes(connectionFile));
        JupyterSocket.JUPYTER_LOGGER.setLevel(Level.WARNING);
        KernelConnectionProperties connProps = KernelConnectionProperties.parse(contents);
        JupyterConnection connection = new JupyterConnection(connProps);
        kernel = new JavaKernel(version);
        kernel.becomeHandlerForConnection(connection);
        connection.connect();
        connection.waitUntilClose();
    }

    public static JavaKernel getKernelInstance() {
        return kernel;
    }

    private static InputStream resource(String path) {
        return JJava.class.getClassLoader().getResourceAsStream(path);
    }

    private static String loadKernelVersion() {
        JsonObject meta = JJava.loadKernelMetadata();
        return meta != null && meta.get("version") != null ? meta.get("version").getAsString() : "0";
    }

    private static JsonObject loadKernelMetadata() {
        JsonObject jsonObject;
        InputStreamReader metaReader = new InputStreamReader(JJava.resource(KERNEL_METADATA_FILE));
        try {
            jsonObject = JsonParser.parseReader(metaReader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)metaReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((Reader)metaReader).close();
        return jsonObject;
    }
}

