/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.dflib.jjava.jupyter.Extension;

public final class ExtensionLoader {
    private final Set<String> usedExtensions = new HashSet<String>();

    public List<Extension> loadExtensions() {
        return this.getExtensions(this.getClass().getClassLoader());
    }

    public List<Extension> loadExtensions(Iterable<String> jarPaths) {
        List<Extension> list;
        block8: {
            URL[] urls = (URL[])StreamSupport.stream(jarPaths.spliterator(), false).map(ExtensionLoader::toURL).toArray(URL[]::new);
            URLClassLoader classLoader = URLClassLoader.newInstance(urls);
            try {
                list = this.getExtensions(classLoader);
                if (classLoader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (classLoader != null) {
                        try {
                            classLoader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            classLoader.close();
        }
        return list;
    }

    private List<Extension> getExtensions(ClassLoader classLoader) {
        return ServiceLoader.load(Extension.class, classLoader).stream().map(ServiceLoader.Provider::get).filter(extension -> !this.usedExtensions.contains(extension.getClass().getName())).peek(extension -> this.usedExtensions.add(extension.getClass().getName())).collect(Collectors.toList());
    }

    private static URL toURL(String path) {
        try {
            return Path.of(path, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

