/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.channels;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.dflib.jjava.jupyter.channels.JupyterSocket;
import org.dflib.jjava.jupyter.kernel.KernelConnectionProperties;
import org.dflib.jjava.jupyter.messages.HMACGenerator;
import org.dflib.jjava.jupyter.messages.Message;
import org.dflib.jjava.jupyter.messages.MessageContext;
import org.dflib.jjava.jupyter.messages.reply.InputReply;
import org.dflib.jjava.jupyter.messages.request.InputRequest;
import org.dflib.jjava.shaded.org.zeromq.SocketType;
import org.dflib.jjava.shaded.org.zeromq.ZMQ;

public class StdinChannel
extends JupyterSocket {
    public StdinChannel(ZMQ.Context context, HMACGenerator hmacGenerator) {
        super(context, SocketType.ROUTER, hmacGenerator, Logger.getLogger("StdinChannel"));
    }

    @Override
    public void bind(KernelConnectionProperties connProps) {
        String addr = StdinChannel.formatAddress(connProps.getTransport(), connProps.getIp(), connProps.getStdinPort());
        this.logger.log(Level.INFO, String.format("Binding stdin to %s.", addr));
        super.bind(addr);
    }

    public synchronized String getInput(MessageContext context, String prompt, boolean isPasswordRequest) {
        InputRequest content = new InputRequest(prompt, isPasswordRequest);
        Message<InputRequest> request = new Message<InputRequest>(context, InputRequest.MESSAGE_TYPE, content);
        super.sendMessage(request);
        Message<InputReply> reply = super.readMessage(InputReply.MESSAGE_TYPE);
        return reply.getContent().getValue() + System.lineSeparator();
    }
}

