/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.comm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dflib.jjava.jupyter.channels.JupyterSocket;
import org.dflib.jjava.jupyter.channels.ReplyEnvironment;
import org.dflib.jjava.jupyter.kernel.comm.Comm;
import org.dflib.jjava.jupyter.kernel.comm.CommFactory;
import org.dflib.jjava.jupyter.kernel.comm.CommTarget;
import org.dflib.jjava.jupyter.messages.Message;
import org.dflib.jjava.jupyter.messages.MessageContext;
import org.dflib.jjava.jupyter.messages.comm.CommCloseCommand;
import org.dflib.jjava.jupyter.messages.comm.CommMsgCommand;
import org.dflib.jjava.jupyter.messages.comm.CommOpenCommand;
import org.dflib.jjava.jupyter.messages.reply.CommInfoReply;
import org.dflib.jjava.jupyter.messages.request.CommInfoRequest;
import org.dflib.jjava.shaded.com.google.gson.JsonObject;

public class CommManager
implements Iterable<Comm> {
    protected Map<String, CommTarget> targets = new HashMap<String, CommTarget>();
    protected Map<String, Comm> comms = new HashMap<String, Comm>();
    protected JupyterSocket iopub = null;
    protected MessageContext context;

    public void setIOPubChannel(JupyterSocket iopub) {
        this.iopub = iopub;
    }

    public void setMessageContext(MessageContext context) {
        this.context = context;
    }

    @Override
    public Iterator<Comm> iterator() {
        return this.comms.values().iterator();
    }

    public Comm getCommByID(String id) {
        return this.comms.get(id);
    }

    public void registerComm(Comm comm) {
        this.comms.put(comm.getID(), comm);
    }

    public Comm unregisterComm(String id) {
        return this.comms.remove(id);
    }

    public <T extends Comm> T openComm(String targetName, CommFactory<T> factory) {
        if (this.iopub == null) {
            return null;
        }
        String id = UUID.randomUUID().toString();
        CommOpenCommand content = new CommOpenCommand(id, targetName, new JsonObject());
        Message<CommOpenCommand> message = new Message<CommOpenCommand>(this.context, CommOpenCommand.MESSAGE_TYPE, content);
        T comm = factory.produce(this, id, targetName, message);
        this.iopub.sendMessage(message);
        this.registerComm((Comm)comm);
        return comm;
    }

    public void messageComm(String commID, JsonObject data, Map<String, Object> metadata, List<byte[]> blobs) {
        CommMsgCommand content = new CommMsgCommand(commID, data);
        Message<CommMsgCommand> message = new Message<CommMsgCommand>(this.context, CommMsgCommand.MESSAGE_TYPE, content, blobs, metadata);
        this.iopub.sendMessage(message);
    }

    public void messageComm(String commID, JsonObject data) {
        this.messageComm(commID, data, null, null);
    }

    public void closeComm(Comm comm) {
        CommCloseCommand content = new CommCloseCommand(comm.getID(), new JsonObject());
        Message<CommCloseCommand> message = new Message<CommCloseCommand>(this.context, CommCloseCommand.MESSAGE_TYPE, content);
        this.iopub.sendMessage(message);
        Comm unregistered = this.unregisterComm(comm.getID());
        if (unregistered != null) {
            unregistered.onClose(message, true);
        }
    }

    public void registerTarget(String targetName, CommTarget target) {
        this.targets.put(targetName, target);
    }

    public void unregisterTarget(String targetName) {
        this.targets.remove(targetName);
    }

    public CommTarget getTarget(String targetName) {
        return this.targets.get(targetName);
    }

    public void handleCommOpenCommand(ReplyEnvironment env, Message<CommOpenCommand> commOpenCommandMessage) {
        CommOpenCommand openCommand = commOpenCommandMessage.getContent();
        env.setBusyDeferIdle();
        CommTarget target = this.getTarget(openCommand.getTargetName());
        if (target == null) {
            CommCloseCommand closeCommand = new CommCloseCommand(openCommand.getCommID(), new JsonObject());
            env.publish(closeCommand);
        } else {
            Comm comm = target.createComm(this, openCommand.getCommID(), openCommand.getTargetName(), commOpenCommandMessage);
            this.registerComm(comm);
        }
    }

    public void handleCommMsgCommand(ReplyEnvironment env, Message<CommMsgCommand> commMsgCommandMessage) {
        CommMsgCommand msgCommand = commMsgCommandMessage.getContent();
        env.setBusyDeferIdle();
        Comm comm = this.getCommByID(msgCommand.getCommID());
        if (comm != null) {
            comm.onMessage(commMsgCommandMessage);
        }
    }

    public void handleCommCloseCommand(ReplyEnvironment env, Message<CommCloseCommand> commCloseCommandMessage) {
        CommCloseCommand closeCommand = commCloseCommandMessage.getContent();
        env.setBusyDeferIdle();
        Comm comm = this.unregisterComm(closeCommand.getCommID());
        if (comm != null) {
            comm.onClose(commCloseCommandMessage, false);
        }
    }

    public void handleCommInfoRequest(ReplyEnvironment env, Message<CommInfoRequest> commInfoRequestMessage) {
        CommInfoRequest request = commInfoRequestMessage.getContent();
        env.setBusyDeferIdle();
        LinkedHashMap<String, CommInfoReply.CommInfo> comms = new LinkedHashMap<String, CommInfoReply.CommInfo>();
        String targetNameFilter = request.getTargetName();
        if (targetNameFilter != null) {
            this.forEach(comm -> {
                if (targetNameFilter.equals(comm.getTargetName())) {
                    comms.put(comm.getID(), new CommInfoReply.CommInfo(comm.getTargetName()));
                }
            });
        } else {
            this.forEach(comm -> comms.put(comm.getID(), new CommInfoReply.CommInfo(comm.getTargetName())));
        }
        env.reply(new CommInfoReply(comms));
    }
}

