/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.magic;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dflib.jjava.jupyter.kernel.magic.CellMagicArgs;
import org.dflib.jjava.jupyter.kernel.magic.CellMagicParseContext;
import org.dflib.jjava.jupyter.kernel.magic.LineMagicArgs;
import org.dflib.jjava.jupyter.kernel.magic.LineMagicParseContext;

public class MagicParser {
    private final Pattern lineMagicPattern;
    private final Pattern cellMagicPattern;

    protected static List<String> split(String args) {
        args = args.trim();
        LinkedList<String> split = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean escape = false;
        block5: for (char c : args.toCharArray()) {
            switch (c) {
                case '\t': 
                case ' ': {
                    if (inQuotes) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    split.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
                case '\\': {
                    if (escape) {
                        current.append("\\\\");
                        escape = false;
                        continue block5;
                    }
                    escape = true;
                    continue block5;
                }
                case '\"': {
                    if (escape) {
                        current.append('\"');
                        escape = false;
                        continue block5;
                    }
                    if (current.length() > 0 && inQuotes) {
                        split.add(current.toString());
                        current.setLength(0);
                        inQuotes = false;
                        continue block5;
                    }
                    inQuotes = true;
                    continue block5;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            split.add(current.toString());
        }
        return split;
    }

    public MagicParser() {
        this("^%", "%%");
    }

    public MagicParser(String lineMagicStart, String cellMagicStart) {
        this.lineMagicPattern = Pattern.compile(lineMagicStart + "(?<args>\\w.*?)$", 8);
        this.cellMagicPattern = Pattern.compile("^(?<argsLine>" + cellMagicStart + "(?<args>\\w.*?))\\R(?<body>(?sU).+?)$");
    }

    public String transformLineMagics(String cell, Function<LineMagicParseContext, String> transformer) {
        StringBuffer transformedCell = new StringBuffer();
        Matcher m = this.lineMagicPattern.matcher(cell);
        while (m.find()) {
            String raw = m.group();
            String rawArgs = m.group("args");
            List<String> split = MagicParser.split(rawArgs);
            LineMagicArgs args = LineMagicArgs.of(split.get(0), split.subList(1, split.size()));
            LineMagicParseContext ctx = LineMagicParseContext.of(args, raw, cell, cell.substring(0, m.start()));
            String transformed = transformer.apply(ctx);
            if (transformed == null) {
                transformed = raw;
            }
            m.appendReplacement(transformedCell, Matcher.quoteReplacement(transformed));
        }
        m.appendTail(transformedCell);
        return transformedCell.toString();
    }

    public CellMagicParseContext parseCellMagic(String cell) {
        Matcher m = this.cellMagicPattern.matcher(cell);
        if (!m.matches()) {
            return null;
        }
        String rawArgsLine = m.group("argsLine");
        String rawArgs = m.group("args");
        String body = m.group("body");
        List<String> split = MagicParser.split(rawArgs);
        CellMagicArgs args = CellMagicArgs.of(split.get(0), split.subList(1, split.size()), body);
        return CellMagicParseContext.of(args, rawArgsLine, cell);
    }

    public String transformCellMagic(String cell, Function<CellMagicParseContext, String> transformer) {
        CellMagicParseContext ctx = this.parseCellMagic(cell);
        return ctx == null ? cell : transformer.apply(ctx);
    }
}

