/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.messages.adapters;

import java.io.IOException;
import java.lang.reflect.Type;
import org.dflib.jjava.shaded.com.google.gson.Gson;
import org.dflib.jjava.shaded.com.google.gson.GsonBuilder;
import org.dflib.jjava.shaded.com.google.gson.JsonElement;
import org.dflib.jjava.shaded.com.google.gson.TypeAdapter;
import org.dflib.jjava.shaded.com.google.gson.stream.JsonReader;
import org.dflib.jjava.shaded.com.google.gson.stream.JsonWriter;

public class IdentityJsonElementAdapter
extends TypeAdapter<JsonElement> {
    private static final ThreadLocal<Gson> GSON = ThreadLocal.withInitial(() -> new GsonBuilder().serializeNulls().create());

    @Override
    public void write(JsonWriter out, JsonElement value) throws IOException {
        if (out.getSerializeNulls()) {
            GSON.get().toJson(value, out);
        } else {
            out.setSerializeNulls(true);
            try {
                GSON.get().toJson(value, out);
            }
            finally {
                out.setSerializeNulls(false);
            }
        }
    }

    @Override
    public JsonElement read(JsonReader in) throws IOException {
        return (JsonElement)GSON.get().fromJson(in, (Type)((Object)JsonElement.class));
    }
}

