/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.magics;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.dflib.jjava.jupyter.kernel.magic.registry.LineMagic;
import org.dflib.jjava.jupyter.kernel.util.GlobFinder;

public class ClasspathMagics {
    private final Consumer<String> addToClasspath;

    public ClasspathMagics(Consumer<String> addToClasspath) {
        this.addToClasspath = addToClasspath;
    }

    @LineMagic
    public List<String> jars(List<String> args) {
        List<String> jars = args.stream().map(GlobFinder::new).flatMap(g -> {
            try {
                return StreamSupport.stream(g.computeMatchingFiles().spliterator(), false);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception resolving jar glob", e);
            }
        }).map(p -> p.toAbsolutePath().toString()).collect(Collectors.toList());
        jars.forEach(this.addToClasspath);
        return jars;
    }

    @LineMagic
    public List<String> classpath(List<String> args) {
        List<String> paths = args.stream().map(GlobFinder::new).flatMap(g -> {
            try {
                return StreamSupport.stream(g.computeMatchingPaths().spliterator(), false);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception resolving jar glob", e);
            }
        }).map(p -> p.toAbsolutePath().toString()).collect(Collectors.toList());
        paths.forEach(this.addToClasspath);
        return paths;
    }
}

