/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.magics;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.Runtimes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dflib.jjava.jupyter.Extension;
import org.dflib.jjava.jupyter.ExtensionLoader;
import org.dflib.jjava.jupyter.kernel.magic.registry.CellMagic;
import org.dflib.jjava.jupyter.kernel.magic.registry.LineMagic;
import org.dflib.jjava.jupyter.kernel.magic.registry.MagicsArgs;
import org.dflib.jjava.magics.dependencies.CommonRepositories;
import org.dflib.jjava.shaded.org.apache.maven.model.Model;
import org.dflib.jjava.shaded.org.apache.maven.model.building.DefaultModelBuilder;
import org.dflib.jjava.shaded.org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.dflib.jjava.shaded.org.apache.maven.model.building.Result;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenResolver {
    private static final String DEFAULT_RESOLVER_NAME = "default";
    private static final Pattern IVY_MRID_PATTERN = Pattern.compile("^(?<organization>[-\\w/._+=]*)#(?<name>[-\\w/._+=]+)(?:#(?<branch>[-\\w/._+=]+))?;(?<revision>[-\\w/._+=,\\[\\]{}():@]+)$");
    private final Consumer<String> classPathHandler;
    private final Consumer<Extension> extensionHandler;
    private final ExtensionLoader extensionLoader;
    private final List<RemoteRepository> repositories;
    private final Runtime runtime;

    public MavenResolver(Consumer<String> classPathHandler, Consumer<Extension> extensionHandler) {
        this.classPathHandler = classPathHandler;
        this.extensionHandler = extensionHandler;
        this.extensionLoader = new ExtensionLoader();
        this.repositories = new ArrayList<RemoteRepository>();
        this.runtime = Runtimes.INSTANCE.getRuntime();
        this.repositories.add(CommonRepositories.mavenCentral());
    }

    public void initImplicitExtensions() {
        this.extensionLoader.loadExtensions().forEach(this.extensionHandler);
    }

    public void addRemoteRepo(String name, String url) {
        if (DEFAULT_RESOLVER_NAME.equals(name)) {
            throw new IllegalArgumentException("Illegal repository name, cannot use 'default'.");
        }
        this.repositories.add(CommonRepositories.maven(name, url));
    }

    public List<File> resolveMavenDependency(String coordinates, List<RemoteRepository> repositories) throws Exception {
        ContextOverrides overrides = ContextOverrides.create().withUserSettings(true).repositories(repositories.isEmpty() ? this.repositories : repositories).build();
        try (Context context = this.runtime.create(overrides);){
            Artifact artifact = MavenResolver.parseArtifact(coordinates);
            Dependency dependency = new Dependency(artifact, "runtime");
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(dependency);
            collectRequest.setRepositories(context.remoteRepositories());
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            RepositorySystemSession session = context.repositorySystemSession();
            DependencyNode rootNode = context.repositorySystem().resolveDependencies(session, dependencyRequest).getRoot();
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            rootNode.accept(nlg);
            String classpath = nlg.getClassPath();
            List<File> list = Arrays.stream(classpath.split(File.pathSeparator)).map(File::new).collect(Collectors.toList());
            return list;
        }
    }

    public void addJarsToClasspath(Iterable<String> resolvedJars) {
        resolvedJars.forEach(this.classPathHandler);
        this.loadExtensions(resolvedJars);
    }

    public void loadExtensions(Iterable<String> resolvedJars) {
        this.extensionLoader.loadExtensions(resolvedJars).forEach(this.extensionHandler);
    }

    private static Artifact parseArtifact(String coordinates) {
        Matcher ivyMatcher = IVY_MRID_PATTERN.matcher(coordinates);
        if (ivyMatcher.matches()) {
            String organization = ivyMatcher.group("organization");
            String name = ivyMatcher.group("name");
            String revision = ivyMatcher.group("revision");
            return new DefaultArtifact(organization, name, "jar", revision);
        }
        return new DefaultArtifact(coordinates);
    }

    private String solidifyPartialPOM(String rawIn) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        SequenceInputStream inStream = new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream("<jjava>".getBytes(StandardCharsets.UTF_8)), new ByteArrayInputStream(rawIn.getBytes(StandardCharsets.UTF_8)), new ByteArrayInputStream("</jjava>".getBytes(StandardCharsets.UTF_8)))));
        Document doc = builder.parse(inStream);
        NodeList rootChildren = doc.getDocumentElement().getChildNodes();
        if (rootChildren.getLength() == 1 && "project".equalsIgnoreCase(rootChildren.item(0).getNodeName())) {
            return this.writeDOM(new DOMSource(rootChildren.item(0)));
        }
        Document fixed = builder.newDocument();
        Node project = fixed.appendChild(fixed.createElement("project"));
        Node dependencies = project.appendChild(fixed.createElement("dependencies"));
        Node repositories = project.appendChild(fixed.createElement("repositories"));
        boolean setModelVersion = false;
        boolean setGroupId = false;
        boolean setArtifactId = false;
        boolean setVersion = false;
        block20: for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node child = rootChildren.item(i);
            switch (child.getNodeName()) {
                case "modelVersion": {
                    setModelVersion = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "groupId": {
                    setGroupId = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "artifactId": {
                    setArtifactId = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "version": {
                    setVersion = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "dependency": {
                    this.appendChildInNewDoc(child, fixed, dependencies);
                    continue block20;
                }
                case "repository": {
                    this.appendChildInNewDoc(child, fixed, repositories);
                    continue block20;
                }
                case "dependencies": {
                    NodeList dependencyChildren = child.getChildNodes();
                    for (int j = 0; j < dependencyChildren.getLength(); ++j) {
                        this.appendChildInNewDoc(dependencyChildren.item(j), fixed, dependencies);
                    }
                    continue block20;
                }
                case "repositories": {
                    NodeList repositoryChildren = child.getChildNodes();
                    for (int j = 0; j < repositoryChildren.getLength(); ++j) {
                        this.appendChildInNewDoc(repositoryChildren.item(j), fixed, repositories);
                    }
                    continue block20;
                }
                default: {
                    this.appendChildInNewDoc(child, fixed, project);
                }
            }
        }
        if (!setModelVersion) {
            Node modelVersion = project.appendChild(fixed.createElement("modelVersion"));
            modelVersion.setTextContent("4.0.0");
        }
        if (!setGroupId) {
            Node groupId = project.appendChild(fixed.createElement("groupId"));
            groupId.setTextContent("jjava.notebook");
        }
        if (!setArtifactId) {
            Node artifactId = project.appendChild(fixed.createElement("artifactId"));
            artifactId.setTextContent("cell");
        }
        if (!setVersion) {
            Node version = project.appendChild(fixed.createElement("version"));
            version.setTextContent("1");
        }
        return this.writeDOM(new DOMSource(fixed));
    }

    private void appendChildInNewDoc(Node oldNode, Document doc, Node newParent) {
        Node newNode = oldNode.cloneNode(true);
        doc.adoptNode(newNode);
        newParent.appendChild(newNode);
    }

    private String writeDOM(Source src) throws TransformerException {
        Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
        idTransformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult dest = new StreamResult(out);
        idTransformer.transform(src, dest);
        return out.toString(StandardCharsets.UTF_8);
    }

    @LineMagic(aliases={"addMavenDependency", "maven"})
    public void addMavenDependencies(List<String> args) {
        MagicsArgs schema = MagicsArgs.builder().varargs("deps").keyword("from").onlyKnownKeywords().onlyKnownFlags().build();
        Map<String, List<String>> vals = schema.parse(args);
        List<String> deps = vals.get("deps");
        List<String> from = vals.get("from");
        ArrayList<RemoteRepository> repositoriesFrom = new ArrayList<RemoteRepository>();
        for (String urlString : from) {
            try {
                URL url = new URL(urlString);
                repositoriesFrom.add(CommonRepositories.maven("from-" + url.getHost(), url.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        for (String dep : deps) {
            try {
                List<String> resolvedJars = this.resolveMavenDependency(dep, repositoriesFrom).stream().map(File::getAbsolutePath).collect(Collectors.toList());
                this.addJarsToClasspath(resolvedJars);
            }
            catch (Exception e) {
                System.out.println(e);
                throw new RuntimeException("Failed to resolve dependency: " + dep, e);
            }
        }
    }

    @LineMagic(aliases={"mavenRepo"})
    public void addMavenRepo(List<String> args) {
        MagicsArgs schema = MagicsArgs.builder().required("id").required("url").build();
        Map<String, List<String>> vals = schema.parse(args);
        String id = vals.get("id").get(0);
        String url = vals.get("url").get(0);
        this.addRemoteRepo(id, url);
    }

    @CellMagic
    public void loadFromPOM(List<String> args, String body) throws Exception {
        try {
            File tempPomPath = File.createTempFile("jjava-maven-", ".pom").getAbsoluteFile();
            tempPomPath.deleteOnExit();
            String rawPom = this.solidifyPartialPOM(body);
            Files.write(tempPomPath.toPath(), rawPom.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ArrayList<String> loadArgs = new ArrayList<String>(args.size() + 1);
            loadArgs.add(tempPomPath.getAbsolutePath());
            loadArgs.addAll(args);
            this.loadFromPOM(loadArgs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LineMagic
    public void loadFromPOM(List<String> args) {
        if (args.isEmpty()) {
            throw new IllegalArgumentException("Loading from POM requires at least the path to the POM file");
        }
        MagicsArgs schema = MagicsArgs.builder().required("pomPath").onlyKnownKeywords().onlyKnownFlags().build();
        Map<String, List<String>> vals = schema.parse(args);
        String pomPath = vals.get("pomPath").get(0);
        File pomFile = new File(pomPath);
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        Result<? extends Model> modelResult = null;
        try {
            modelResult = modelBuilder.buildRawModel(pomFile, 30, true);
            Model model = modelResult.get();
            List<RemoteRepository> pomRepositories = model.getRepositories().stream().map(repo -> new RemoteRepository.Builder(repo.getId(), repo.getName(), repo.getUrl()).build()).collect(Collectors.toList());
            for (org.dflib.jjava.shaded.org.apache.maven.model.Dependency dep : model.getDependencies()) {
                String coordinates = dep.getManagementKey() + ":" + dep.getVersion();
                try {
                    List<String> resolvedJars = this.resolveMavenDependency(coordinates, pomRepositories).stream().map(File::getAbsolutePath).collect(Collectors.toList());
                    this.addJarsToClasspath(resolvedJars);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to resolve dependency: " + dep.getManagementKey(), e);
                    return;
                }
            }
        }
        catch (Exception e) {
            String message = "Failed to process POM file: " + pomPath;
            if (modelResult == null) throw new RuntimeException(message, e);
            message = message + "\n" + StreamSupport.stream(modelResult.getProblems().spliterator(), false).map(String::valueOf).collect(Collectors.joining("\n"));
            throw new RuntimeException(message, e);
        }
    }
}

