/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq;

import java.nio.channels.SelectableChannel;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.dflib.jjava.shaded.org.zeromq.ZMQ;
import org.dflib.jjava.shaded.org.zeromq.ZMQException;
import org.dflib.jjava.shaded.org.zeromq.ZMonitor;
import org.dflib.jjava.shaded.zmq.ZMQ;

public class ZEvent {
    private final ZMonitor.Event event;
    private final Object value;
    private final String address;

    private ZEvent(ZMQ.Event event, Function<Object, SelectableChannel> getResolveChannel) {
        this.event = ZMonitor.Event.findByCode(event.event);
        this.address = event.addr;
        this.value = ZEvent.resolve(this.event, event.arg, getResolveChannel);
    }

    static Object resolve(ZMonitor.Event event, Object value, Function<Object, SelectableChannel> getResolveChannel) {
        switch (event) {
            case HANDSHAKE_FAILED_PROTOCOL: {
                return ZMonitor.ProtocolCode.findByCode((Integer)value);
            }
            case CLOSE_FAILED: 
            case ACCEPT_FAILED: 
            case BIND_FAILED: 
            case HANDSHAKE_FAILED_NO_DETAIL: 
            case CONNECT_DELAYED: 
            case HANDSHAKE_SUCCEEDED: {
                return ZMQ.Error.findByCode((Integer)value);
            }
            case HANDSHAKE_FAILED_AUTH: 
            case HANDSHAKE_PROTOCOL: {
                return value;
            }
            case CONNECTED: 
            case LISTENING: 
            case ACCEPTED: 
            case CLOSED: 
            case DISCONNECTED: {
                return getResolveChannel.apply(value);
            }
            case CONNECT_RETRIED: {
                return Duration.ofMillis(((Integer)value).intValue());
            }
            case MONITOR_STOPPED: {
                return null;
            }
        }
        assert (false) : "Unhandled event " + (Object)((Object)event);
        return null;
    }

    public ZMonitor.Event getEvent() {
        return this.event;
    }

    public <M> M getValue() {
        return (M)this.value;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isError() {
        switch (this.event) {
            case HANDSHAKE_FAILED_PROTOCOL: 
            case CLOSE_FAILED: 
            case ACCEPT_FAILED: 
            case BIND_FAILED: 
            case HANDSHAKE_FAILED_NO_DETAIL: {
                return true;
            }
        }
        return false;
    }

    public boolean isWarn() {
        return this.event == ZMonitor.Event.HANDSHAKE_FAILED_AUTH;
    }

    public boolean isInformation() {
        return this.event == ZMonitor.Event.DISCONNECTED;
    }

    public boolean isDebug() {
        switch (this.event) {
            case CONNECT_DELAYED: 
            case HANDSHAKE_SUCCEEDED: 
            case HANDSHAKE_PROTOCOL: 
            case CONNECTED: 
            case LISTENING: 
            case ACCEPTED: 
            case CLOSED: 
            case CONNECT_RETRIED: 
            case MONITOR_STOPPED: {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZEvent zEvent = (ZEvent)o;
        return this.event == zEvent.event && Objects.equals(this.value, zEvent.value) && this.address.equals(zEvent.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.event, this.value, this.address});
    }

    public String toString() {
        return "ZEvent{event=" + (Object)((Object)this.event) + ", value=" + this.value + ", address='" + this.address + '\'' + '}';
    }

    public static ZEvent recv(ZMQ.Socket socket, int flags) {
        ZMQ.Event e = ZMQ.Event.read(socket.base(), flags);
        if (socket.errno() > 0 && socket.errno() != 35) {
            throw new ZMQException(socket.errno());
        }
        if (e == null) {
            return null;
        }
        return new ZEvent(e, o -> e.getChannel(socket.getCtx()));
    }

    public static ZEvent recv(ZMQ.Socket socket) {
        return ZEvent.recv(socket, 0);
    }

    public static interface ZEventConsummer
    extends ZMQ.EventConsummer {
        public void consume(ZEvent var1);

        @Override
        default public void consume(ZMQ.Event event) {
            this.consume(new ZEvent(event, SelectableChannel.class::cast));
        }
    }
}

