/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.dflib.jjava.shaded.org.zeromq.Utils;
import org.dflib.jjava.shaded.org.zeromq.ZMQ;
import org.dflib.jjava.shaded.org.zeromq.util.ZData;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.socket.clientserver.Server;

public class ZFrame {
    public static final int MORE = 2;
    public static final int REUSE = 128;
    public static final int DONTWAIT = 1;
    private boolean more;
    private byte[] data;
    private int routingId;
    private String group;

    protected ZFrame() {
    }

    public ZFrame(byte[] data) {
        if (data != null) {
            this.data = data;
        }
    }

    public ZFrame(String data) {
        if (data != null) {
            this.data = data.getBytes(ZMQ.CHARSET);
        }
    }

    protected ZFrame(Msg msg) {
        if (msg == null) {
            return;
        }
        this.data = msg.data();
        this.more = msg.hasMore();
        this.routingId = msg.getRoutingId();
    }

    public int getRoutingId() {
        return this.routingId;
    }

    public void setRoutingId(int routingId) {
        this.routingId = routingId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void destroy() {
        if (this.hasData()) {
            this.data = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public String getString(Charset charset) {
        if (!this.hasData()) {
            return "";
        }
        return new String(this.data, charset);
    }

    public boolean hasMore() {
        return this.more;
    }

    public int size() {
        if (this.hasData()) {
            return this.data.length;
        }
        return 0;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean send(ZMQ.Socket socket, int flags) {
        Utils.checkArgument(socket != null, "socket parameter must be set");
        SocketBase base = socket.base();
        Msg msg = new Msg(this.data);
        if (this.group != null) {
            msg.setGroup(this.group);
        }
        int sendFlags = (flags & 2) == 2 ? 2 : 0;
        sendFlags |= (flags & 1) == 1 ? 1 : 0;
        if (base instanceof Server) {
            msg.setRoutingId(this.routingId);
        }
        return base.send(msg, sendFlags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket, int flags) {
        return this.send(socket, flags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket) {
        return this.sendAndKeep(socket, 0);
    }

    public boolean sendAndDestroy(ZMQ.Socket socket, int flags) {
        boolean ret = this.send(socket, flags);
        if (ret) {
            this.destroy();
        }
        return ret;
    }

    public boolean sendAndDestroy(ZMQ.Socket socket) {
        return this.sendAndDestroy(socket, 0);
    }

    public ZFrame duplicate() {
        return new ZFrame(this.data);
    }

    public boolean hasSameData(ZFrame other) {
        if (other == null) {
            return false;
        }
        if (this.size() == other.size()) {
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public void reset(String data) {
        this.data = data.getBytes(ZMQ.CHARSET);
    }

    public void reset(byte[] data) {
        this.data = data;
    }

    public String strhex() {
        return ZData.strhex(this.data);
    }

    public boolean streq(String str) {
        return ZData.streq(this.data, str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZFrame zFrame = (ZFrame)o;
        return Arrays.equals(this.data, zFrame.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return ZData.toString(this.data);
    }

    public static ZFrame recvFrame(ZMQ.Socket socket) {
        return ZFrame.recvFrame(socket, 0);
    }

    public static ZFrame recvFrame(ZMQ.Socket socket, int flags) {
        SocketBase base = socket.base();
        Msg msg = base.recv(flags);
        if (msg == null) {
            socket.mayRaise();
            return null;
        }
        ZFrame frame = new ZFrame(msg);
        frame.setGroup(msg.getGroup());
        return frame;
    }

    public void print(String prefix) {
        ZData.print(System.out, prefix, this.getData(), this.size());
    }
}

