/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq.util;

import java.io.PrintStream;
import java.util.Arrays;
import org.dflib.jjava.shaded.org.zeromq.ZMQ;

public class ZData {
    private static final String HEX_CHAR = "0123456789ABCDEF";
    private final byte[] data;

    public ZData(byte[] data) {
        this.data = data;
    }

    public boolean streq(String str) {
        return ZData.streq(this.data, str);
    }

    public static boolean streq(byte[] data, String str) {
        if (data == null) {
            return false;
        }
        return new String(data, ZMQ.CHARSET).compareTo(str) == 0;
    }

    public boolean equals(byte[] that) {
        return Arrays.equals(this.data, that);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ZData that = (ZData)other;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return ZData.toString(this.data);
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "";
        }
        boolean isText = true;
        for (byte aData : data) {
            if (aData >= 32 && aData <= 127) continue;
            isText = false;
            break;
        }
        if (isText) {
            return new String(data, ZMQ.CHARSET);
        }
        return ZData.strhex(data);
    }

    public String strhex() {
        return ZData.strhex(this.data);
    }

    public static String strhex(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder b = new StringBuilder(data.length * 2);
        for (byte aData : data) {
            int b1 = aData >>> 4 & 0xF;
            int b2 = aData & 0xF;
            b.append(HEX_CHAR.charAt(b1));
            b.append(HEX_CHAR.charAt(b2));
        }
        return b.toString();
    }

    public void print(PrintStream out, String prefix) {
        ZData.print(out, prefix, this.data, this.data.length);
    }

    public static void print(PrintStream out, String prefix, byte[] data, int size) {
        int charNbr;
        if (data == null) {
            return;
        }
        if (prefix != null) {
            out.printf("%s", prefix);
        }
        boolean isBin = false;
        for (charNbr = 0; charNbr < size; ++charNbr) {
            if (data[charNbr] >= 9 && data[charNbr] <= 127) continue;
            isBin = true;
        }
        out.printf("[%03d] ", size);
        int maxSize = isBin ? 35 : 70;
        String elipsis = "";
        if (size > maxSize) {
            size = maxSize;
            elipsis = "...";
        }
        for (charNbr = 0; charNbr < size; ++charNbr) {
            if (isBin) {
                out.printf("%02X", data[charNbr]);
                continue;
            }
            out.printf("%c", data[charNbr]);
        }
        out.printf("%s\n", elipsis);
        out.flush();
    }
}

