/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Options;
import org.dflib.jjava.shaded.zmq.ZObject;
import org.dflib.jjava.shaded.zmq.io.IOThread;
import org.dflib.jjava.shaded.zmq.util.Errno;

public abstract class Own
extends ZObject {
    protected final Options options;
    private boolean terminating;
    private final AtomicLong sendSeqnum;
    private long processedSeqnum;
    private Own owner;
    private final Set<Own> owned;
    private int termAcks;
    public final Errno errno;

    protected Own(Ctx parent, int tid) {
        super(parent, tid);
        this.terminating = false;
        this.sendSeqnum = new AtomicLong(0L);
        this.processedSeqnum = 0L;
        this.owner = null;
        this.termAcks = 0;
        this.options = new Options();
        this.errno = this.options.errno;
        this.owned = new HashSet<Own>();
    }

    protected Own(IOThread ioThread, Options options) {
        super(ioThread);
        this.options = options;
        this.terminating = false;
        this.sendSeqnum = new AtomicLong(0L);
        this.processedSeqnum = 0L;
        this.owner = null;
        this.termAcks = 0;
        this.errno = options.errno;
        this.owned = new HashSet<Own>();
    }

    protected abstract void destroy();

    protected void processDestroy() {
        this.destroy();
    }

    private void setOwner(Own owner) {
        assert (this.owner == null) : this.owner;
        this.owner = owner;
    }

    protected void incSeqnum() {
        this.sendSeqnum.incrementAndGet();
    }

    @Override
    protected final void processSeqnum() {
        ++this.processedSeqnum;
        this.checkTermAcks();
    }

    protected final void launchChild(Own object) {
        object.setOwner(this);
        this.sendPlug(object);
        this.sendOwn(this, object);
    }

    protected final void termChild(Own object) {
        this.processTermReq(object);
    }

    @Override
    protected final void processTermReq(Own object) {
        if (this.terminating) {
            return;
        }
        if (!this.owned.remove(object)) {
            return;
        }
        this.registerTermAcks(1);
        this.sendTerm(object, this.options.linger);
    }

    @Override
    protected final void processOwn(Own object) {
        if (this.terminating) {
            this.registerTermAcks(1);
            this.sendTerm(object, 0);
            return;
        }
        this.owned.add(object);
    }

    protected final void terminate() {
        if (this.terminating) {
            return;
        }
        if (this.owner == null) {
            this.processTerm(this.options.linger);
            return;
        }
        this.sendTermReq(this.owner, this);
    }

    protected final boolean isTerminating() {
        return this.terminating;
    }

    @Override
    protected void processTerm(int linger) {
        assert (!this.terminating);
        for (Own it : this.owned) {
            this.sendTerm(it, linger);
        }
        this.registerTermAcks(this.owned.size());
        this.owned.clear();
        this.terminating = true;
        this.checkTermAcks();
    }

    final void registerTermAcks(int count) {
        this.termAcks += count;
    }

    final void unregisterTermAck() {
        assert (this.termAcks > 0);
        --this.termAcks;
        this.checkTermAcks();
    }

    @Override
    protected final void processTermAck() {
        this.unregisterTermAck();
    }

    private void checkTermAcks() {
        if (this.terminating && this.processedSeqnum == this.sendSeqnum.get() && this.termAcks == 0) {
            assert (this.owned.isEmpty()) : this.owned;
            if (this.owner != null) {
                this.sendTermAck(this.owner);
            }
            this.processDestroy();
        }
    }
}

