/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.io.coder;

import java.nio.ByteBuffer;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.io.coder.IEncoder;
import org.dflib.jjava.shaded.zmq.util.Errno;
import org.dflib.jjava.shaded.zmq.util.ValueReference;

public abstract class EncoderBase
implements IEncoder {
    private ByteBuffer writeBuf;
    private Runnable next;
    private boolean newMsgFlag;
    private int toWrite;
    private final ByteBuffer buffer;
    private final int bufferSize;
    private boolean error;
    protected Msg inProgress;
    private final Errno errno;

    protected EncoderBase(Errno errno, int bufferSize) {
        this.errno = errno;
        this.bufferSize = bufferSize;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.error = false;
    }

    @Override
    public final void loadMsg(Msg msg) {
        assert (this.inProgress == null);
        this.inProgress = msg;
        this.next();
    }

    @Override
    public final int encode(ValueReference<ByteBuffer> data, int size) {
        int bufferSize = size;
        ByteBuffer buf = data.get();
        if (buf == null) {
            buf = this.buffer;
            bufferSize = this.bufferSize;
            this.buffer.clear();
        }
        if (this.inProgress == null) {
            return 0;
        }
        int pos = 0;
        buf.limit(buf.capacity());
        while (pos < bufferSize) {
            if (this.toWrite == 0) {
                if (this.newMsgFlag) {
                    this.inProgress = null;
                    break;
                }
                this.next();
            }
            if (pos == 0 && data.get() == null && this.toWrite >= bufferSize) {
                this.writeBuf.limit(this.writeBuf.capacity());
                data.set(this.writeBuf);
                pos = this.toWrite;
                this.writeBuf = null;
                this.toWrite = 0;
                return pos;
            }
            int toCopy = Math.min(this.toWrite, bufferSize - pos);
            int limit = this.writeBuf.limit();
            this.writeBuf.limit(Math.min(this.writeBuf.capacity(), this.writeBuf.position() + toCopy));
            int current = buf.position();
            buf.put(this.writeBuf);
            toCopy = buf.position() - current;
            this.writeBuf.limit(limit);
            pos += toCopy;
            this.toWrite -= toCopy;
        }
        data.set(buf);
        return pos;
    }

    @Override
    public void encoded() {
        this.buffer.flip();
    }

    protected void encodingError() {
        this.error = true;
    }

    public final boolean isError() {
        return this.error;
    }

    protected void next() {
        if (this.next != null) {
            this.next.run();
        }
    }

    protected void nextStep(Msg msg, Runnable state, boolean beginning) {
        if (msg == null) {
            this.nextStep((byte[])null, 0, state, beginning);
        } else {
            this.nextStep(msg.buf(), state, beginning);
        }
    }

    private void nextStep(byte[] buf, int toWrite, Runnable next, boolean newMsgFlag) {
        if (buf != null) {
            this.writeBuf = ByteBuffer.wrap(buf);
            this.writeBuf.limit(toWrite);
        } else {
            this.writeBuf = null;
        }
        this.toWrite = toWrite;
        this.next = next;
        this.newMsgFlag = newMsgFlag;
    }

    protected void initStep(Runnable next, boolean newMsgFlag) {
        this.nextStep((byte[])null, 0, next, newMsgFlag);
    }

    private void nextStep(ByteBuffer buf, Runnable next, boolean newMsgFlag) {
        this.nextStep(buf, buf.limit(), next, newMsgFlag);
    }

    protected void nextStep(ByteBuffer buf, int toWrite, Runnable next, boolean newMsgFlag) {
        buf.limit(toWrite);
        buf.position(toWrite);
        buf.flip();
        this.writeBuf = buf;
        this.toWrite = toWrite;
        this.next = next;
        this.newMsgFlag = newMsgFlag;
    }

    public int errno() {
        return this.errno.get();
    }

    public void errno(int err) {
        this.errno.set(err);
    }

    @Override
    public void destroy() {
    }
}

