/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.io.net;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.dflib.jjava.shaded.zmq.Options;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.io.IOThread;
import org.dflib.jjava.shaded.zmq.io.net.Address;
import org.dflib.jjava.shaded.zmq.io.net.Listener;
import org.dflib.jjava.shaded.zmq.io.net.ipc.IpcAddress;
import org.dflib.jjava.shaded.zmq.io.net.ipc.IpcListener;
import org.dflib.jjava.shaded.zmq.io.net.tcp.TcpAddress;
import org.dflib.jjava.shaded.zmq.io.net.tcp.TcpListener;
import org.dflib.jjava.shaded.zmq.io.net.tipc.TipcListener;
import org.dflib.jjava.shaded.zmq.socket.Sockets;

public enum NetProtocol {
    inproc(true, false, false, new Sockets[0]),
    ipc(true, false, false, new Sockets[0]){

        @Override
        public Listener getListener(IOThread ioThread, SocketBase socket, Options options) {
            return new IpcListener(ioThread, socket, options);
        }

        @Override
        public void resolve(Address paddr, boolean ipv6) {
            paddr.resolve(ipv6);
        }

        @Override
        public Address.IZAddress zresolve(String addr, boolean ipv6) {
            return new IpcAddress(addr);
        }
    }
    ,
    tcp(true, false, false, new Sockets[0]){

        @Override
        public Listener getListener(IOThread ioThread, SocketBase socket, Options options) {
            return new TcpListener(ioThread, socket, options);
        }

        @Override
        public void resolve(Address paddr, boolean ipv6) {
            paddr.resolve(ipv6);
        }

        @Override
        public Address.IZAddress zresolve(String addr, boolean ipv6) {
            return new TcpAddress(addr, ipv6);
        }
    }
    ,
    pgm(false, true, true, Sockets.PUB, Sockets.SUB, Sockets.XPUB, Sockets.XPUB),
    epgm(false, true, true, Sockets.PUB, Sockets.SUB, Sockets.XPUB, Sockets.XPUB),
    tipc(false, false, false, new Sockets[0]){

        @Override
        public Listener getListener(IOThread ioThread, SocketBase socket, Options options) {
            return new TipcListener(ioThread, socket, options);
        }

        @Override
        public void resolve(Address paddr, boolean ipv6) {
            paddr.resolve(ipv6);
        }
    }
    ,
    norm(false, true, true, new Sockets[0]);

    public final boolean valid;
    public final boolean subscribe2all;
    public final boolean isMulticast;
    private final Set<Integer> compatibles;

    private NetProtocol(boolean implemented, boolean subscribe2all, boolean isMulticast, Sockets ... compatibles) {
        this.valid = implemented;
        this.compatibles = Arrays.stream(compatibles).map(Enum::ordinal).collect(Collectors.toSet());
        this.subscribe2all = subscribe2all;
        this.isMulticast = isMulticast;
    }

    public static NetProtocol getProtocol(String protocol) {
        try {
            return NetProtocol.valueOf(protocol.toLowerCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Unknown protocol: \"" + protocol + "\"");
        }
    }

    public final boolean compatible(int type) {
        return this.compatibles.isEmpty() || this.compatibles.contains(type);
    }

    public Listener getListener(IOThread ioThread, SocketBase socket, Options options) {
        return null;
    }

    public void resolve(Address paddr, boolean ipv6) {
    }

    public Address.IZAddress zresolve(String addr, boolean ipv6) {
        return null;
    }
}

