/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.io.net.tcp;

import org.dflib.jjava.shaded.zmq.Options;
import org.dflib.jjava.shaded.zmq.io.IOThread;
import org.dflib.jjava.shaded.zmq.io.SessionBase;
import org.dflib.jjava.shaded.zmq.io.net.Address;
import org.dflib.jjava.shaded.zmq.io.net.NetProtocol;
import org.dflib.jjava.shaded.zmq.io.net.tcp.TcpConnecter;

public class SocksConnecter
extends TcpConnecter {
    Status status;
    String endpoint;

    public SocksConnecter(IOThread ioThread, SessionBase session, Options options, Address addr, Address proxyAddr, boolean delayedStart) {
        super(ioThread, session, options, addr, delayedStart);
        assert (NetProtocol.tcp.equals((Object)addr.protocol()));
        this.endpoint = proxyAddr.toString();
        this.status = Status.UNPLUGGED;
        throw new UnsupportedOperationException("Socks connecter is not implemented");
    }

    @Override
    protected void processPlug() {
        if (this.delayedStart) {
            this.startTimer();
        } else {
            this.initiateConnect();
        }
    }

    @Override
    protected void processTerm(int linger) {
        switch (this.status.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.ioObject.cancelTimer(1);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.close();
                break;
            }
        }
        super.processTerm(linger);
    }

    @Override
    public void inEvent() {
        assert (this.status != Status.UNPLUGGED && this.status != Status.WAITING_FOR_RECONNECT_TIME);
        super.inEvent();
    }

    @Override
    public void outEvent() {
        super.outEvent();
    }

    @Override
    public void timerEvent(int id) {
        super.timerEvent(id);
    }

    void initiateConnect() {
    }

    int processServerResponse() {
        return -1;
    }

    void parseAddress(String address, String hostname, int port) {
    }

    void connectToProxy() {
    }

    void error() {
    }

    void startTimer() {
    }

    int getNewReconnectIvl() {
        return -1;
    }

    int open() {
        return -1;
    }

    void checkProxyConnection() {
    }

    private static enum Status {
        UNPLUGGED,
        WAITING_FOR_RECONNECT_TIME,
        WAITING_FOR_PROXY_CONNECTION,
        SENDING_GREETING,
        WAITING_FOR_CHOICE,
        SENDING_REQUEST,
        WAITING_FOR_RESPONSE;

    }
}

