/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.pipe;

import org.dflib.jjava.shaded.zmq.Config;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.ZObject;
import org.dflib.jjava.shaded.zmq.pipe.YPipe;
import org.dflib.jjava.shaded.zmq.pipe.YPipeBase;
import org.dflib.jjava.shaded.zmq.pipe.YPipeConflate;
import org.dflib.jjava.shaded.zmq.util.Blob;

public class Pipe
extends ZObject {
    private YPipeBase<Msg> inpipe;
    private YPipeBase<Msg> outpipe;
    private boolean inActive;
    private boolean outActive;
    private int hwm;
    private int lwm;
    private long msgsRead;
    private long msgsWritten;
    private long peersMsgsRead;
    private Pipe peer;
    private IPipeEvents sink;
    private State state;
    private boolean delay;
    private Blob identity;
    private int routingId;
    private Blob credential;
    private final boolean conflate;
    private Msg disconnectMsg;
    private final ZObject parent;

    private Pipe(ZObject parent, YPipeBase<Msg> inpipe, YPipeBase<Msg> outpipe, int inhwm, int outhwm, boolean conflate) {
        super(parent);
        this.inpipe = inpipe;
        this.outpipe = outpipe;
        this.inActive = true;
        this.outActive = true;
        this.hwm = outhwm;
        this.lwm = Pipe.computeLwm(inhwm);
        this.msgsRead = 0L;
        this.msgsWritten = 0L;
        this.peersMsgsRead = 0L;
        this.peer = null;
        this.sink = null;
        this.state = State.ACTIVE;
        this.delay = true;
        this.conflate = conflate;
        this.disconnectMsg = null;
        this.parent = parent;
    }

    public static Pipe[] pair(ZObject[] parents, int[] hwms, boolean[] conflates) {
        Pipe[] pipes = new Pipe[2];
        YPipeConflate<Msg> upipe1 = conflates[0] ? new YPipeConflate() : new YPipe(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        YPipeConflate<Msg> upipe2 = conflates[1] ? new YPipeConflate() : new YPipe(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        pipes[0] = new Pipe(parents[0], upipe1, upipe2, hwms[1], hwms[0], conflates[0]);
        pipes[1] = new Pipe(parents[1], upipe2, upipe1, hwms[0], hwms[1], conflates[1]);
        pipes[0].setPeer(pipes[1]);
        pipes[1].setPeer(pipes[0]);
        return pipes;
    }

    private void setPeer(Pipe peer) {
        assert (this.peer == null);
        assert (peer != null);
        this.peer = peer;
    }

    public void setEventSink(IPipeEvents sink) {
        assert (this.sink == null);
        this.sink = sink;
    }

    public void setIdentity(Blob identity) {
        this.identity = identity;
    }

    public Blob getIdentity() {
        return this.identity;
    }

    public void setRoutingId(int routingId) {
        this.routingId = routingId;
    }

    public int getRoutingId() {
        return this.routingId;
    }

    public Blob getCredential() {
        return this.credential;
    }

    public boolean checkRead() {
        if (!this.inActive) {
            return false;
        }
        if (this.state != State.ACTIVE && this.state != State.WAITING_FOR_DELIMITER) {
            return false;
        }
        if (!this.inpipe.checkRead()) {
            this.inActive = false;
            return false;
        }
        if (Pipe.isDelimiter(this.inpipe.probe())) {
            Msg msg = this.inpipe.read();
            assert (msg != null);
            this.processDelimiter();
            return false;
        }
        return true;
    }

    public Msg read() {
        Msg msg;
        if (!this.inActive) {
            return null;
        }
        if (this.state != State.ACTIVE && this.state != State.WAITING_FOR_DELIMITER) {
            return null;
        }
        while (true) {
            if ((msg = this.inpipe.read()) == null) {
                this.inActive = false;
                return null;
            }
            if (!msg.isCredential()) break;
            this.credential = Blob.createBlob(msg);
        }
        if (msg.isDelimiter()) {
            this.processDelimiter();
            return null;
        }
        if (!msg.hasMore() && !msg.isIdentity()) {
            ++this.msgsRead;
        }
        if (this.lwm > 0 && this.msgsRead % (long)this.lwm == 0L) {
            this.sendActivateWrite(this.peer, this.msgsRead);
        }
        return msg;
    }

    public boolean checkWrite() {
        boolean full;
        if (!this.outActive || this.state != State.ACTIVE) {
            return false;
        }
        boolean bl = full = !this.checkHwm();
        if (full) {
            this.outActive = false;
            return false;
        }
        return true;
    }

    public boolean write(Msg msg) {
        if (!this.checkWrite()) {
            return false;
        }
        boolean more = msg.hasMore();
        boolean identity = msg.isIdentity();
        this.outpipe.write(msg, more);
        if (!more && !identity) {
            ++this.msgsWritten;
        }
        return true;
    }

    public void rollback() {
        if (this.outpipe != null) {
            Msg msg;
            while ((msg = this.outpipe.unwrite()) != null) {
                assert (msg.hasMore());
            }
        }
    }

    public void flush() {
        if (this.state == State.TERM_ACK_SENT) {
            return;
        }
        if (this.outpipe != null && !this.outpipe.flush()) {
            this.sendActivateRead(this.peer);
        }
    }

    @Override
    protected void processActivateRead() {
        if (!(this.inActive || this.state != State.ACTIVE && this.state != State.WAITING_FOR_DELIMITER)) {
            this.inActive = true;
            this.sink.readActivated(this);
        }
    }

    @Override
    protected void processActivateWrite(long msgsRead) {
        this.peersMsgsRead = msgsRead;
        if (!this.outActive && this.state == State.ACTIVE) {
            this.outActive = true;
            this.sink.writeActivated(this);
        }
    }

    @Override
    protected void processHiccup(YPipeBase<Msg> pipe) {
        Msg msg;
        assert (this.outpipe != null);
        this.outpipe.flush();
        while ((msg = this.outpipe.read()) != null) {
            if (msg.hasMore()) continue;
            --this.msgsWritten;
        }
        assert (pipe != null);
        this.outpipe = pipe;
        this.outActive = true;
        if (this.state == State.ACTIVE) {
            this.sink.hiccuped(this);
        }
    }

    @Override
    protected void processPipeTerm() {
        assert (this.state == State.ACTIVE || this.state == State.DELIMITER_RECEIVED || this.state == State.TERM_REQ_SENT_1);
        if (this.state == State.ACTIVE) {
            if (this.delay) {
                this.state = State.WAITING_FOR_DELIMITER;
            } else {
                this.state = State.TERM_ACK_SENT;
                this.outpipe = null;
                this.sendPipeTermAck(this.peer);
            }
        } else if (this.state == State.DELIMITER_RECEIVED) {
            this.state = State.TERM_ACK_SENT;
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
        } else if (this.state == State.TERM_REQ_SENT_1) {
            this.state = State.TERM_REQ_SENT_2;
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
        }
    }

    @Override
    protected void processPipeTermAck() {
        assert (this.sink != null);
        this.sink.pipeTerminated(this);
        if (this.state == State.TERM_REQ_SENT_1) {
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
        } else assert (this.state == State.TERM_ACK_SENT || this.state == State.TERM_REQ_SENT_2);
        if (this.inpipe == null) {
            return;
        }
        if (!this.conflate) {
            while (this.inpipe.read() != null) {
            }
        }
        this.inpipe = null;
    }

    public void setNoDelay() {
        this.delay = false;
    }

    public void terminate(boolean delay) {
        this.delay = delay;
        if (this.state == State.TERM_REQ_SENT_1 || this.state == State.TERM_REQ_SENT_2) {
            return;
        }
        if (this.state == State.TERM_ACK_SENT) {
            return;
        }
        if (this.state == State.ACTIVE) {
            this.sendPipeTerm(this.peer);
            this.state = State.TERM_REQ_SENT_1;
        } else if (this.state == State.WAITING_FOR_DELIMITER && !this.delay) {
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
            this.state = State.TERM_ACK_SENT;
        } else if (this.state != State.WAITING_FOR_DELIMITER) {
            if (this.state == State.DELIMITER_RECEIVED) {
                this.sendPipeTerm(this.peer);
                this.state = State.TERM_REQ_SENT_1;
            } else assert (false);
        }
        this.outActive = false;
        if (this.outpipe != null) {
            this.rollback();
            Msg msg = new Msg();
            msg.initDelimiter();
            this.outpipe.write(msg, false);
            this.flush();
        }
    }

    private static boolean isDelimiter(Msg msg) {
        return msg.isDelimiter();
    }

    private static int computeLwm(int hwm) {
        return (hwm + 1) / 2;
    }

    private void processDelimiter() {
        assert (this.state == State.ACTIVE || this.state == State.WAITING_FOR_DELIMITER);
        if (this.state == State.ACTIVE) {
            this.state = State.DELIMITER_RECEIVED;
        } else {
            this.outpipe = null;
            this.sendPipeTermAck(this.peer);
            this.state = State.TERM_ACK_SENT;
        }
    }

    public void hiccup() {
        if (this.state != State.ACTIVE) {
            return;
        }
        this.inpipe = null;
        this.inpipe = this.conflate ? new YPipeConflate<Msg>() : new YPipe<Msg>(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        this.inActive = true;
        this.sendHiccup(this.peer, this.inpipe);
    }

    public void setHwms(int inhwm, int outhwm) {
        this.lwm = Pipe.computeLwm(inhwm);
        this.hwm = outhwm;
    }

    public boolean checkHwm() {
        boolean full = this.hwm > 0 && this.msgsWritten - this.peersMsgsRead >= (long)this.hwm;
        return !full;
    }

    public void setDisconnectMsg(Msg msg) {
        this.disconnectMsg = msg;
    }

    public void sendDisconnectMsg() {
        if (this.disconnectMsg != null && this.outpipe != null) {
            this.rollback();
            this.outpipe.write(this.disconnectMsg, false);
            this.flush();
            this.disconnectMsg = null;
        }
    }

    public void sendHiccupMsg(Msg hiccupMsg) {
        if (hiccupMsg != null && this.outpipe != null) {
            this.rollback();
            this.outpipe.write(hiccupMsg, false);
            this.flush();
        }
    }

    public String toString() {
        return super.toString() + "(" + this.parent.getClass().getSimpleName() + "[" + this.parent.getTid() + "]->" + this.peer.parent.getClass().getSimpleName() + "[" + this.peer.parent.getTid() + "])";
    }

    public static interface IPipeEvents {
        public void readActivated(Pipe var1);

        public void writeActivated(Pipe var1);

        public void hiccuped(Pipe var1);

        public void pipeTerminated(Pipe var1);
    }

    static enum State {
        ACTIVE,
        DELIMITER_RECEIVED,
        WAITING_FOR_DELIMITER,
        TERM_ACK_SENT,
        TERM_REQ_SENT_1,
        TERM_REQ_SENT_2;

    }
}

