/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.socket;

import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.pipe.Pipe;
import org.dflib.jjava.shaded.zmq.util.Blob;

public class Pair
extends SocketBase {
    private Pipe pipe;
    private Pipe lastIn;
    private Blob savedCredential;

    public Pair(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 0;
    }

    @Override
    protected void destroy() {
        super.destroy();
        assert (this.pipe == null);
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        if (this.pipe == null) {
            this.pipe = pipe;
        } else {
            pipe.terminate(false);
        }
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        if (this.pipe == pipe) {
            if (this.lastIn == pipe) {
                this.savedCredential = this.lastIn.getCredential();
                this.lastIn = null;
            }
            this.pipe = null;
        }
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (this.pipe == null || !this.pipe.write(msg)) {
            this.errno.set(35);
            return false;
        }
        if (!msg.hasMore()) {
            this.pipe.flush();
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        if (this.pipe == null) {
            this.errno.set(35);
            return null;
        }
        Msg msg = this.pipe.read();
        if (msg == null) {
            this.errno.set(35);
            return null;
        }
        this.lastIn = this.pipe;
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return this.pipe != null && this.pipe.checkRead();
    }

    @Override
    protected boolean xhasOut() {
        return this.pipe != null && this.pipe.checkWrite();
    }

    @Override
    protected Blob getCredential() {
        return this.lastIn != null ? this.lastIn.getCredential() : this.savedCredential;
    }
}

