/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.socket;

import java.util.Arrays;
import java.util.List;
import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Options;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.io.HelloMsgSession;
import org.dflib.jjava.shaded.zmq.io.IOThread;
import org.dflib.jjava.shaded.zmq.io.SessionBase;
import org.dflib.jjava.shaded.zmq.io.net.Address;
import org.dflib.jjava.shaded.zmq.socket.Channel;
import org.dflib.jjava.shaded.zmq.socket.Pair;
import org.dflib.jjava.shaded.zmq.socket.Peer;
import org.dflib.jjava.shaded.zmq.socket.Raw;
import org.dflib.jjava.shaded.zmq.socket.Stream;
import org.dflib.jjava.shaded.zmq.socket.clientserver.Client;
import org.dflib.jjava.shaded.zmq.socket.clientserver.Server;
import org.dflib.jjava.shaded.zmq.socket.pipeline.Pull;
import org.dflib.jjava.shaded.zmq.socket.pipeline.Push;
import org.dflib.jjava.shaded.zmq.socket.pubsub.Pub;
import org.dflib.jjava.shaded.zmq.socket.pubsub.Sub;
import org.dflib.jjava.shaded.zmq.socket.pubsub.XPub;
import org.dflib.jjava.shaded.zmq.socket.pubsub.XSub;
import org.dflib.jjava.shaded.zmq.socket.radiodish.Dish;
import org.dflib.jjava.shaded.zmq.socket.radiodish.Radio;
import org.dflib.jjava.shaded.zmq.socket.reqrep.Dealer;
import org.dflib.jjava.shaded.zmq.socket.reqrep.Rep;
import org.dflib.jjava.shaded.zmq.socket.reqrep.Req;
import org.dflib.jjava.shaded.zmq.socket.reqrep.Router;
import org.dflib.jjava.shaded.zmq.socket.scattergather.Gather;
import org.dflib.jjava.shaded.zmq.socket.scattergather.Scatter;

public enum Sockets {
    PAIR(new String[]{"PAIR"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Pair(parent, tid, sid);
        }
    }
    ,
    PUB(new String[]{"SUB", "XSUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Pub(parent, tid, sid);
        }
    }
    ,
    SUB(new String[]{"PUB", "XPUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Sub(parent, tid, sid);
        }
    }
    ,
    REQ(new String[]{"REP", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Req(parent, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            return new Req.ReqSession(ioThread, connect, socket, options, addr);
        }
    }
    ,
    REP(new String[]{"REQ", "DEALER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Rep(parent, tid, sid);
        }
    }
    ,
    DEALER(new String[]{"REP", "DEALER", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Dealer(parent, tid, sid);
        }
    }
    ,
    ROUTER(new String[]{"REQ", "DEALER", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Router(parent, tid, sid);
        }
    }
    ,
    PULL(new String[]{"PUSH"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Pull(parent, tid, sid);
        }
    }
    ,
    PUSH(new String[]{"PULL"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Push(parent, tid, sid);
        }
    }
    ,
    XPUB(new String[]{"SUB", "XSUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new XPub(parent, tid, sid);
        }
    }
    ,
    XSUB(new String[]{"PUB", "XPUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new XSub(parent, tid, sid);
        }
    }
    ,
    STREAM(new String[0]){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Stream(parent, tid, sid);
        }
    }
    ,
    SERVER(new String[]{"CLIENT"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Server(parent, tid, sid);
        }
    }
    ,
    CLIENT(new String[]{"SERVER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Client(parent, tid, sid);
        }
    }
    ,
    RADIO(new String[]{"DISH"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Radio(parent, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            return new Radio.RadioSession(ioThread, connect, socket, options, addr);
        }
    }
    ,
    DISH(new String[]{"RADIO"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Dish(parent, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            return new Dish.DishSession(ioThread, connect, socket, options, addr);
        }
    }
    ,
    CHANNEL(new String[]{"CHANNEL"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Channel(parent, tid, sid);
        }
    }
    ,
    PEER(new String[]{"PEER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Peer(parent, tid, sid);
        }
    }
    ,
    RAW(new String[0]){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Raw(parent, tid, sid);
        }
    }
    ,
    SCATTER(new String[]{"GATHER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Scatter(parent, tid, sid);
        }
    }
    ,
    GATHER(new String[]{"SCATTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Gather(parent, tid, sid);
        }
    };

    private static final Sockets[] VALUES;
    private final List<String> compatible;

    private Sockets(String ... compatible) {
        this.compatible = Arrays.asList(compatible);
    }

    abstract SocketBase create(Ctx var1, int var2, int var3);

    public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        if (options.canSendHelloMsg && options.helloMsg != null) {
            return new HelloMsgSession(ioThread, connect, socket, options, addr);
        }
        return new SessionBase(ioThread, connect, socket, options, addr);
    }

    public static SessionBase createSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        return VALUES[options.type].create(ioThread, connect, socket, options, addr);
    }

    public static SocketBase create(int socketType, Ctx parent, int tid, int sid) {
        return VALUES[socketType].create(parent, tid, sid);
    }

    public static String name(int socketType) {
        return VALUES[socketType].name();
    }

    public static Sockets fromType(int socketType) {
        return VALUES[socketType];
    }

    public static boolean compatible(int self, String peer) {
        return Sockets.VALUES[self].compatible.contains(peer);
    }

    static {
        VALUES = Sockets.values();
    }
}

