/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.supplier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.dflib.jjava.shaded.org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.dflib.jjava.shaded.org.apache.maven.model.building.ModelBuilder;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.DefaultModelCacheFactory;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.DefaultVersionResolver;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.ModelCacheFactory;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.PluginsMetadataGeneratorFactory;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.dflib.jjava.shaded.org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultOfflineController;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultRepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.DefaultTrackingFileManager;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.SparseDirectoryTrustedChecksumsSource;
import org.eclipse.aether.internal.impl.checksum.SummaryFileTrustedChecksumsSource;
import org.eclipse.aether.internal.impl.checksum.TrustedToProvidedChecksumsSourceAdapter;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector;
import org.eclipse.aether.internal.impl.collect.df.DfDependencyCollector;
import org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager;
import org.eclipse.aether.internal.impl.filter.GroupIdRemoteRepositoryFilterSource;
import org.eclipse.aether.internal.impl.filter.PrefixesRemoteRepositoryFilterSource;
import org.eclipse.aether.internal.impl.resolution.TrustedChecksumsArtifactResolverPostProcessor;
import org.eclipse.aether.internal.impl.synccontext.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NameMappers;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactoryImpl;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.eclipse.aether.named.providers.NoopNamedLockFactory;
import org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.ChecksumExtractor;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transport.http.Nexus2ChecksumExtractor;
import org.eclipse.aether.transport.http.XChecksumChecksumExtractor;

public class RepositorySystemSupplier
implements Supplier<RepositorySystem> {
    protected FileProcessor getFileProcessor() {
        return new DefaultFileProcessor();
    }

    protected TrackingFileManager getTrackingFileManager() {
        return new DefaultTrackingFileManager();
    }

    protected LocalPathComposer getLocalPathComposer() {
        return new DefaultLocalPathComposer();
    }

    protected LocalPathPrefixComposerFactory getLocalPathPrefixComposerFactory() {
        return new DefaultLocalPathPrefixComposerFactory();
    }

    protected RepositorySystemLifecycle getRepositorySystemLifecycle() {
        return new DefaultRepositorySystemLifecycle();
    }

    protected OfflineController getOfflineController() {
        return new DefaultOfflineController();
    }

    protected UpdatePolicyAnalyzer getUpdatePolicyAnalyzer() {
        return new DefaultUpdatePolicyAnalyzer();
    }

    protected ChecksumPolicyProvider getChecksumPolicyProvider() {
        return new DefaultChecksumPolicyProvider();
    }

    protected UpdateCheckManager getUpdateCheckManager(TrackingFileManager trackingFileManager, UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        return new DefaultUpdateCheckManager(trackingFileManager, updatePolicyAnalyzer);
    }

    protected Map<String, NamedLockFactory> getNamedLockFactories() {
        HashMap<String, NamedLockFactory> result = new HashMap<String, NamedLockFactory>();
        result.put("noop", new NoopNamedLockFactory());
        result.put("rwlock-local", new LocalReadWriteLockNamedLockFactory());
        result.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        result.put("file-lock", new FileLockNamedLockFactory());
        return result;
    }

    protected Map<String, NameMapper> getNameMappers() {
        HashMap<String, NameMapper> result = new HashMap<String, NameMapper>();
        result.put("static", NameMappers.staticNameMapper());
        result.put("gav", NameMappers.gavNameMapper());
        result.put("discriminating", NameMappers.discriminatingNameMapper());
        result.put("file-gav", NameMappers.fileGavNameMapper());
        result.put("file-hgav", NameMappers.fileHashingGavNameMapper());
        return result;
    }

    protected NamedLockFactoryAdapterFactory getNamedLockFactoryAdapterFactory(Map<String, NamedLockFactory> namedLockFactories, Map<String, NameMapper> nameMappers, RepositorySystemLifecycle repositorySystemLifecycle) {
        return new NamedLockFactoryAdapterFactoryImpl(namedLockFactories, nameMappers, repositorySystemLifecycle);
    }

    protected SyncContextFactory getSyncContextFactory(NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory) {
        return new DefaultSyncContextFactory(namedLockFactoryAdapterFactory);
    }

    protected Map<String, ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        HashMap<String, ChecksumAlgorithmFactory> result = new HashMap<String, ChecksumAlgorithmFactory>();
        result.put("SHA-512", new Sha512ChecksumAlgorithmFactory());
        result.put("SHA-256", new Sha256ChecksumAlgorithmFactory());
        result.put("SHA-1", new Sha1ChecksumAlgorithmFactory());
        result.put("MD5", new Md5ChecksumAlgorithmFactory());
        return result;
    }

    protected ChecksumAlgorithmFactorySelector getChecksumAlgorithmFactorySelector(Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        return new DefaultChecksumAlgorithmFactorySelector(checksumAlgorithmFactories);
    }

    protected Map<String, RepositoryLayoutFactory> getRepositoryLayoutFactories(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        HashMap<String, RepositoryLayoutFactory> result = new HashMap<String, RepositoryLayoutFactory>();
        result.put("maven2", new Maven2RepositoryLayoutFactory(checksumAlgorithmFactorySelector));
        return result;
    }

    protected RepositoryLayoutProvider getRepositoryLayoutProvider(Map<String, RepositoryLayoutFactory> repositoryLayoutFactories) {
        return new DefaultRepositoryLayoutProvider(new HashSet<RepositoryLayoutFactory>(repositoryLayoutFactories.values()));
    }

    protected LocalRepositoryProvider getLocalRepositoryProvider(LocalPathComposer localPathComposer, TrackingFileManager trackingFileManager, LocalPathPrefixComposerFactory localPathPrefixComposerFactory) {
        HashSet<LocalRepositoryManagerFactory> localRepositoryProviders = new HashSet<LocalRepositoryManagerFactory>(2);
        localRepositoryProviders.add(new SimpleLocalRepositoryManagerFactory(localPathComposer));
        localRepositoryProviders.add(new EnhancedLocalRepositoryManagerFactory(localPathComposer, trackingFileManager, localPathPrefixComposerFactory));
        return new DefaultLocalRepositoryProvider(localRepositoryProviders);
    }

    protected RemoteRepositoryManager getRemoteRepositoryManager(UpdatePolicyAnalyzer updatePolicyAnalyzer, ChecksumPolicyProvider checksumPolicyProvider) {
        return new DefaultRemoteRepositoryManager(updatePolicyAnalyzer, checksumPolicyProvider);
    }

    protected Map<String, RemoteRepositoryFilterSource> getRemoteRepositoryFilterSources(RepositorySystemLifecycle repositorySystemLifecycle, RepositoryLayoutProvider repositoryLayoutProvider) {
        HashMap<String, RemoteRepositoryFilterSource> result = new HashMap<String, RemoteRepositoryFilterSource>();
        result.put("groupId", new GroupIdRemoteRepositoryFilterSource(repositorySystemLifecycle));
        result.put("prefixes", new PrefixesRemoteRepositoryFilterSource(repositoryLayoutProvider));
        return result;
    }

    protected RemoteRepositoryFilterManager getRemoteRepositoryFilterManager(Map<String, RemoteRepositoryFilterSource> remoteRepositoryFilterSources) {
        return new DefaultRemoteRepositoryFilterManager(remoteRepositoryFilterSources);
    }

    protected Map<String, RepositoryListener> getRepositoryListeners() {
        return new HashMap<String, RepositoryListener>();
    }

    protected RepositoryEventDispatcher getRepositoryEventDispatcher(Map<String, RepositoryListener> repositoryListeners) {
        return new DefaultRepositoryEventDispatcher(new HashSet<RepositoryListener>(repositoryListeners.values()));
    }

    protected Map<String, TrustedChecksumsSource> getTrustedChecksumsSources(FileProcessor fileProcessor, LocalPathComposer localPathComposer, RepositorySystemLifecycle repositorySystemLifecycle) {
        HashMap<String, TrustedChecksumsSource> result = new HashMap<String, TrustedChecksumsSource>();
        result.put("sparseDirectory", new SparseDirectoryTrustedChecksumsSource(fileProcessor, localPathComposer));
        result.put("summaryFile", new SummaryFileTrustedChecksumsSource(localPathComposer, repositorySystemLifecycle));
        return result;
    }

    protected Map<String, ProvidedChecksumsSource> getProvidedChecksumsSources(Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        HashMap<String, ProvidedChecksumsSource> result = new HashMap<String, ProvidedChecksumsSource>();
        result.put("trusted2provided", new TrustedToProvidedChecksumsSourceAdapter(trustedChecksumsSources));
        return result;
    }

    protected Map<String, ChecksumExtractor> getChecksumExtractors() {
        HashMap<String, ChecksumExtractor> result = new HashMap<String, ChecksumExtractor>();
        result.put("nexus2", new Nexus2ChecksumExtractor());
        result.put("x-checksum", new XChecksumChecksumExtractor());
        return result;
    }

    protected Map<String, TransporterFactory> getTransporterFactories(Map<String, ChecksumExtractor> extractors) {
        HashMap<String, TransporterFactory> result = new HashMap<String, TransporterFactory>();
        result.put("file", new FileTransporterFactory());
        result.put("http", new HttpTransporterFactory(extractors));
        return result;
    }

    protected TransporterProvider getTransporterProvider(Map<String, TransporterFactory> transporterFactories) {
        return new DefaultTransporterProvider(new HashSet<TransporterFactory>(transporterFactories.values()));
    }

    protected BasicRepositoryConnectorFactory getBasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider repositoryLayoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        return new BasicRepositoryConnectorFactory(transporterProvider, repositoryLayoutProvider, checksumPolicyProvider, fileProcessor, providedChecksumsSources);
    }

    protected Map<String, RepositoryConnectorFactory> getRepositoryConnectorFactories(BasicRepositoryConnectorFactory basicRepositoryConnectorFactory) {
        HashMap<String, RepositoryConnectorFactory> result = new HashMap<String, RepositoryConnectorFactory>();
        result.put("basic", basicRepositoryConnectorFactory);
        return result;
    }

    protected RepositoryConnectorProvider getRepositoryConnectorProvider(Map<String, RepositoryConnectorFactory> repositoryConnectorFactories, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        return new DefaultRepositoryConnectorProvider(new HashSet<RepositoryConnectorFactory>(repositoryConnectorFactories.values()), remoteRepositoryFilterManager);
    }

    protected Installer getInstaller(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Map<String, MetadataGeneratorFactory> metadataGeneratorFactories, SyncContextFactory syncContextFactory) {
        return new DefaultInstaller(fileProcessor, repositoryEventDispatcher, new HashSet<MetadataGeneratorFactory>(metadataGeneratorFactories.values()), syncContextFactory);
    }

    protected Deployer getDeployer(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, UpdateCheckManager updateCheckManager, Map<String, MetadataGeneratorFactory> metadataGeneratorFactories, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        return new DefaultDeployer(fileProcessor, repositoryEventDispatcher, repositoryConnectorProvider, remoteRepositoryManager, updateCheckManager, new HashSet<MetadataGeneratorFactory>(metadataGeneratorFactories.values()), syncContextFactory, offlineController);
    }

    protected Map<String, DependencyCollectorDelegate> getDependencyCollectorDelegates(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        HashMap<String, DependencyCollectorDelegate> result = new HashMap<String, DependencyCollectorDelegate>();
        result.put("df", new DfDependencyCollector(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver));
        result.put("bf", new BfDependencyCollector(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver));
        return result;
    }

    protected DependencyCollector getDependencyCollector(Map<String, DependencyCollectorDelegate> dependencyCollectorDelegates) {
        return new DefaultDependencyCollector(dependencyCollectorDelegates);
    }

    protected Map<String, ArtifactResolverPostProcessor> getArtifactResolverPostProcessors(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        HashMap<String, ArtifactResolverPostProcessor> result = new HashMap<String, ArtifactResolverPostProcessor>();
        result.put("trustedChecksums", new TrustedChecksumsArtifactResolverPostProcessor(checksumAlgorithmFactorySelector, trustedChecksumsSources));
        return result;
    }

    protected ArtifactResolver getArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        return new DefaultArtifactResolver(fileProcessor, repositoryEventDispatcher, versionResolver, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, artifactResolverPostProcessors, remoteRepositoryFilterManager);
    }

    protected MetadataResolver getMetadataResolver(RepositoryEventDispatcher repositoryEventDispatcher, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        return new DefaultMetadataResolver(repositoryEventDispatcher, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, remoteRepositoryFilterManager);
    }

    protected Map<String, MetadataGeneratorFactory> getMetadataGeneratorFactories() {
        HashMap<String, MetadataGeneratorFactory> result = new HashMap<String, MetadataGeneratorFactory>();
        result.put("plugins", new PluginsMetadataGeneratorFactory());
        result.put("versions", new VersionsMetadataGeneratorFactory());
        result.put("snapshot", new SnapshotMetadataGeneratorFactory());
        return result;
    }

    protected ArtifactDescriptorReader getArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, ModelCacheFactory modelCacheFactory) {
        DefaultArtifactDescriptorReader result = new DefaultArtifactDescriptorReader();
        result.setRemoteRepositoryManager(remoteRepositoryManager);
        result.setVersionResolver(versionResolver);
        result.setVersionRangeResolver(versionRangeResolver);
        result.setArtifactResolver(artifactResolver);
        result.setModelBuilder(modelBuilder);
        result.setRepositoryEventDispatcher(repositoryEventDispatcher);
        result.setModelCacheFactory(modelCacheFactory);
        return result;
    }

    protected VersionResolver getVersionResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher) {
        DefaultVersionResolver result = new DefaultVersionResolver();
        result.setMetadataResolver(metadataResolver);
        result.setSyncContextFactory(syncContextFactory);
        result.setRepositoryEventDispatcher(repositoryEventDispatcher);
        return result;
    }

    protected VersionRangeResolver getVersionRangeResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher) {
        DefaultVersionRangeResolver result = new DefaultVersionRangeResolver();
        result.setMetadataResolver(metadataResolver);
        result.setSyncContextFactory(syncContextFactory);
        result.setRepositoryEventDispatcher(repositoryEventDispatcher);
        return result;
    }

    protected ModelBuilder getModelBuilder() {
        return new DefaultModelBuilderFactory().newInstance();
    }

    protected ModelCacheFactory getModelCacheFactory() {
        return new DefaultModelCacheFactory();
    }

    @Override
    public RepositorySystem get() {
        FileProcessor fileProcessor = this.getFileProcessor();
        TrackingFileManager trackingFileManager = this.getTrackingFileManager();
        LocalPathComposer localPathComposer = this.getLocalPathComposer();
        LocalPathPrefixComposerFactory localPathPrefixComposerFactory = this.getLocalPathPrefixComposerFactory();
        RepositorySystemLifecycle repositorySystemLifecycle = this.getRepositorySystemLifecycle();
        OfflineController offlineController = this.getOfflineController();
        UpdatePolicyAnalyzer updatePolicyAnalyzer = this.getUpdatePolicyAnalyzer();
        ChecksumPolicyProvider checksumPolicyProvider = this.getChecksumPolicyProvider();
        UpdateCheckManager updateCheckManager = this.getUpdateCheckManager(trackingFileManager, updatePolicyAnalyzer);
        Map<String, NamedLockFactory> namedLockFactories = this.getNamedLockFactories();
        Map<String, NameMapper> nameMappers = this.getNameMappers();
        NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory = this.getNamedLockFactoryAdapterFactory(namedLockFactories, nameMappers, repositorySystemLifecycle);
        SyncContextFactory syncContextFactory = this.getSyncContextFactory(namedLockFactoryAdapterFactory);
        Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories = this.getChecksumAlgorithmFactories();
        ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector = this.getChecksumAlgorithmFactorySelector(checksumAlgorithmFactories);
        Map<String, RepositoryLayoutFactory> repositoryLayoutFactories = this.getRepositoryLayoutFactories(checksumAlgorithmFactorySelector);
        RepositoryLayoutProvider repositoryLayoutProvider = this.getRepositoryLayoutProvider(repositoryLayoutFactories);
        LocalRepositoryProvider localRepositoryProvider = this.getLocalRepositoryProvider(localPathComposer, trackingFileManager, localPathPrefixComposerFactory);
        RemoteRepositoryManager remoteRepositoryManager = this.getRemoteRepositoryManager(updatePolicyAnalyzer, checksumPolicyProvider);
        Map<String, RemoteRepositoryFilterSource> remoteRepositoryFilterSources = this.getRemoteRepositoryFilterSources(repositorySystemLifecycle, repositoryLayoutProvider);
        RemoteRepositoryFilterManager remoteRepositoryFilterManager = this.getRemoteRepositoryFilterManager(remoteRepositoryFilterSources);
        Map<String, RepositoryListener> repositoryListeners = this.getRepositoryListeners();
        RepositoryEventDispatcher repositoryEventDispatcher = this.getRepositoryEventDispatcher(repositoryListeners);
        Map<String, TrustedChecksumsSource> trustedChecksumsSources = this.getTrustedChecksumsSources(fileProcessor, localPathComposer, repositorySystemLifecycle);
        Map<String, ProvidedChecksumsSource> providedChecksumsSources = this.getProvidedChecksumsSources(trustedChecksumsSources);
        Map<String, ChecksumExtractor> checksumExtractors = this.getChecksumExtractors();
        Map<String, TransporterFactory> transporterFactories = this.getTransporterFactories(checksumExtractors);
        TransporterProvider transporterProvider = this.getTransporterProvider(transporterFactories);
        BasicRepositoryConnectorFactory basic = this.getBasicRepositoryConnectorFactory(transporterProvider, repositoryLayoutProvider, checksumPolicyProvider, fileProcessor, providedChecksumsSources);
        Map<String, RepositoryConnectorFactory> repositoryConnectorFactories = this.getRepositoryConnectorFactories(basic);
        RepositoryConnectorProvider repositoryConnectorProvider = this.getRepositoryConnectorProvider(repositoryConnectorFactories, remoteRepositoryFilterManager);
        Map<String, MetadataGeneratorFactory> metadataGeneratorFactories = this.getMetadataGeneratorFactories();
        Installer installer = this.getInstaller(fileProcessor, repositoryEventDispatcher, metadataGeneratorFactories, syncContextFactory);
        Deployer deployer = this.getDeployer(fileProcessor, repositoryEventDispatcher, repositoryConnectorProvider, remoteRepositoryManager, updateCheckManager, metadataGeneratorFactories, syncContextFactory, offlineController);
        MetadataResolver metadataResolver = this.getMetadataResolver(repositoryEventDispatcher, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, remoteRepositoryFilterManager);
        VersionResolver versionResolver = this.getVersionResolver(metadataResolver, syncContextFactory, repositoryEventDispatcher);
        VersionRangeResolver versionRangeResolver = this.getVersionRangeResolver(metadataResolver, syncContextFactory, repositoryEventDispatcher);
        Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors = this.getArtifactResolverPostProcessors(checksumAlgorithmFactorySelector, trustedChecksumsSources);
        ArtifactResolver artifactResolver = this.getArtifactResolver(fileProcessor, repositoryEventDispatcher, versionResolver, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, artifactResolverPostProcessors, remoteRepositoryFilterManager);
        ModelBuilder modelBuilder = this.getModelBuilder();
        ModelCacheFactory modelCacheFactory = this.getModelCacheFactory();
        ArtifactDescriptorReader artifactDescriptorReader = this.getArtifactDescriptorReader(remoteRepositoryManager, versionResolver, versionRangeResolver, artifactResolver, modelBuilder, repositoryEventDispatcher, modelCacheFactory);
        Map<String, DependencyCollectorDelegate> dependencyCollectorDelegates = this.getDependencyCollectorDelegates(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
        DependencyCollector dependencyCollector = this.getDependencyCollector(dependencyCollectorDelegates);
        return new DefaultRepositorySystem(versionResolver, versionRangeResolver, artifactResolver, metadataResolver, artifactDescriptorReader, dependencyCollector, installer, deployer, localRepositoryProvider, syncContextFactory, remoteRepositoryManager, repositorySystemLifecycle);
    }
}

