/* Copyright (c) 2025 Centre National d'Etudes Spatiales (CNES).
 *
 * This file is part of PANDORA2D
 *
 *     https://github.com/CNES/Pandora2D
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
This module contains eigen types for cpp.
*/

#ifndef COMMON_EIGEN_TYPE_HPP
#define COMMON_EIGEN_TYPE_HPP

#include <Eigen/Dense>

namespace P2d {

/**
 * @brief type used for double matrix
 *
 */
using MatrixD = Eigen::MatrixXd;

/**
 * @brief type used for float matrix
 *
 */
using Matrixf = Eigen::MatrixXf;

/**
 * @brief type used for unsigned int matrix
 */
using MatrixUI = Eigen::Matrix<uint8_t, Eigen::Dynamic, Eigen::Dynamic>;

/**
 * @brief type used for template matrix
 *
 * @tparam T
 */
template <typename T>
using MatrixX = Eigen::Matrix<T, Eigen::Dynamic, Eigen::Dynamic>;

/**
 * @brief type used for double vectors
 *
 */
using VectorD = Eigen::VectorXd;

/**
 * @brief type used for float vectors
 *
 */
using Vectorf = Eigen::VectorXf;

/**
 * @brief type used for template vector (column vector)
 *
 * @tparam T
 */
template <typename T>
using VectorX = Eigen::Matrix<T, Eigen::Dynamic, 1>;

/**
 * @brief type used for double arrays
 *
 */
using ArrayD = Eigen::ArrayXd;
}  // namespace P2d

#endif