# Release 0.8.9

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and SageWorks. So please contact us at [sageworks@supercowpowers.com](mailto:sageworks@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The SageWorks framework continues to 'flex' to support different real world use cases when operating a set of production machine learning pipelines.

### General
The AWSAccountClamp had too many responsibilities so that classes has been split up into two classes and a set of utilities:

- AWSAccountClamp
- AWSSession
- utils/execution_environment.py

### API Changes
- **Column Names**

	```
	data_source.column_names()
	feature_set.column_names()
	```
	is replaced with
	
	```
	data_source.columns
	feature_set.columns
   ```

- **Display/Training Views**

	```
	data_source.get_display_view()
	feature_set.get_display_view()
	feature_set.get_training_view()
	```
	is replaced with
	
	```
	data_source.view("display")
	feature_set.view("display")
	feature_set.view("training")
   ```

- **AWSAccountClamp**

	```
	AWSAccountClamp().boto_session()
	```
	is replaced with
	
	```
	AWSAccountClamp().boto3_session
   ```
- **All Classes**

    If the class previously had a `boto_session` attribute that has been renamed to `boto3_session`
      
### Questions?
<img align="right" src="../../images/scp.png" width="180">

The SuperCowPowers team is happy to anser any questions you may have about AWS and SageWorks. Please contact us at [sageworks@supercowpowers.com](mailto:sageworks@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


