# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AlertDimensions',
    'AlertEvaluationStrategy',
    'CustomDashboardDashboardItem',
    'CustomDashboardDashboardItemDataSource',
    'CustomDashboardDashboardItemDataSourceConfig',
    'CustomDashboardDashboardItemVisualization',
    'CustomDashboardDashboardItemVisualizationConfig',
    'ServiceACLEntriesEntry',
    'ServiceComputeBackend',
    'ServiceComputeDictionary',
    'ServiceComputeDomain',
    'ServiceComputeImageOptimizerDefaultSettings',
    'ServiceComputeLoggingBigquery',
    'ServiceComputeLoggingBlobstorage',
    'ServiceComputeLoggingCloudfile',
    'ServiceComputeLoggingDatadog',
    'ServiceComputeLoggingDigitalocean',
    'ServiceComputeLoggingElasticsearch',
    'ServiceComputeLoggingFtp',
    'ServiceComputeLoggingGc',
    'ServiceComputeLoggingGooglepubsub',
    'ServiceComputeLoggingGrafanacloudlog',
    'ServiceComputeLoggingHeroku',
    'ServiceComputeLoggingHoneycomb',
    'ServiceComputeLoggingHttp',
    'ServiceComputeLoggingKafka',
    'ServiceComputeLoggingKinese',
    'ServiceComputeLoggingLogentry',
    'ServiceComputeLoggingLoggly',
    'ServiceComputeLoggingLogshuttle',
    'ServiceComputeLoggingNewrelic',
    'ServiceComputeLoggingOpenstack',
    'ServiceComputeLoggingPapertrail',
    'ServiceComputeLoggingS3',
    'ServiceComputeLoggingScalyr',
    'ServiceComputeLoggingSftp',
    'ServiceComputeLoggingSplunk',
    'ServiceComputeLoggingSumologic',
    'ServiceComputeLoggingSyslog',
    'ServiceComputePackage',
    'ServiceComputeProductEnablement',
    'ServiceComputeProductEnablementDdosProtection',
    'ServiceComputeProductEnablementNgwaf',
    'ServiceComputeResourceLink',
    'ServiceVclAcl',
    'ServiceVclBackend',
    'ServiceVclCacheSetting',
    'ServiceVclCondition',
    'ServiceVclDictionary',
    'ServiceVclDirector',
    'ServiceVclDomain',
    'ServiceVclDynamicsnippet',
    'ServiceVclGzip',
    'ServiceVclHeader',
    'ServiceVclHealthcheck',
    'ServiceVclImageOptimizerDefaultSettings',
    'ServiceVclLoggingBigquery',
    'ServiceVclLoggingBlobstorage',
    'ServiceVclLoggingCloudfile',
    'ServiceVclLoggingDatadog',
    'ServiceVclLoggingDigitalocean',
    'ServiceVclLoggingElasticsearch',
    'ServiceVclLoggingFtp',
    'ServiceVclLoggingGc',
    'ServiceVclLoggingGooglepubsub',
    'ServiceVclLoggingGrafanacloudlog',
    'ServiceVclLoggingHerokus',
    'ServiceVclLoggingHoneycomb',
    'ServiceVclLoggingHttp',
    'ServiceVclLoggingKafka',
    'ServiceVclLoggingKinese',
    'ServiceVclLoggingLogentry',
    'ServiceVclLoggingLoggly',
    'ServiceVclLoggingLogshuttle',
    'ServiceVclLoggingNewrelic',
    'ServiceVclLoggingNewrelicotlp',
    'ServiceVclLoggingOpenstack',
    'ServiceVclLoggingPapertrail',
    'ServiceVclLoggingS3',
    'ServiceVclLoggingScalyr',
    'ServiceVclLoggingSftp',
    'ServiceVclLoggingSplunk',
    'ServiceVclLoggingSumologic',
    'ServiceVclLoggingSyslog',
    'ServiceVclProductEnablement',
    'ServiceVclProductEnablementDdosProtection',
    'ServiceVclProductEnablementNgwaf',
    'ServiceVclRateLimiter',
    'ServiceVclRateLimiterResponse',
    'ServiceVclRequestSetting',
    'ServiceVclResponseObject',
    'ServiceVclSnippet',
    'ServiceVclVcl',
    'TlsSubscriptionManagedDnsChallenge',
    'TlsSubscriptionManagedHttpChallenge',
    'GetConfigstoresStoreResult',
    'GetDatacentersPopResult',
    'GetDictionariesDictionaryResult',
    'GetKvstoresStoreResult',
    'GetSecretstoresStoreResult',
    'GetServicesDetailResult',
    'GetTlsConfigurationDnsRecordResult',
    'GetVclSnippetsVclSnippetResult',
]

@pulumi.output_type
class AlertDimensions(dict):
    def __init__(__self__, *,
                 domains: Optional[Sequence[builtins.str]] = None,
                 origins: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] domains: Names of a subset of domains that the alert monitors.
        :param Sequence[builtins.str] origins: Addresses of a subset of backends that the alert monitors.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[builtins.str]]:
        """
        Names of a subset of domains that the alert monitors.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Addresses of a subset of backends that the alert monitors.
        """
        return pulumi.get(self, "origins")


@pulumi.output_type
class AlertEvaluationStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreBelow":
            suggest = "ignore_below"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertEvaluationStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertEvaluationStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertEvaluationStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period: builtins.str,
                 threshold: builtins.float,
                 type: builtins.str,
                 ignore_below: Optional[builtins.float] = None):
        """
        :param builtins.str period: The length of time to evaluate whether the conditions have been met. The data is polled every minute. One of: `2m`, `3m`, `5m`, `15m`, `30m`.
        :param builtins.float threshold: Threshold used to alert.
        :param builtins.str type: Type of strategy to use to evaluate. One of: `above_threshold`, `all_above_threshold`, `below_threshold`, `percent_absolute`, `percent_decrease`, `percent_increase`.
        :param builtins.float ignore_below: Threshold for the denominator value used in evaluations that calculate a rate or ratio. Usually used to filter out noise.
        """
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "type", type)
        if ignore_below is not None:
            pulumi.set(__self__, "ignore_below", ignore_below)

    @property
    @pulumi.getter
    def period(self) -> builtins.str:
        """
        The length of time to evaluate whether the conditions have been met. The data is polled every minute. One of: `2m`, `3m`, `5m`, `15m`, `30m`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        Threshold used to alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of strategy to use to evaluate. One of: `above_threshold`, `all_above_threshold`, `below_threshold`, `percent_absolute`, `percent_decrease`, `percent_increase`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="ignoreBelow")
    def ignore_below(self) -> Optional[builtins.float]:
        """
        Threshold for the denominator value used in evaluations that calculate a rate or ratio. Usually used to filter out noise.
        """
        return pulumi.get(self, "ignore_below")


@pulumi.output_type
class CustomDashboardDashboardItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDashboardDashboardItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDashboardDashboardItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDashboardDashboardItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: 'outputs.CustomDashboardDashboardItemDataSource',
                 id: builtins.str,
                 subtitle: builtins.str,
                 title: builtins.str,
                 visualization: 'outputs.CustomDashboardDashboardItemVisualization',
                 span: Optional[builtins.int] = None):
        """
        :param 'CustomDashboardDashboardItemDataSourceArgs' data_source: An object which describes the data to display.
        :param builtins.str id: Dashboard item identifier (alphanumeric). Must be unique, relative to other items in the same dashboard.
        :param builtins.str subtitle: A human-readable subtitle for the dashboard item. Often a description of the visualization.
        :param builtins.str title: A human-readable title for the dashboard item.
        :param 'CustomDashboardDashboardItemVisualizationArgs' visualization: An object which describes the data visualization to display.
        :param builtins.int span: The number of columns for the dashboard item to span. Dashboards are rendered on a 12-column grid on "desktop" screen sizes.
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "visualization", visualization)
        if span is not None:
            pulumi.set(__self__, "span", span)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> 'outputs.CustomDashboardDashboardItemDataSource':
        """
        An object which describes the data to display.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Dashboard item identifier (alphanumeric). Must be unique, relative to other items in the same dashboard.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subtitle(self) -> builtins.str:
        """
        A human-readable subtitle for the dashboard item. Often a description of the visualization.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A human-readable title for the dashboard item.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def visualization(self) -> 'outputs.CustomDashboardDashboardItemVisualization':
        """
        An object which describes the data visualization to display.
        """
        return pulumi.get(self, "visualization")

    @property
    @pulumi.getter
    def span(self) -> Optional[builtins.int]:
        """
        The number of columns for the dashboard item to span. Dashboards are rendered on a 12-column grid on "desktop" screen sizes.
        """
        return pulumi.get(self, "span")


@pulumi.output_type
class CustomDashboardDashboardItemDataSource(dict):
    def __init__(__self__, *,
                 config: 'outputs.CustomDashboardDashboardItemDataSourceConfig',
                 type: builtins.str):
        """
        :param 'CustomDashboardDashboardItemDataSourceConfigArgs' config: Configuration options for the selected data source.
        :param builtins.str type: The source of the data to display. One of: `stats.edge`, `stats.domain`, `stats.origin`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.CustomDashboardDashboardItemDataSourceConfig':
        """
        Configuration options for the selected data source.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The source of the data to display. One of: `stats.edge`, `stats.domain`, `stats.origin`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomDashboardDashboardItemDataSourceConfig(dict):
    def __init__(__self__, *,
                 metrics: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] metrics: The metrics to visualize. Valid options are defined by the selected data source: [stats.edge](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/edge/), [stats.domain](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/domain/), [stats.origin](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/origin/).
        """
        pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def metrics(self) -> Sequence[builtins.str]:
        """
        The metrics to visualize. Valid options are defined by the selected data source: [stats.edge](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/edge/), [stats.domain](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/domain/), [stats.origin](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/origin/).
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class CustomDashboardDashboardItemVisualization(dict):
    def __init__(__self__, *,
                 config: 'outputs.CustomDashboardDashboardItemVisualizationConfig',
                 type: builtins.str):
        """
        :param 'CustomDashboardDashboardItemVisualizationConfigArgs' config: Configuration options for the selected data source.
        :param builtins.str type: The type of visualization to display. One of: `chart`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.CustomDashboardDashboardItemVisualizationConfig':
        """
        Configuration options for the selected data source.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of visualization to display. One of: `chart`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomDashboardDashboardItemVisualizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "plotType":
            suggest = "plot_type"
        elif key == "calculationMethod":
            suggest = "calculation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDashboardDashboardItemVisualizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDashboardDashboardItemVisualizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDashboardDashboardItemVisualizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plot_type: builtins.str,
                 calculation_method: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None):
        """
        :param builtins.str plot_type: The type of chart to display. One of: `line`, `bar`, `single-metric`, `donut`.
        :param builtins.str calculation_method: The aggregation function to apply to the dataset. One of: `avg`, `sum`, `min`, `max`, `latest`, `p95`.
        :param builtins.str format: The units to use to format the data. One of: `number`, `bytes`, `percent`, `requests`, `responses`, `seconds`, `milliseconds`, `ratio`, `bitrate`.
        """
        pulumi.set(__self__, "plot_type", plot_type)
        if calculation_method is not None:
            pulumi.set(__self__, "calculation_method", calculation_method)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> builtins.str:
        """
        The type of chart to display. One of: `line`, `bar`, `single-metric`, `donut`.
        """
        return pulumi.get(self, "plot_type")

    @property
    @pulumi.getter(name="calculationMethod")
    def calculation_method(self) -> Optional[builtins.str]:
        """
        The aggregation function to apply to the dataset. One of: `avg`, `sum`, `min`, `max`, `latest`, `p95`.
        """
        return pulumi.get(self, "calculation_method")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        The units to use to format the data. One of: `number`, `bytes`, `percent`, `requests`, `responses`, `seconds`, `milliseconds`, `ratio`, `bitrate`.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class ServiceACLEntriesEntry(dict):
    def __init__(__self__, *,
                 ip: builtins.str,
                 comment: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 negated: Optional[builtins.bool] = None,
                 subnet: Optional[builtins.str] = None):
        """
        :param builtins.str ip: An IP address that is the focus for the ACL
        :param builtins.str comment: A personal freeform descriptive note
        :param builtins.str id: The unique ID of the entry
        :param builtins.bool negated: A boolean that will negate the match if true
        :param builtins.str subnet: An optional subnet mask applied to the IP address
        """
        pulumi.set(__self__, "ip", ip)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        An IP address that is the focus for the ACL
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        A personal freeform descriptive note
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique ID of the entry
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def negated(self) -> Optional[builtins.bool]:
        """
        A boolean that will negate the match if true
        """
        return pulumi.get(self, "negated")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[builtins.str]:
        """
        An optional subnet mask applied to the IP address
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ServiceComputeBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "keepaliveTime":
            suggest = "keepalive_time"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "shareKey":
            suggest = "share_key"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 between_bytes_timeout: Optional[builtins.int] = None,
                 connect_timeout: Optional[builtins.int] = None,
                 error_threshold: Optional[builtins.int] = None,
                 first_byte_timeout: Optional[builtins.int] = None,
                 healthcheck: Optional[builtins.str] = None,
                 keepalive_time: Optional[builtins.int] = None,
                 max_conn: Optional[builtins.int] = None,
                 max_tls_version: Optional[builtins.str] = None,
                 min_tls_version: Optional[builtins.str] = None,
                 override_host: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 share_key: Optional[builtins.str] = None,
                 shield: Optional[builtins.str] = None,
                 ssl_ca_cert: Optional[builtins.str] = None,
                 ssl_cert_hostname: Optional[builtins.str] = None,
                 ssl_check_cert: Optional[builtins.bool] = None,
                 ssl_ciphers: Optional[builtins.str] = None,
                 ssl_client_cert: Optional[builtins.str] = None,
                 ssl_client_key: Optional[builtins.str] = None,
                 ssl_sni_hostname: Optional[builtins.str] = None,
                 use_ssl: Optional[builtins.bool] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str address: An IPv4, hostname, or IPv6 address for the Backend
        :param builtins.str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param builtins.int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param builtins.int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param builtins.int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param builtins.str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param builtins.int keepalive_time: How long in seconds to keep a persistent connection to the backend between requests.
        :param builtins.int max_conn: Maximum number of connections for this Backend. Default `200`
        :param builtins.str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param builtins.str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param builtins.str override_host: The hostname to override the Host header
        :param builtins.int port: The port number on which the Backend responds. Default `80`
        :param builtins.str share_key: Value that when shared across backends will enable those backends to share the same health check.
        :param builtins.str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param builtins.str ssl_ca_cert: CA certificate attached to origin.
        :param builtins.str ssl_cert_hostname: Configure certificate validation. Does not affect SNI at all
        :param builtins.bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param builtins.str ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param builtins.str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param builtins.str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param builtins.str ssl_sni_hostname: Configure SNI in the TLS handshake. Does not affect cert validation at all
        :param builtins.bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param builtins.int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if keepalive_time is not None:
            pulumi.set(__self__, "keepalive_time", keepalive_time)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if share_key is not None:
            pulumi.set(__self__, "share_key", share_key)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[builtins.int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[builtins.int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[builtins.int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[builtins.int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[builtins.str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="keepaliveTime")
    def keepalive_time(self) -> Optional[builtins.int]:
        """
        How long in seconds to keep a persistent connection to the backend between requests.
        """
        return pulumi.get(self, "keepalive_time")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[builtins.int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[builtins.str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[builtins.str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[builtins.str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="shareKey")
    def share_key(self) -> Optional[builtins.str]:
        """
        Value that when shared across backends will enable those backends to share the same health check.
        """
        return pulumi.get(self, "share_key")

    @property
    @pulumi.getter
    def shield(self) -> Optional[builtins.str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[builtins.str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[builtins.str]:
        """
        Configure certificate validation. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[builtins.bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[builtins.str]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[builtins.str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[builtins.str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[builtins.str]:
        """
        Configure SNI in the TLS handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[builtins.bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceComputeDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 dictionary_id: Optional[builtins.str] = None,
                 force_destroy: Optional[builtins.bool] = None,
                 write_only: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param builtins.str dictionary_id: The ID of the dictionary
        :param builtins.bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[builtins.str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[builtins.bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceComputeDomain(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 comment: Optional[builtins.str] = None):
        """
        :param builtins.str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param builtins.str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceComputeImageOptimizerDefaultSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowVideo":
            suggest = "allow_video"
        elif key == "jpegQuality":
            suggest = "jpeg_quality"
        elif key == "jpegType":
            suggest = "jpeg_type"
        elif key == "resizeFilter":
            suggest = "resize_filter"
        elif key == "webpQuality":
            suggest = "webp_quality"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeImageOptimizerDefaultSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeImageOptimizerDefaultSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeImageOptimizerDefaultSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_video: Optional[builtins.bool] = None,
                 jpeg_quality: Optional[builtins.int] = None,
                 jpeg_type: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 resize_filter: Optional[builtins.str] = None,
                 upscale: Optional[builtins.bool] = None,
                 webp: Optional[builtins.bool] = None,
                 webp_quality: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_video: Enables GIF to MP4 transformations on this service.
        :param builtins.int jpeg_quality: The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        :param builtins.str jpeg_type: The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
               	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
               	- baseline: Output baseline JPEG images
               	- progressive: Output progressive JPEG images
        :param builtins.str name: Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        :param builtins.str resize_filter: The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
               	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
               	- lanczos2: A Lanczos filter with a kernel size of 2.
               	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
               	- bilinear: A filter using an average of a 2x2 environment of pixels.
               	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        :param builtins.bool upscale: Whether or not we should allow output images to render at sizes larger than input.
        :param builtins.bool webp: Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        :param builtins.int webp_quality: The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        if allow_video is not None:
            pulumi.set(__self__, "allow_video", allow_video)
        if jpeg_quality is not None:
            pulumi.set(__self__, "jpeg_quality", jpeg_quality)
        if jpeg_type is not None:
            pulumi.set(__self__, "jpeg_type", jpeg_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resize_filter is not None:
            pulumi.set(__self__, "resize_filter", resize_filter)
        if upscale is not None:
            pulumi.set(__self__, "upscale", upscale)
        if webp is not None:
            pulumi.set(__self__, "webp", webp)
        if webp_quality is not None:
            pulumi.set(__self__, "webp_quality", webp_quality)

    @property
    @pulumi.getter(name="allowVideo")
    def allow_video(self) -> Optional[builtins.bool]:
        """
        Enables GIF to MP4 transformations on this service.
        """
        return pulumi.get(self, "allow_video")

    @property
    @pulumi.getter(name="jpegQuality")
    def jpeg_quality(self) -> Optional[builtins.int]:
        """
        The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "jpeg_quality")

    @property
    @pulumi.getter(name="jpegType")
    def jpeg_type(self) -> Optional[builtins.str]:
        """
        The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
        	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
        	- baseline: Output baseline JPEG images
        	- progressive: Output progressive JPEG images
        """
        return pulumi.get(self, "jpeg_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resizeFilter")
    def resize_filter(self) -> Optional[builtins.str]:
        """
        The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
        	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
        	- lanczos2: A Lanczos filter with a kernel size of 2.
        	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
        	- bilinear: A filter using an average of a 2x2 environment of pixels.
        	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        """
        return pulumi.get(self, "resize_filter")

    @property
    @pulumi.getter
    def upscale(self) -> Optional[builtins.bool]:
        """
        Whether or not we should allow output images to render at sizes larger than input.
        """
        return pulumi.get(self, "upscale")

    @property
    @pulumi.getter
    def webp(self) -> Optional[builtins.bool]:
        """
        Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        """
        return pulumi.get(self, "webp")

    @property
    @pulumi.getter(name="webpQuality")
    def webp_quality(self) -> Optional[builtins.int]:
        """
        The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "webp_quality")


@pulumi.output_type
class ServiceComputeLoggingBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: builtins.str,
                 email: builtins.str,
                 name: builtins.str,
                 project_id: builtins.str,
                 secret_key: builtins.str,
                 table: builtins.str,
                 account_name: Optional[builtins.str] = None,
                 template: Optional[builtins.str] = None):
        """
        :param builtins.str dataset: The ID of your BigQuery dataset
        :param builtins.str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param builtins.str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str project_id: The ID of your GCP project
        :param builtins.str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param builtins.str table: The ID of your BigQuery table
        :param builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param builtins.str template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> builtins.str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> builtins.str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def template(self) -> Optional[builtins.str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceComputeLoggingBlobstorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingBlobstorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingBlobstorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingBlobstorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: builtins.str,
                 container: builtins.str,
                 name: builtins.str,
                 sas_token: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 file_max_bytes: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param builtins.str container: The name of the Azure Blob Storage container in which to store logs
        :param builtins.str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param builtins.int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> builtins.str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> builtins.str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> builtins.str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Your Cloud File account access key
        :param builtins.str bucket_name: The name of your Cloud Files container
        :param builtins.str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str user: The username for your Cloud Files account
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: The path to upload logs to
        :param builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingDatadog(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The API key from your Datadog account
        :param builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 secret_key: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 domain: Optional[builtins.str] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Your DigitalOcean Spaces account access key
        :param builtins.str bucket_name: The name of the DigitalOcean Space
        :param builtins.str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str secret_key: Your DigitalOcean Spaces account secret key
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: The path to upload logs to
        :param builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: builtins.str,
                 name: builtins.str,
                 url: builtins.str,
                 password: Optional[builtins.str] = None,
                 pipeline: Optional[builtins.str] = None,
                 request_max_bytes: Optional[builtins.int] = None,
                 request_max_entries: Optional[builtins.int] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str index: The name of the Elasticsearch index to send documents (logs) to
        :param builtins.str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: The Elasticsearch URL to stream logs to
        :param builtins.str password: BasicAuth password for Elasticsearch
        :param builtins.str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param builtins.int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param builtins.int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param builtins.str user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[builtins.str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[builtins.int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[builtins.int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 password: builtins.str,
                 path: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 port: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str address: The FTP address to stream logs to
        :param builtins.str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str password: The password for the server (for anonymous use an email address)
        :param builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param builtins.str user: The username for the server (can be `anonymous`)
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param builtins.int port: The port number. Default: `21`
        :param builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingGc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 account_name: Optional[builtins.str] = None,
                 compression_codec: Optional[builtins.str] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 project_id: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the bucket in which to store the logs
        :param builtins.str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param builtins.int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param builtins.str project_id: The ID of your Google Cloud Platform project
        :param builtins.str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 project_id: builtins.str,
                 secret_key: builtins.str,
                 topic: builtins.str,
                 user: builtins.str,
                 account_name: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str project_id: The ID of your Google Cloud Platform project
        :param builtins.str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param builtins.str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")


@pulumi.output_type
class ServiceComputeLoggingGrafanacloudlog(dict):
    def __init__(__self__, *,
                 index: builtins.str,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str,
                 user: builtins.str):
        """
        :param builtins.str index: The stream identifier as a JSON string
        :param builtins.str name: The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Access Policy Token key for your GrafanaCloudLogs account
        :param builtins.str url: The URL to stream logs to
        :param builtins.str user: The Grafana User ID
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        The stream identifier as a JSON string
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Access Policy Token key for your GrafanaCloudLogs account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The Grafana User ID
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingHeroku(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param builtins.str url: The URL to stream logs to
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceComputeLoggingHoneycomb(dict):
    def __init__(__self__, *,
                 dataset: builtins.str,
                 name: builtins.str,
                 token: builtins.str):
        """
        :param builtins.str dataset: The Honeycomb Dataset you want to log to
        :param builtins.str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Write Key from the Account page of your Honeycomb account
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def dataset(self) -> builtins.str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 url: builtins.str,
                 content_type: Optional[builtins.str] = None,
                 header_name: Optional[builtins.str] = None,
                 header_value: Optional[builtins.str] = None,
                 json_format: Optional[builtins.str] = None,
                 message_type: Optional[builtins.str] = None,
                 method: Optional[builtins.str] = None,
                 request_max_bytes: Optional[builtins.int] = None,
                 request_max_entries: Optional[builtins.int] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: URL that log data will be sent to. Must use the https protocol
        :param builtins.str content_type: Value of the `Content-Type` header sent with the request
        :param builtins.str header_name: Custom header sent with the request
        :param builtins.str header_value: Value of the custom header sent with the request
        :param builtins.str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param builtins.int request_max_bytes: The maximum number of bytes sent in one request
        :param builtins.int request_max_entries: The maximum number of logs sent in one request
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[builtins.str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[builtins.str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[builtins.str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[builtins.str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[builtins.int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[builtins.int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceComputeLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: builtins.str,
                 name: builtins.str,
                 topic: builtins.str,
                 auth_method: Optional[builtins.str] = None,
                 compression_codec: Optional[builtins.str] = None,
                 parse_log_keyvals: Optional[builtins.bool] = None,
                 password: Optional[builtins.str] = None,
                 request_max_bytes: Optional[builtins.int] = None,
                 required_acks: Optional[builtins.str] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param builtins.str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str topic: The Kafka topic to send logs to
        :param builtins.str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param builtins.str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param builtins.bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param builtins.str password: SASL Pass
        :param builtins.int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param builtins.str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param builtins.bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param builtins.str user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def brokers(self) -> builtins.str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[builtins.str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[builtins.bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[builtins.int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[builtins.str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 topic: builtins.str,
                 access_key: Optional[builtins.str] = None,
                 iam_role: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str topic: The Kinesis stream name
        :param builtins.str access_key: The AWS access key to be used to write to the stream
        :param builtins.str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param builtins.str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param builtins.str secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[builtins.str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceComputeLoggingLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 port: Optional[builtins.int] = None,
                 use_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param builtins.int port: The port number configured in Logentries
        :param builtins.bool use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingLoggly(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str):
        """
        :param builtins.str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingLogshuttle(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The data authentication token associated with this endpoint
        :param builtins.str url: Your Log Shuttle endpoint URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceComputeLoggingNewrelic(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Insert API key from the Account page of your New Relic account
        :param builtins.str region: The region that log data will be sent to. Default: `US`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 url: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Your OpenStack account access key
        :param builtins.str bucket_name: The name of your OpenStack container
        :param builtins.str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: Your OpenStack auth url
        :param builtins.str user: The username for your OpenStack account
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingPapertrail(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: The address of the Papertrail endpoint
        :param builtins.str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.int port: The port associated with the address where the Papertrail endpoint can be accessed
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceComputeLoggingS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 acl: Optional[builtins.str] = None,
                 compression_codec: Optional[builtins.str] = None,
                 domain: Optional[builtins.str] = None,
                 file_max_bytes: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 redundancy: Optional[builtins.str] = None,
                 s3_access_key: Optional[builtins.str] = None,
                 s3_iam_role: Optional[builtins.str] = None,
                 s3_secret_key: Optional[builtins.str] = None,
                 server_side_encryption: Optional[builtins.str] = None,
                 server_side_encryption_kms_key_id: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the bucket in which to store the logs
        :param builtins.str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        :param builtins.str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param builtins.str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param builtins.str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param builtins.str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param builtins.str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def acl(self) -> Optional[builtins.str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[builtins.str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[builtins.str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[builtins.str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[builtins.str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[builtins.str]:
        """
        Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingScalyr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingScalyr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingScalyr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingScalyr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 project_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param builtins.str project_id: The name of the logfile field sent to Scalyr
        :param builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The name of the logfile field sent to Scalyr
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 path: builtins.str,
                 ssh_known_hosts: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 password: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 port: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str address: The SFTP address to stream logs to
        :param builtins.str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param builtins.str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param builtins.str user: The username for the server
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param builtins.int port: The port the SFTP service listens on. (Default: `22`)
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> builtins.str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Splunk token to be used for authentication
        :param builtins.str url: The Splunk URL to stream logs to
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param builtins.bool use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 url: builtins.str,
                 message_type: Optional[builtins.str] = None):
        """
        :param builtins.str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: The URL to Sumologic collector endpoint
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")


@pulumi.output_type
class ServiceComputeLoggingSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 message_type: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 token: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str address: A hostname or IPv4 address of the Syslog endpoint
        :param builtins.str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        :param builtins.str token: Whether to prepend each message with a specific token
        :param builtins.bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[builtins.str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputePackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceCodeHash":
            suggest = "source_code_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputePackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[builtins.str] = None,
                 filename: Optional[builtins.str] = None,
                 source_code_hash: Optional[builtins.str] = None):
        """
        :param builtins.str content: The contents of the Wasm deployment package as a base64 encoded string (e.g. could be provided using an input variable or via external data source output variable). Conflicts with `filename`. Exactly one of these two arguments must be specified
        :param builtins.str filename: The path to the Wasm deployment package within your local filesystem. Conflicts with `content`. Exactly one of these two arguments must be specified
        :param builtins.str source_code_hash: Used to trigger updates. Must be set to a SHA512 hash of all files (in sorted order) within the package. The usual way to set this is using the get_package_hash data source.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        The contents of the Wasm deployment package as a base64 encoded string (e.g. could be provided using an input variable or via external data source output variable). Conflicts with `filename`. Exactly one of these two arguments must be specified
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def filename(self) -> Optional[builtins.str]:
        """
        The path to the Wasm deployment package within your local filesystem. Conflicts with `content`. Exactly one of these two arguments must be specified
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[builtins.str]:
        """
        Used to trigger updates. Must be set to a SHA512 hash of all files (in sorted order) within the package. The usual way to set this is using the get_package_hash data source.
        """
        return pulumi.get(self, "source_code_hash")


@pulumi.output_type
class ServiceComputeProductEnablement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ddosProtection":
            suggest = "ddos_protection"
        elif key == "logExplorerInsights":
            suggest = "log_explorer_insights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeProductEnablement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeProductEnablement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeProductEnablement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ddos_protection: Optional['outputs.ServiceComputeProductEnablementDdosProtection'] = None,
                 fanout: Optional[builtins.bool] = None,
                 log_explorer_insights: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 ngwaf: Optional['outputs.ServiceComputeProductEnablementNgwaf'] = None,
                 websockets: Optional[builtins.bool] = None):
        """
        :param 'ServiceComputeProductEnablementDdosProtectionArgs' ddos_protection: DDoS Protection product
        :param builtins.bool fanout: Enable Fanout support
        :param builtins.bool log_explorer_insights: Enable Log Explorer & Insights
        :param builtins.str name: Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        :param 'ServiceComputeProductEnablementNgwafArgs' ngwaf: Next-Gen WAF product
        :param builtins.bool websockets: Enable WebSockets support
        """
        if ddos_protection is not None:
            pulumi.set(__self__, "ddos_protection", ddos_protection)
        if fanout is not None:
            pulumi.set(__self__, "fanout", fanout)
        if log_explorer_insights is not None:
            pulumi.set(__self__, "log_explorer_insights", log_explorer_insights)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngwaf is not None:
            pulumi.set(__self__, "ngwaf", ngwaf)
        if websockets is not None:
            pulumi.set(__self__, "websockets", websockets)

    @property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> Optional['outputs.ServiceComputeProductEnablementDdosProtection']:
        """
        DDoS Protection product
        """
        return pulumi.get(self, "ddos_protection")

    @property
    @pulumi.getter
    def fanout(self) -> Optional[builtins.bool]:
        """
        Enable Fanout support
        """
        return pulumi.get(self, "fanout")

    @property
    @pulumi.getter(name="logExplorerInsights")
    def log_explorer_insights(self) -> Optional[builtins.bool]:
        """
        Enable Log Explorer & Insights
        """
        return pulumi.get(self, "log_explorer_insights")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ngwaf(self) -> Optional['outputs.ServiceComputeProductEnablementNgwaf']:
        """
        Next-Gen WAF product
        """
        return pulumi.get(self, "ngwaf")

    @property
    @pulumi.getter
    def websockets(self) -> Optional[builtins.bool]:
        """
        Enable WebSockets support
        """
        return pulumi.get(self, "websockets")


@pulumi.output_type
class ServiceComputeProductEnablementDdosProtection(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 mode: builtins.str):
        """
        :param builtins.bool enabled: Enable DDoS Protection support
        :param builtins.str mode: Operation mode
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enable DDoS Protection support
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Operation mode
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ServiceComputeProductEnablementNgwaf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "trafficRamp":
            suggest = "traffic_ramp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeProductEnablementNgwaf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeProductEnablementNgwaf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeProductEnablementNgwaf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 workspace_id: builtins.str,
                 traffic_ramp: Optional[builtins.int] = None):
        """
        :param builtins.bool enabled: Enable Next-Gen WAF support
        :param builtins.str workspace_id: The workspace to link
        :param builtins.int traffic_ramp: The percentage of traffic to inspect
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if traffic_ramp is not None:
            pulumi.set(__self__, "traffic_ramp", traffic_ramp)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enable Next-Gen WAF support
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> builtins.str:
        """
        The workspace to link
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter(name="trafficRamp")
    def traffic_ramp(self) -> Optional[builtins.int]:
        """
        The percentage of traffic to inspect
        """
        return pulumi.get(self, "traffic_ramp")


@pulumi.output_type
class ServiceComputeResourceLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "linkId":
            suggest = "link_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeResourceLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeResourceLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeResourceLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 resource_id: builtins.str,
                 link_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the resource link.
        :param builtins.str resource_id: The ID of the underlying linked resource.
        :param builtins.str link_id: An alphanumeric string identifying the resource link.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the resource link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The ID of the underlying linked resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[builtins.str]:
        """
        An alphanumeric string identifying the resource link.
        """
        return pulumi.get(self, "link_id")


@pulumi.output_type
class ServiceVclAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclId":
            suggest = "acl_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 acl_id: Optional[builtins.str] = None,
                 force_destroy: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        :param builtins.str acl_id: The ID of the ACL
        :param builtins.bool force_destroy: Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[builtins.str]:
        """
        The ID of the ACL
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[builtins.bool]:
        """
        Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")


@pulumi.output_type
class ServiceVclBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoLoadbalance":
            suggest = "auto_loadbalance"
        elif key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "keepaliveTime":
            suggest = "keepalive_time"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "shareKey":
            suggest = "share_key"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 auto_loadbalance: Optional[builtins.bool] = None,
                 between_bytes_timeout: Optional[builtins.int] = None,
                 connect_timeout: Optional[builtins.int] = None,
                 error_threshold: Optional[builtins.int] = None,
                 first_byte_timeout: Optional[builtins.int] = None,
                 healthcheck: Optional[builtins.str] = None,
                 keepalive_time: Optional[builtins.int] = None,
                 max_conn: Optional[builtins.int] = None,
                 max_tls_version: Optional[builtins.str] = None,
                 min_tls_version: Optional[builtins.str] = None,
                 override_host: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 request_condition: Optional[builtins.str] = None,
                 share_key: Optional[builtins.str] = None,
                 shield: Optional[builtins.str] = None,
                 ssl_ca_cert: Optional[builtins.str] = None,
                 ssl_cert_hostname: Optional[builtins.str] = None,
                 ssl_check_cert: Optional[builtins.bool] = None,
                 ssl_ciphers: Optional[builtins.str] = None,
                 ssl_client_cert: Optional[builtins.str] = None,
                 ssl_client_key: Optional[builtins.str] = None,
                 ssl_sni_hostname: Optional[builtins.str] = None,
                 use_ssl: Optional[builtins.bool] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str address: An IPv4, hostname, or IPv6 address for the Backend
        :param builtins.str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.bool auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        :param builtins.int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param builtins.int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param builtins.int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param builtins.int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param builtins.str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param builtins.int keepalive_time: How long in seconds to keep a persistent connection to the backend between requests.
        :param builtins.int max_conn: Maximum number of connections for this Backend. Default `200`
        :param builtins.str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param builtins.str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param builtins.str override_host: The hostname to override the Host header
        :param builtins.int port: The port number on which the Backend responds. Default `80`
        :param builtins.str request_condition: Name of a condition, which if met, will select this backend during a request.
        :param builtins.str share_key: Value that when shared across backends will enable those backends to share the same health check.
        :param builtins.str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param builtins.str ssl_ca_cert: CA certificate attached to origin.
        :param builtins.str ssl_cert_hostname: Configure certificate validation. Does not affect SNI at all
        :param builtins.bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param builtins.str ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param builtins.str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param builtins.str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param builtins.str ssl_sni_hostname: Configure SNI in the TLS handshake. Does not affect cert validation at all
        :param builtins.bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param builtins.int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if keepalive_time is not None:
            pulumi.set(__self__, "keepalive_time", keepalive_time)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if share_key is not None:
            pulumi.set(__self__, "share_key", share_key)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[builtins.bool]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        """
        return pulumi.get(self, "auto_loadbalance")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[builtins.int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[builtins.int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[builtins.int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[builtins.int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[builtins.str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="keepaliveTime")
    def keepalive_time(self) -> Optional[builtins.int]:
        """
        How long in seconds to keep a persistent connection to the backend between requests.
        """
        return pulumi.get(self, "keepalive_time")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[builtins.int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[builtins.str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[builtins.str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[builtins.str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[builtins.str]:
        """
        Name of a condition, which if met, will select this backend during a request.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="shareKey")
    def share_key(self) -> Optional[builtins.str]:
        """
        Value that when shared across backends will enable those backends to share the same health check.
        """
        return pulumi.get(self, "share_key")

    @property
    @pulumi.getter
    def shield(self) -> Optional[builtins.str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[builtins.str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[builtins.str]:
        """
        Configure certificate validation. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[builtins.bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[builtins.str]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[builtins.str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[builtins.str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[builtins.str]:
        """
        Configure SNI in the TLS handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[builtins.bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceVclCacheSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "staleTtl":
            suggest = "stale_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclCacheSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclCacheSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclCacheSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 action: Optional[builtins.str] = None,
                 cache_condition: Optional[builtins.str] = None,
                 stale_ttl: Optional[builtins.int] = None,
                 ttl: Optional[builtins.int] = None):
        """
        :param builtins.str name: Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str action: One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        :param builtins.str cache_condition: Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        :param builtins.int stale_ttl: Max "Time To Live" for stale (unreachable) objects
        :param builtins.int ttl: The Time-To-Live (TTL) for the object
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if stale_ttl is not None:
            pulumi.set(__self__, "stale_ttl", stale_ttl)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="staleTtl")
    def stale_ttl(self) -> Optional[builtins.int]:
        """
        Max "Time To Live" for stale (unreachable) objects
        """
        return pulumi.get(self, "stale_ttl")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.int]:
        """
        The Time-To-Live (TTL) for the object
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ServiceVclCondition(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statement: builtins.str,
                 type: builtins.str,
                 priority: Optional[builtins.int] = None):
        """
        :param builtins.str name: The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str statement: The statement used to determine if the condition is met
        :param builtins.str type: Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        :param builtins.int priority: A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statement(self) -> builtins.str:
        """
        The statement used to determine if the condition is met
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ServiceVclDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 dictionary_id: Optional[builtins.str] = None,
                 force_destroy: Optional[builtins.bool] = None,
                 write_only: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param builtins.str dictionary_id: The ID of the dictionary
        :param builtins.bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[builtins.str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[builtins.bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceVclDirector(dict):
    def __init__(__self__, *,
                 backends: Sequence[builtins.str],
                 name: builtins.str,
                 comment: Optional[builtins.str] = None,
                 quorum: Optional[builtins.int] = None,
                 retries: Optional[builtins.int] = None,
                 shield: Optional[builtins.str] = None,
                 type: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param builtins.str name: Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str comment: An optional comment about the Director
        :param builtins.int quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        :param builtins.int retries: How many backends to search if it fails. Default `5`
        :param builtins.str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        :param builtins.int type: Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if quorum is not None:
            pulumi.set(__self__, "quorum", quorum)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def backends(self) -> Sequence[builtins.str]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        An optional comment about the Director
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def quorum(self) -> Optional[builtins.int]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        """
        return pulumi.get(self, "quorum")

    @property
    @pulumi.getter
    def retries(self) -> Optional[builtins.int]:
        """
        How many backends to search if it fails. Default `5`
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def shield(self) -> Optional[builtins.str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.int]:
        """
        Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceVclDomain(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 comment: Optional[builtins.str] = None):
        """
        :param builtins.str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param builtins.str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceVclDynamicsnippet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snippetId":
            suggest = "snippet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclDynamicsnippet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclDynamicsnippet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclDynamicsnippet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str,
                 content: Optional[builtins.str] = None,
                 priority: Optional[builtins.int] = None,
                 snippet_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param builtins.str content: The VCL code that specifies exactly what the snippet does
        :param builtins.int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        :param builtins.str snippet_id: The ID of the dynamic snippet
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if snippet_id is not None:
            pulumi.set(__self__, "snippet_id", snippet_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[builtins.str]:
        """
        The ID of the dynamic snippet
        """
        return pulumi.get(self, "snippet_id")


@pulumi.output_type
class ServiceVclGzip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentTypes":
            suggest = "content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclGzip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclGzip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclGzip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 cache_condition: Optional[builtins.str] = None,
                 content_types: Optional[Sequence[builtins.str]] = None,
                 extensions: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str cache_condition: Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param Sequence[builtins.str] content_types: The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        :param Sequence[builtins.str] extensions: File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence[builtins.str]]:
        """
        File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        return pulumi.get(self, "extensions")


@pulumi.output_type
class ServiceVclHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "ignoreIfSet":
            suggest = "ignore_if_set"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 destination: builtins.str,
                 name: builtins.str,
                 type: builtins.str,
                 cache_condition: Optional[builtins.str] = None,
                 ignore_if_set: Optional[builtins.bool] = None,
                 priority: Optional[builtins.int] = None,
                 regex: Optional[builtins.str] = None,
                 request_condition: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None,
                 substitution: Optional[builtins.str] = None):
        """
        :param builtins.str action: The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        :param builtins.str destination: The name of the header that is going to be affected by the Action
        :param builtins.str name: Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str type: The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        :param builtins.str cache_condition: Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        :param builtins.bool ignore_if_set: Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        :param builtins.int priority: Lower priorities execute first. Default: `100`
        :param builtins.str regex: Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        :param builtins.str request_condition: Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        :param builtins.str response_condition: Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param builtins.str source: Variable to be used as a source for the header content (Does not apply to `delete` action.)
        :param builtins.str substitution: Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if ignore_if_set is not None:
            pulumi.set(__self__, "ignore_if_set", ignore_if_set)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitution is not None:
            pulumi.set(__self__, "substitution", substitution)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        The name of the header that is going to be affected by the Action
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="ignoreIfSet")
    def ignore_if_set(self) -> Optional[builtins.bool]:
        """
        Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        """
        return pulumi.get(self, "ignore_if_set")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        Lower priorities execute first. Default: `100`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.str]:
        """
        Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Variable to be used as a source for the header content (Does not apply to `delete` action.)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def substitution(self) -> Optional[builtins.str]:
        """
        Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        return pulumi.get(self, "substitution")


@pulumi.output_type
class ServiceVclHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "expectedResponse":
            suggest = "expected_response"
        elif key == "httpVersion":
            suggest = "http_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: builtins.str,
                 name: builtins.str,
                 path: builtins.str,
                 check_interval: Optional[builtins.int] = None,
                 expected_response: Optional[builtins.int] = None,
                 headers: Optional[Sequence[builtins.str]] = None,
                 http_version: Optional[builtins.str] = None,
                 initial: Optional[builtins.int] = None,
                 method: Optional[builtins.str] = None,
                 threshold: Optional[builtins.int] = None,
                 timeout: Optional[builtins.int] = None,
                 window: Optional[builtins.int] = None):
        """
        :param builtins.str host: The Host header to send for this Healthcheck
        :param builtins.str name: A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str path: The path to check
        :param builtins.int check_interval: How often to run the Healthcheck in milliseconds. Default `5000`
        :param builtins.int expected_response: The status code expected from the host. Default `200`
        :param Sequence[builtins.str] headers: Custom health check HTTP headers (e.g. if your health check requires an API key to be provided).
        :param builtins.str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        :param builtins.int initial: When loading a config, the initial number of probes to be seen as OK. Default `3`
        :param builtins.str method: Which HTTP method to use. Default `HEAD`
        :param builtins.int threshold: How many Healthchecks must succeed to be considered healthy. Default `3`
        :param builtins.int timeout: Timeout in milliseconds. Default `5000`
        :param builtins.int window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        The Host header to send for this Healthcheck
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The path to check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[builtins.int]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[builtins.int]:
        """
        The status code expected from the host. Default `200`
        """
        return pulumi.get(self, "expected_response")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Custom health check HTTP headers (e.g. if your health check requires an API key to be provided).
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[builtins.str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def initial(self) -> Optional[builtins.int]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `3`
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        Which HTTP method to use. Default `HEAD`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.int]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        Timeout in milliseconds. Default `5000`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def window(self) -> Optional[builtins.int]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ServiceVclImageOptimizerDefaultSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowVideo":
            suggest = "allow_video"
        elif key == "jpegQuality":
            suggest = "jpeg_quality"
        elif key == "jpegType":
            suggest = "jpeg_type"
        elif key == "resizeFilter":
            suggest = "resize_filter"
        elif key == "webpQuality":
            suggest = "webp_quality"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclImageOptimizerDefaultSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclImageOptimizerDefaultSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclImageOptimizerDefaultSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_video: Optional[builtins.bool] = None,
                 jpeg_quality: Optional[builtins.int] = None,
                 jpeg_type: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 resize_filter: Optional[builtins.str] = None,
                 upscale: Optional[builtins.bool] = None,
                 webp: Optional[builtins.bool] = None,
                 webp_quality: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_video: Enables GIF to MP4 transformations on this service.
        :param builtins.int jpeg_quality: The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        :param builtins.str jpeg_type: The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
               	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
               	- baseline: Output baseline JPEG images
               	- progressive: Output progressive JPEG images
        :param builtins.str name: Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        :param builtins.str resize_filter: The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
               	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
               	- lanczos2: A Lanczos filter with a kernel size of 2.
               	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
               	- bilinear: A filter using an average of a 2x2 environment of pixels.
               	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        :param builtins.bool upscale: Whether or not we should allow output images to render at sizes larger than input.
        :param builtins.bool webp: Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        :param builtins.int webp_quality: The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        if allow_video is not None:
            pulumi.set(__self__, "allow_video", allow_video)
        if jpeg_quality is not None:
            pulumi.set(__self__, "jpeg_quality", jpeg_quality)
        if jpeg_type is not None:
            pulumi.set(__self__, "jpeg_type", jpeg_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resize_filter is not None:
            pulumi.set(__self__, "resize_filter", resize_filter)
        if upscale is not None:
            pulumi.set(__self__, "upscale", upscale)
        if webp is not None:
            pulumi.set(__self__, "webp", webp)
        if webp_quality is not None:
            pulumi.set(__self__, "webp_quality", webp_quality)

    @property
    @pulumi.getter(name="allowVideo")
    def allow_video(self) -> Optional[builtins.bool]:
        """
        Enables GIF to MP4 transformations on this service.
        """
        return pulumi.get(self, "allow_video")

    @property
    @pulumi.getter(name="jpegQuality")
    def jpeg_quality(self) -> Optional[builtins.int]:
        """
        The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "jpeg_quality")

    @property
    @pulumi.getter(name="jpegType")
    def jpeg_type(self) -> Optional[builtins.str]:
        """
        The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
        	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
        	- baseline: Output baseline JPEG images
        	- progressive: Output progressive JPEG images
        """
        return pulumi.get(self, "jpeg_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resizeFilter")
    def resize_filter(self) -> Optional[builtins.str]:
        """
        The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
        	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
        	- lanczos2: A Lanczos filter with a kernel size of 2.
        	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
        	- bilinear: A filter using an average of a 2x2 environment of pixels.
        	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        """
        return pulumi.get(self, "resize_filter")

    @property
    @pulumi.getter
    def upscale(self) -> Optional[builtins.bool]:
        """
        Whether or not we should allow output images to render at sizes larger than input.
        """
        return pulumi.get(self, "upscale")

    @property
    @pulumi.getter
    def webp(self) -> Optional[builtins.bool]:
        """
        Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        """
        return pulumi.get(self, "webp")

    @property
    @pulumi.getter(name="webpQuality")
    def webp_quality(self) -> Optional[builtins.int]:
        """
        The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "webp_quality")


@pulumi.output_type
class ServiceVclLoggingBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: builtins.str,
                 email: builtins.str,
                 name: builtins.str,
                 project_id: builtins.str,
                 secret_key: builtins.str,
                 table: builtins.str,
                 account_name: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 template: Optional[builtins.str] = None):
        """
        :param builtins.str dataset: The ID of your BigQuery dataset
        :param builtins.str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param builtins.str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str project_id: The ID of your GCP project
        :param builtins.str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param builtins.str table: The ID of your BigQuery table
        :param builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param builtins.str format: The logging format desired.
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str response_condition: Name of a condition to apply this logging.
        :param builtins.str template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> builtins.str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> builtins.str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        The logging format desired.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def template(self) -> Optional[builtins.str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceVclLoggingBlobstorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingBlobstorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingBlobstorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingBlobstorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: builtins.str,
                 container: builtins.str,
                 name: builtins.str,
                 sas_token: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 file_max_bytes: Optional[builtins.int] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param builtins.str container: The name of the Azure Blob Storage container in which to store logs
        :param builtins.str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param builtins.int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str response_condition: The name of the condition to apply
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> builtins.str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> builtins.str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> builtins.str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Your Cloud File account access key
        :param builtins.str bucket_name: The name of your Cloud Files container
        :param builtins.str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str user: The username for your Cloud Files account
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: The path to upload logs to
        :param builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The API key from your Datadog account
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param builtins.str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 secret_key: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 domain: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Your DigitalOcean Spaces account access key
        :param builtins.str bucket_name: The name of the DigitalOcean Space
        :param builtins.str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str secret_key: Your DigitalOcean Spaces account secret key
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: The path to upload logs to
        :param builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: builtins.str,
                 name: builtins.str,
                 url: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 password: Optional[builtins.str] = None,
                 pipeline: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 request_max_bytes: Optional[builtins.int] = None,
                 request_max_entries: Optional[builtins.int] = None,
                 response_condition: Optional[builtins.str] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str index: The name of the Elasticsearch index to send documents (logs) to
        :param builtins.str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: The Elasticsearch URL to stream logs to
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param builtins.str password: BasicAuth password for Elasticsearch
        :param builtins.str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param builtins.int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param builtins.str response_condition: The name of the condition to apply
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param builtins.str user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[builtins.str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[builtins.int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[builtins.int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 password: builtins.str,
                 path: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str address: The FTP address to stream logs to
        :param builtins.str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str password: The password for the server (for anonymous use an email address)
        :param builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param builtins.str user: The username for the server (can be `anonymous`)
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.int port: The port number. Default: `21`
        :param builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str response_condition: The name of the condition to apply.
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingGc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 account_name: Optional[builtins.str] = None,
                 compression_codec: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the bucket in which to store the logs
        :param builtins.str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param builtins.int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str project_id: The ID of your Google Cloud Platform project
        :param builtins.str response_condition: Name of a condition to apply this logging.
        :param builtins.str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 project_id: builtins.str,
                 secret_key: builtins.str,
                 topic: builtins.str,
                 user: builtins.str,
                 account_name: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str project_id: The ID of your Google Cloud Platform project
        :param builtins.str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param builtins.str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingGrafanacloudlog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGrafanacloudlog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGrafanacloudlog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGrafanacloudlog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: builtins.str,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str,
                 user: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str index: The stream identifier as a JSON string
        :param builtins.str name: The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Access Policy Token key for your GrafanaCloudLogs account
        :param builtins.str url: The URL to stream logs to
        :param builtins.str user: The Grafana User ID
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        The stream identifier as a JSON string
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Access Policy Token key for your GrafanaCloudLogs account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The Grafana User ID
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHerokus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHerokus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHerokus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHerokus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param builtins.str url: The URL to stream logs to
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHoneycomb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHoneycomb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHoneycomb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHoneycomb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: builtins.str,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str dataset: The Honeycomb Dataset you want to log to
        :param builtins.str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Write Key from the Account page of your Honeycomb account
        :param builtins.str format: Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def dataset(self) -> builtins.str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 url: builtins.str,
                 content_type: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 header_name: Optional[builtins.str] = None,
                 header_value: Optional[builtins.str] = None,
                 json_format: Optional[builtins.str] = None,
                 message_type: Optional[builtins.str] = None,
                 method: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 request_max_bytes: Optional[builtins.int] = None,
                 request_max_entries: Optional[builtins.int] = None,
                 response_condition: Optional[builtins.str] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: URL that log data will be sent to. Must use the https protocol
        :param builtins.str content_type: Value of the `Content-Type` header sent with the request
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param builtins.str header_name: Custom header sent with the request
        :param builtins.str header_value: Value of the custom header sent with the request
        :param builtins.str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed
        :param builtins.int request_max_bytes: The maximum number of bytes sent in one request
        :param builtins.int request_max_entries: The maximum number of logs sent in one request
        :param builtins.str response_condition: The name of the condition to apply
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[builtins.str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[builtins.str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[builtins.str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[builtins.str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[builtins.int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[builtins.int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceVclLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: builtins.str,
                 name: builtins.str,
                 topic: builtins.str,
                 auth_method: Optional[builtins.str] = None,
                 compression_codec: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 parse_log_keyvals: Optional[builtins.bool] = None,
                 password: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 request_max_bytes: Optional[builtins.int] = None,
                 required_acks: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param builtins.str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str topic: The Kafka topic to send logs to
        :param builtins.str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param builtins.str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param builtins.bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param builtins.str password: SASL Pass
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param builtins.str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param builtins.bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param builtins.str user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def brokers(self) -> builtins.str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[builtins.str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[builtins.bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[builtins.int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[builtins.str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 topic: builtins.str,
                 access_key: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 iam_role: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str topic: The Kinesis stream name
        :param builtins.str access_key: The AWS access key to be used to write to the stream
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param builtins.str secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[builtins.str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceVclLoggingLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 response_condition: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.int port: The port number configured in Logentries
        :param builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        :param builtins.bool use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclLoggingLoggly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLoggly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLoggly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLoggly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingLogshuttle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLogshuttle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLogshuttle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLogshuttle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The data authentication token associated with this endpoint
        :param builtins.str url: Your Log Shuttle endpoint URL
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingNewrelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingNewrelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingNewrelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingNewrelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Insert API key from the Account page of your New Relic account
        :param builtins.str format: Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str region: The region that log data will be sent to. Default: `US`
        :param builtins.str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingNewrelicotlp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingNewrelicotlp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingNewrelicotlp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingNewrelicotlp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the New Relic OTLP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Insert API key from the Account page of your New Relic account
        :param builtins.str format: Apache style log formatting. Your log must produce valid JSON that New Relic OTLP can ingest.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str region: The region that log data will be sent to. Default: `US`
        :param builtins.str response_condition: The name of the condition to apply.
        :param builtins.str url: The optional New Relic Trace Observer URL to stream logs to for Infinite Tracing.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the New Relic OTLP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic OTLP can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The optional New Relic Trace Observer URL to stream logs to for Infinite Tracing.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceVclLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 url: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Your OpenStack account access key
        :param builtins.str bucket_name: The name of your OpenStack container
        :param builtins.str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: Your OpenStack auth url
        :param builtins.str user: The username for your OpenStack account
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingPapertrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingPapertrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingPapertrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingPapertrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 port: builtins.int,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str address: The address of the Papertrail endpoint
        :param builtins.str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.int port: The port associated with the address where the Papertrail endpoint can be accessed
        :param builtins.str format: A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 name: builtins.str,
                 acl: Optional[builtins.str] = None,
                 compression_codec: Optional[builtins.str] = None,
                 domain: Optional[builtins.str] = None,
                 file_max_bytes: Optional[builtins.int] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 redundancy: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 s3_access_key: Optional[builtins.str] = None,
                 s3_iam_role: Optional[builtins.str] = None,
                 s3_secret_key: Optional[builtins.str] = None,
                 server_side_encryption: Optional[builtins.str] = None,
                 server_side_encryption_kms_key_id: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the bucket in which to store the logs
        :param builtins.str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        :param builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        :param builtins.str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param builtins.str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param builtins.str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param builtins.str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param builtins.str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def acl(self) -> Optional[builtins.str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[builtins.str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[builtins.str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[builtins.str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[builtins.str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[builtins.str]:
        """
        Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingScalyr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingScalyr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingScalyr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingScalyr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param builtins.str format: Apache style log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str project_id: The name of the logfile field sent to Scalyr
        :param builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The name of the logfile field sent to Scalyr
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 path: builtins.str,
                 ssh_known_hosts: builtins.str,
                 user: builtins.str,
                 compression_codec: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 gzip_level: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 password: Optional[builtins.str] = None,
                 period: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 public_key: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param builtins.str address: The SFTP address to stream logs to
        :param builtins.str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param builtins.str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param builtins.str user: The username for the server
        :param builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.int port: The port the SFTP service listens on. (Default: `22`)
        :param builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param builtins.str response_condition: The name of the condition to apply.
        :param builtins.str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> builtins.str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 token: builtins.str,
                 url: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str token: The Splunk token to be used for authentication
        :param builtins.str url: The Splunk URL to stream logs to
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param builtins.str placement: Where in the generated VCL the logging call should be placed
        :param builtins.str response_condition: The name of the condition to apply
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param builtins.bool use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclLoggingSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 url: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 response_condition: Optional[builtins.str] = None):
        """
        :param builtins.str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str url: The URL to Sumologic collector endpoint
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 name: builtins.str,
                 format: Optional[builtins.str] = None,
                 format_version: Optional[builtins.int] = None,
                 message_type: Optional[builtins.str] = None,
                 placement: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 response_condition: Optional[builtins.str] = None,
                 tls_ca_cert: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_hostname: Optional[builtins.str] = None,
                 token: Optional[builtins.str] = None,
                 use_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str address: A hostname or IPv4 address of the Syslog endpoint
        :param builtins.str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param builtins.int format_version: The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        :param builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param builtins.int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        :param builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        :param builtins.str token: Whether to prepend each message with a specific token
        :param builtins.bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.int]:
        """
        The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[builtins.str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[builtins.bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclProductEnablement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botManagement":
            suggest = "bot_management"
        elif key == "brotliCompression":
            suggest = "brotli_compression"
        elif key == "ddosProtection":
            suggest = "ddos_protection"
        elif key == "domainInspector":
            suggest = "domain_inspector"
        elif key == "imageOptimizer":
            suggest = "image_optimizer"
        elif key == "logExplorerInsights":
            suggest = "log_explorer_insights"
        elif key == "originInspector":
            suggest = "origin_inspector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclProductEnablement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclProductEnablement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclProductEnablement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_management: Optional[builtins.bool] = None,
                 brotli_compression: Optional[builtins.bool] = None,
                 ddos_protection: Optional['outputs.ServiceVclProductEnablementDdosProtection'] = None,
                 domain_inspector: Optional[builtins.bool] = None,
                 image_optimizer: Optional[builtins.bool] = None,
                 log_explorer_insights: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 ngwaf: Optional['outputs.ServiceVclProductEnablementNgwaf'] = None,
                 origin_inspector: Optional[builtins.bool] = None,
                 websockets: Optional[builtins.bool] = None):
        """
        :param builtins.bool bot_management: Enable Bot Management support
        :param builtins.bool brotli_compression: Enable Brotli Compression support
        :param 'ServiceVclProductEnablementDdosProtectionArgs' ddos_protection: DDoS Protection product
        :param builtins.bool domain_inspector: Enable Domain Inspector support
        :param builtins.bool image_optimizer: Enable Image Optimizer support (all backends must have a `shield` attribute)
        :param builtins.bool log_explorer_insights: Enable Log Explorer & Insights
        :param builtins.str name: Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        :param 'ServiceVclProductEnablementNgwafArgs' ngwaf: Next-Gen WAF product
        :param builtins.bool origin_inspector: Enable Origin Inspector support
        :param builtins.bool websockets: Enable WebSockets support
        """
        if bot_management is not None:
            pulumi.set(__self__, "bot_management", bot_management)
        if brotli_compression is not None:
            pulumi.set(__self__, "brotli_compression", brotli_compression)
        if ddos_protection is not None:
            pulumi.set(__self__, "ddos_protection", ddos_protection)
        if domain_inspector is not None:
            pulumi.set(__self__, "domain_inspector", domain_inspector)
        if image_optimizer is not None:
            pulumi.set(__self__, "image_optimizer", image_optimizer)
        if log_explorer_insights is not None:
            pulumi.set(__self__, "log_explorer_insights", log_explorer_insights)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngwaf is not None:
            pulumi.set(__self__, "ngwaf", ngwaf)
        if origin_inspector is not None:
            pulumi.set(__self__, "origin_inspector", origin_inspector)
        if websockets is not None:
            pulumi.set(__self__, "websockets", websockets)

    @property
    @pulumi.getter(name="botManagement")
    def bot_management(self) -> Optional[builtins.bool]:
        """
        Enable Bot Management support
        """
        return pulumi.get(self, "bot_management")

    @property
    @pulumi.getter(name="brotliCompression")
    def brotli_compression(self) -> Optional[builtins.bool]:
        """
        Enable Brotli Compression support
        """
        return pulumi.get(self, "brotli_compression")

    @property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> Optional['outputs.ServiceVclProductEnablementDdosProtection']:
        """
        DDoS Protection product
        """
        return pulumi.get(self, "ddos_protection")

    @property
    @pulumi.getter(name="domainInspector")
    def domain_inspector(self) -> Optional[builtins.bool]:
        """
        Enable Domain Inspector support
        """
        return pulumi.get(self, "domain_inspector")

    @property
    @pulumi.getter(name="imageOptimizer")
    def image_optimizer(self) -> Optional[builtins.bool]:
        """
        Enable Image Optimizer support (all backends must have a `shield` attribute)
        """
        return pulumi.get(self, "image_optimizer")

    @property
    @pulumi.getter(name="logExplorerInsights")
    def log_explorer_insights(self) -> Optional[builtins.bool]:
        """
        Enable Log Explorer & Insights
        """
        return pulumi.get(self, "log_explorer_insights")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ngwaf(self) -> Optional['outputs.ServiceVclProductEnablementNgwaf']:
        """
        Next-Gen WAF product
        """
        return pulumi.get(self, "ngwaf")

    @property
    @pulumi.getter(name="originInspector")
    def origin_inspector(self) -> Optional[builtins.bool]:
        """
        Enable Origin Inspector support
        """
        return pulumi.get(self, "origin_inspector")

    @property
    @pulumi.getter
    def websockets(self) -> Optional[builtins.bool]:
        """
        Enable WebSockets support
        """
        return pulumi.get(self, "websockets")


@pulumi.output_type
class ServiceVclProductEnablementDdosProtection(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 mode: builtins.str):
        """
        :param builtins.bool enabled: Enable DDoS Protection support
        :param builtins.str mode: Operation mode
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enable DDoS Protection support
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Operation mode
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ServiceVclProductEnablementNgwaf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "trafficRamp":
            suggest = "traffic_ramp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclProductEnablementNgwaf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclProductEnablementNgwaf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclProductEnablementNgwaf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 workspace_id: builtins.str,
                 traffic_ramp: Optional[builtins.int] = None):
        """
        :param builtins.bool enabled: Enable Next-Gen WAF support
        :param builtins.str workspace_id: The workspace to link
        :param builtins.int traffic_ramp: The percentage of traffic to inspect
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if traffic_ramp is not None:
            pulumi.set(__self__, "traffic_ramp", traffic_ramp)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enable Next-Gen WAF support
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> builtins.str:
        """
        The workspace to link
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter(name="trafficRamp")
    def traffic_ramp(self) -> Optional[builtins.int]:
        """
        The percentage of traffic to inspect
        """
        return pulumi.get(self, "traffic_ramp")


@pulumi.output_type
class ServiceVclRateLimiter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientKey":
            suggest = "client_key"
        elif key == "httpMethods":
            suggest = "http_methods"
        elif key == "penaltyBoxDuration":
            suggest = "penalty_box_duration"
        elif key == "rpsLimit":
            suggest = "rps_limit"
        elif key == "windowSize":
            suggest = "window_size"
        elif key == "featureRevision":
            suggest = "feature_revision"
        elif key == "loggerType":
            suggest = "logger_type"
        elif key == "ratelimiterId":
            suggest = "ratelimiter_id"
        elif key == "responseObjectName":
            suggest = "response_object_name"
        elif key == "uriDictionaryName":
            suggest = "uri_dictionary_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRateLimiter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRateLimiter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRateLimiter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 client_key: builtins.str,
                 http_methods: builtins.str,
                 name: builtins.str,
                 penalty_box_duration: builtins.int,
                 rps_limit: builtins.int,
                 window_size: builtins.int,
                 feature_revision: Optional[builtins.int] = None,
                 logger_type: Optional[builtins.str] = None,
                 ratelimiter_id: Optional[builtins.str] = None,
                 response: Optional['outputs.ServiceVclRateLimiterResponse'] = None,
                 response_object_name: Optional[builtins.str] = None,
                 uri_dictionary_name: Optional[builtins.str] = None):
        """
        :param builtins.str action: The action to take when a rate limiter violation is detected (one of: log_only, response, response_object)
        :param builtins.str client_key: Comma-separated list of VCL variables used to generate a counter key to identify a client
        :param builtins.str http_methods: Comma-separated list of HTTP methods to apply rate limiting to
        :param builtins.str name: A unique human readable name for the rate limiting rule
        :param builtins.int penalty_box_duration: Length of time in minutes that the rate limiter is in effect after the initial violation is detected
        :param builtins.int rps_limit: Upper limit of requests per second allowed by the rate limiter
        :param builtins.int window_size: Number of seconds during which the RPS limit must be exceeded in order to trigger a violation (one of: 1, 10, 60)
        :param builtins.int feature_revision: Revision number of the rate limiting feature implementation
        :param builtins.str logger_type: Name of the type of logging endpoint to be used when action is log_only (one of: azureblob, bigquery, cloudfiles, datadog, digitalocean, elasticsearch, ftp, gcs, googleanalytics, heroku, honeycomb, http, https, kafka, kinesis, logentries, loggly, logshuttle, newrelic, openstack, papertrail, pubsub, s3, scalyr, sftp, splunk, stackdriver, sumologic, syslog)
        :param builtins.str ratelimiter_id: Alphanumeric string identifying the rate limiter
        :param 'ServiceVclRateLimiterResponseArgs' response: Custom response to be sent when the rate limit is exceeded. Required if action is response
        :param builtins.str response_object_name: Name of existing response object. Required if action is response_object
        :param builtins.str uri_dictionary_name: The name of an Edge Dictionary containing URIs as keys. If not defined or null, all origin URIs will be rate limited
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "http_methods", http_methods)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "penalty_box_duration", penalty_box_duration)
        pulumi.set(__self__, "rps_limit", rps_limit)
        pulumi.set(__self__, "window_size", window_size)
        if feature_revision is not None:
            pulumi.set(__self__, "feature_revision", feature_revision)
        if logger_type is not None:
            pulumi.set(__self__, "logger_type", logger_type)
        if ratelimiter_id is not None:
            pulumi.set(__self__, "ratelimiter_id", ratelimiter_id)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if response_object_name is not None:
            pulumi.set(__self__, "response_object_name", response_object_name)
        if uri_dictionary_name is not None:
            pulumi.set(__self__, "uri_dictionary_name", uri_dictionary_name)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when a rate limiter violation is detected (one of: log_only, response, response_object)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> builtins.str:
        """
        Comma-separated list of VCL variables used to generate a counter key to identify a client
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="httpMethods")
    def http_methods(self) -> builtins.str:
        """
        Comma-separated list of HTTP methods to apply rate limiting to
        """
        return pulumi.get(self, "http_methods")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique human readable name for the rate limiting rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="penaltyBoxDuration")
    def penalty_box_duration(self) -> builtins.int:
        """
        Length of time in minutes that the rate limiter is in effect after the initial violation is detected
        """
        return pulumi.get(self, "penalty_box_duration")

    @property
    @pulumi.getter(name="rpsLimit")
    def rps_limit(self) -> builtins.int:
        """
        Upper limit of requests per second allowed by the rate limiter
        """
        return pulumi.get(self, "rps_limit")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> builtins.int:
        """
        Number of seconds during which the RPS limit must be exceeded in order to trigger a violation (one of: 1, 10, 60)
        """
        return pulumi.get(self, "window_size")

    @property
    @pulumi.getter(name="featureRevision")
    def feature_revision(self) -> Optional[builtins.int]:
        """
        Revision number of the rate limiting feature implementation
        """
        return pulumi.get(self, "feature_revision")

    @property
    @pulumi.getter(name="loggerType")
    def logger_type(self) -> Optional[builtins.str]:
        """
        Name of the type of logging endpoint to be used when action is log_only (one of: azureblob, bigquery, cloudfiles, datadog, digitalocean, elasticsearch, ftp, gcs, googleanalytics, heroku, honeycomb, http, https, kafka, kinesis, logentries, loggly, logshuttle, newrelic, openstack, papertrail, pubsub, s3, scalyr, sftp, splunk, stackdriver, sumologic, syslog)
        """
        return pulumi.get(self, "logger_type")

    @property
    @pulumi.getter(name="ratelimiterId")
    def ratelimiter_id(self) -> Optional[builtins.str]:
        """
        Alphanumeric string identifying the rate limiter
        """
        return pulumi.get(self, "ratelimiter_id")

    @property
    @pulumi.getter
    def response(self) -> Optional['outputs.ServiceVclRateLimiterResponse']:
        """
        Custom response to be sent when the rate limit is exceeded. Required if action is response
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="responseObjectName")
    def response_object_name(self) -> Optional[builtins.str]:
        """
        Name of existing response object. Required if action is response_object
        """
        return pulumi.get(self, "response_object_name")

    @property
    @pulumi.getter(name="uriDictionaryName")
    def uri_dictionary_name(self) -> Optional[builtins.str]:
        """
        The name of an Edge Dictionary containing URIs as keys. If not defined or null, all origin URIs will be rate limited
        """
        return pulumi.get(self, "uri_dictionary_name")


@pulumi.output_type
class ServiceVclRateLimiterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRateLimiterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRateLimiterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRateLimiterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: builtins.str,
                 status: builtins.int):
        """
        :param builtins.str content: HTTP response body data
        :param builtins.str content_type: HTTP Content-Type (e.g. application/json)
        :param builtins.int status: HTTP response status code (e.g. 429)
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        HTTP response body data
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        HTTP Content-Type (e.g. application/json)
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def status(self) -> builtins.int:
        """
        HTTP response status code (e.g. 429)
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceVclRequestSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bypassBusyWait":
            suggest = "bypass_busy_wait"
        elif key == "defaultHost":
            suggest = "default_host"
        elif key == "forceMiss":
            suggest = "force_miss"
        elif key == "forceSsl":
            suggest = "force_ssl"
        elif key == "geoHeaders":
            suggest = "geo_headers"
        elif key == "hashKeys":
            suggest = "hash_keys"
        elif key == "maxStaleAge":
            suggest = "max_stale_age"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "timerSupport":
            suggest = "timer_support"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRequestSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRequestSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRequestSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 action: Optional[builtins.str] = None,
                 bypass_busy_wait: Optional[builtins.bool] = None,
                 default_host: Optional[builtins.str] = None,
                 force_miss: Optional[builtins.bool] = None,
                 force_ssl: Optional[builtins.bool] = None,
                 geo_headers: Optional[builtins.bool] = None,
                 hash_keys: Optional[builtins.str] = None,
                 max_stale_age: Optional[builtins.int] = None,
                 request_condition: Optional[builtins.str] = None,
                 timer_support: Optional[builtins.bool] = None,
                 xff: Optional[builtins.str] = None):
        """
        :param builtins.str name: Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str action: Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        :param builtins.bool bypass_busy_wait: Disable collapsed forwarding, so you don't wait for other objects to origin
        :param builtins.str default_host: Sets the host header
        :param builtins.bool force_miss: Force a cache miss for the request. If specified, can be `true` or `false`
        :param builtins.bool force_ssl: Forces the request to use SSL (Redirects a non-SSL request to SSL)
        :param builtins.bool geo_headers: Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        :param builtins.str hash_keys: Comma separated list of varnish request object fields that should be in the hash key
        :param builtins.int max_stale_age: How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        :param builtins.str request_condition: Name of already defined `condition` to determine if this request setting should be applied (should be unique across multiple instances of `request_setting`)
        :param builtins.bool timer_support: Injects the X-Timer info into the request for viewing origin fetch durations
        :param builtins.str xff: X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypass_busy_wait is not None:
            pulumi.set(__self__, "bypass_busy_wait", bypass_busy_wait)
        if default_host is not None:
            pulumi.set(__self__, "default_host", default_host)
        if force_miss is not None:
            pulumi.set(__self__, "force_miss", force_miss)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if geo_headers is not None:
            pulumi.set(__self__, "geo_headers", geo_headers)
        if hash_keys is not None:
            pulumi.set(__self__, "hash_keys", hash_keys)
        if max_stale_age is not None:
            pulumi.set(__self__, "max_stale_age", max_stale_age)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if timer_support is not None:
            pulumi.set(__self__, "timer_support", timer_support)
        if xff is not None:
            pulumi.set(__self__, "xff", xff)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="bypassBusyWait")
    def bypass_busy_wait(self) -> Optional[builtins.bool]:
        """
        Disable collapsed forwarding, so you don't wait for other objects to origin
        """
        return pulumi.get(self, "bypass_busy_wait")

    @property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> Optional[builtins.str]:
        """
        Sets the host header
        """
        return pulumi.get(self, "default_host")

    @property
    @pulumi.getter(name="forceMiss")
    def force_miss(self) -> Optional[builtins.bool]:
        """
        Force a cache miss for the request. If specified, can be `true` or `false`
        """
        return pulumi.get(self, "force_miss")

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[builtins.bool]:
        """
        Forces the request to use SSL (Redirects a non-SSL request to SSL)
        """
        return pulumi.get(self, "force_ssl")

    @property
    @pulumi.getter(name="geoHeaders")
    @_utilities.deprecated("""'geo_headers' attribute has been deprecated and will be removed in the next major version release""")
    def geo_headers(self) -> Optional[builtins.bool]:
        """
        Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        """
        return pulumi.get(self, "geo_headers")

    @property
    @pulumi.getter(name="hashKeys")
    def hash_keys(self) -> Optional[builtins.str]:
        """
        Comma separated list of varnish request object fields that should be in the hash key
        """
        return pulumi.get(self, "hash_keys")

    @property
    @pulumi.getter(name="maxStaleAge")
    def max_stale_age(self) -> Optional[builtins.int]:
        """
        How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        """
        return pulumi.get(self, "max_stale_age")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` to determine if this request setting should be applied (should be unique across multiple instances of `request_setting`)
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="timerSupport")
    def timer_support(self) -> Optional[builtins.bool]:
        """
        Injects the X-Timer info into the request for viewing origin fetch durations
        """
        return pulumi.get(self, "timer_support")

    @property
    @pulumi.getter
    def xff(self) -> Optional[builtins.str]:
        """
        X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        return pulumi.get(self, "xff")


@pulumi.output_type
class ServiceVclResponseObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "requestCondition":
            suggest = "request_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclResponseObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclResponseObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclResponseObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 cache_condition: Optional[builtins.str] = None,
                 content: Optional[builtins.str] = None,
                 content_type: Optional[builtins.str] = None,
                 request_condition: Optional[builtins.str] = None,
                 response: Optional[builtins.str] = None,
                 status: Optional[builtins.int] = None):
        """
        :param builtins.str name: A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param builtins.str content: The content to deliver for the response object
        :param builtins.str content_type: The MIME type of the content
        :param builtins.str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        :param builtins.str response: The HTTP Response. Default `OK`
        :param builtins.int status: The HTTP Status Code. Default `200`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        The content to deliver for the response object
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[builtins.str]:
        """
        The MIME type of the content
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[builtins.str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter
    def response(self) -> Optional[builtins.str]:
        """
        The HTTP Response. Default `OK`
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.int]:
        """
        The HTTP Status Code. Default `200`
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceVclSnippet(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 name: builtins.str,
                 type: builtins.str,
                 priority: Optional[builtins.int] = None):
        """
        :param builtins.str content: The VCL code that specifies exactly what the snippet does
        :param builtins.str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param builtins.int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ServiceVclVcl(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 name: builtins.str,
                 main: Optional[builtins.bool] = None):
        """
        :param builtins.str content: The custom VCL code to upload
        :param builtins.str name: A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        :param builtins.bool main: If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if main is not None:
            pulumi.set(__self__, "main", main)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The custom VCL code to upload
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def main(self) -> Optional[builtins.bool]:
        """
        If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        return pulumi.get(self, "main")


@pulumi.output_type
class TlsSubscriptionManagedDnsChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValue":
            suggest = "record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedDnsChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[builtins.str] = None,
                 record_type: Optional[builtins.str] = None,
                 record_value: Optional[builtins.str] = None):
        """
        :param builtins.str record_name: The name of the DNS record to add. For example `_acme-challenge.example.com`.
        :param builtins.str record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param builtins.str record_value: The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_value is not None:
            pulumi.set(__self__, "record_value", record_value)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[builtins.str]:
        """
        The name of the DNS record to add. For example `_acme-challenge.example.com`.
        """
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[builtins.str]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> Optional[builtins.str]:
        """
        The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        return pulumi.get(self, "record_value")


@pulumi.output_type
class TlsSubscriptionManagedHttpChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValues":
            suggest = "record_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedHttpChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[builtins.str] = None,
                 record_type: Optional[builtins.str] = None,
                 record_values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str record_name: The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        :param builtins.str record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param Sequence[builtins.str] record_values: A list with the value(s) to which the DNS record should point.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_values is not None:
            pulumi.set(__self__, "record_values", record_values)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[builtins.str]:
        """
        The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[builtins.str]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValues")
    def record_values(self) -> Optional[Sequence[builtins.str]]:
        """
        A list with the value(s) to which the DNS record should point.
        """
        return pulumi.get(self, "record_values")


@pulumi.output_type
class GetConfigstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str id: Alphanumeric string identifying the Config Store.
        :param builtins.str name: Name for the Config Store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the Config Store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatacentersPopResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 group: builtins.str,
                 name: builtins.str,
                 shield: builtins.str):
        """
        :param builtins.str code: A code representing the POP location.
        :param builtins.str group: A code representing the general region of the world in which the POP location resides.
        :param builtins.str name: The name of the POP.
        :param builtins.str shield: A code representing the shielding name of the POP. The value may be empty if the POP is not available for shielding.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "shield", shield)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        A code representing the POP location.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def group(self) -> builtins.str:
        """
        A code representing the general region of the world in which the POP location resides.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the POP.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shield(self) -> builtins.str:
        """
        A code representing the shielding name of the POP. The value may be empty if the POP is not available for shielding.
        """
        return pulumi.get(self, "shield")


@pulumi.output_type
class GetDictionariesDictionaryResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str,
                 write_only: builtins.bool):
        """
        :param builtins.str id: Alphanumeric string identifying the Dictionary.
        :param builtins.str name: Name for the Dictionary.
        :param builtins.bool write_only: Indicates if items in the dictionary are readable or not.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Alphanumeric string identifying the Dictionary.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the Dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> builtins.bool:
        """
        Indicates if items in the dictionary are readable or not.
        """
        return pulumi.get(self, "write_only")


@pulumi.output_type
class GetKvstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str id: Alphanumeric string identifying the KV Store.
        :param builtins.str name: Name for the KV Store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Alphanumeric string identifying the KV Store.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the KV Store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSecretstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str id: Alphanumeric string identifying the Secrets Store.
        :param builtins.str name: Name for the Secrets Store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Alphanumeric string identifying the Secrets Store.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the Secrets Store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServicesDetailResult(dict):
    def __init__(__self__, *,
                 comment: builtins.str,
                 created_at: builtins.str,
                 customer_id: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 type: builtins.str,
                 updated_at: builtins.str,
                 version: builtins.int):
        """
        :param builtins.str comment: A freeform descriptive note.
        :param builtins.str created_at: Date and time in ISO 8601 format.
        :param builtins.str customer_id: Alphanumeric string identifying the customer.
        :param builtins.str id: Alphanumeric string identifying the service.
        :param builtins.str name: The name of the service.
        :param builtins.str type: The type of this service. One of `vcl`, `wasm`.
        :param builtins.str updated_at: Date and time in ISO 8601 format.
        :param builtins.int version: The currently activated version.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "customer_id", customer_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def comment(self) -> builtins.str:
        """
        A freeform descriptive note.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> builtins.str:
        """
        Alphanumeric string identifying the customer.
        """
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Alphanumeric string identifying the service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of this service. One of `vcl`, `wasm`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The currently activated version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetTlsConfigurationDnsRecordResult(dict):
    def __init__(__self__, *,
                 record_type: builtins.str,
                 record_value: builtins.str,
                 region: builtins.str):
        """
        :param builtins.str record_type: Type of DNS record to set, e.g. A, AAAA, or CNAME.
        :param builtins.str record_value: The IP address or hostname of the DNS record.
        :param builtins.str region: The regions that will be used to route traffic. Select DNS Records with a `global` region to route traffic to the most performant point of presence (POP) worldwide (global pricing will apply). Select DNS records with a `us-eu` region to exclusively land traffic on North American and European POPs.
        """
        pulumi.set(__self__, "record_type", record_type)
        pulumi.set(__self__, "record_value", record_value)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> builtins.str:
        """
        Type of DNS record to set, e.g. A, AAAA, or CNAME.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> builtins.str:
        """
        The IP address or hostname of the DNS record.
        """
        return pulumi.get(self, "record_value")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The regions that will be used to route traffic. Select DNS Records with a `global` region to route traffic to the most performant point of presence (POP) worldwide (global pricing will apply). Select DNS records with a `us-eu` region to exclusively land traffic on North American and European POPs.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetVclSnippetsVclSnippetResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 priority: builtins.int,
                 type: builtins.str):
        """
        :param builtins.str content: The VCL code that specifies exactly what the snippet does.
        :param builtins.str id: Alphanumeric string identifying a VCL Snippet.
        :param builtins.str name: The name for the snippet.
        :param builtins.int priority: Priority determines execution order. Lower numbers execute first.
        :param builtins.str type: The location in generated VCL where the snippet should be placed.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The VCL code that specifies exactly what the snippet does.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Alphanumeric string identifying a VCL Snippet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name for the snippet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        Priority determines execution order. Lower numbers execute first.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The location in generated VCL where the snippet should be placed.
        """
        return pulumi.get(self, "type")


