"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisMetrics = void 0;
const kinesis_canned_metrics_generated_1 = require("./kinesis-canned-metrics.generated");
/**
 * This class is to consolidate all the metrics from Stream in just one place.
 *
 * Current generated canned metrics don't match the proper metrics from the service. If it is fixed
 * at the source this class can be removed and just use the generated one directly.
 *
 * Stream Metrics reference: https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html
 */
class KinesisMetrics {
    static getRecordsBytesAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Bytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsSuccessAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Success',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Records',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordBytesAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecord.Bytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecord.Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsIteratorAgeMillisecondsMaximum(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.getRecordsIteratorAgeMillisecondsMaximum(dimensions);
    }
    static putRecordSuccessAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.putRecordSuccessAverage(dimensions);
    }
    static putRecordsBytesAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.putRecordsBytesAverage(dimensions);
    }
    static putRecordsLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsSuccessAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.Success',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsTotalRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.TotalRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsSuccessfulRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.SuccessfulRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsFailedRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.FailedRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsThrottledRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.ThrottledRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static incomingBytesAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.incomingBytesAverage(dimensions);
    }
    static incomingRecordsAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.incomingRecordsAverage(dimensions);
    }
    static readProvisionedThroughputExceededAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.readProvisionedThroughputExceededAverage(dimensions);
    }
    static writeProvisionedThroughputExceededAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.writeProvisionedThroughputExceededAverage(dimensions);
    }
}
exports.KinesisMetrics = KinesisMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1maXhlZC1jYW5uZWQtbWV0cmljcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImtpbmVzaXMtZml4ZWQtY2FubmVkLW1ldHJpY3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEseUZBQXFGO0FBRXJGOzs7Ozs7O0dBT0c7QUFDSCxNQUFhLGNBQWM7SUFDbEIsTUFBTSxDQUFDLHNCQUFzQixDQUFDLFVBQWtDO1FBQ3JFLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsa0JBQWtCO1lBQzlCLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0lBQ0osQ0FBQztJQUNNLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxVQUFrQztRQUN2RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLG9CQUFvQjtZQUNoQyxVQUFVO1lBQ1YsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztJQUNKLENBQUM7SUFDTSxNQUFNLENBQUMsd0JBQXdCLENBQUMsVUFBa0M7UUFDdkUsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxvQkFBb0I7WUFDaEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7SUFDSixDQUFDO0lBQ00sTUFBTSxDQUFDLHdCQUF3QixDQUFDLFVBQWtDO1FBQ3ZFLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsb0JBQW9CO1lBQ2hDLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0lBQ0osQ0FBQztJQUNNLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxVQUFrQztRQUNwRSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLGlCQUFpQjtZQUM3QixVQUFVO1lBQ1YsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztJQUNKLENBQUM7SUFDTSxNQUFNLENBQUMsdUJBQXVCLENBQUMsVUFBa0M7UUFDdEUsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxtQkFBbUI7WUFDL0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7SUFDSixDQUFDO0lBQ00sTUFBTSxDQUFDLHdDQUF3QyxDQUFDLFVBQWtDO1FBQ3ZGLE9BQU8saURBQWEsQ0FBQyx3Q0FBd0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBQ00sTUFBTSxDQUFDLHVCQUF1QixDQUFDLFVBQWtDO1FBQ3RFLE9BQU8saURBQWEsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ00sTUFBTSxDQUFDLHNCQUFzQixDQUFDLFVBQWtDO1FBQ3JFLE9BQU8saURBQWEsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ00sTUFBTSxDQUFDLHdCQUF3QixDQUFDLFVBQWtDO1FBQ3ZFLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsb0JBQW9CO1lBQ2hDLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0lBQ0osQ0FBQztJQUNNLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxVQUFrQztRQUN2RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLG9CQUFvQjtZQUNoQyxVQUFVO1lBQ1YsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztJQUNKLENBQUM7SUFDTSxNQUFNLENBQUMsNkJBQTZCLENBQUMsVUFBa0M7UUFDNUUsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSx5QkFBeUI7WUFDckMsVUFBVTtZQUNWLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7SUFDSixDQUFDO0lBQ00sTUFBTSxDQUFDLGtDQUFrQyxDQUFDLFVBQWtDO1FBQ2pGLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsOEJBQThCO1lBQzFDLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0lBQ0osQ0FBQztJQUNNLE1BQU0sQ0FBQyw4QkFBOEIsQ0FBQyxVQUFrQztRQUM3RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLDBCQUEwQjtZQUN0QyxVQUFVO1lBQ1YsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztJQUNKLENBQUM7SUFDTSxNQUFNLENBQUMsaUNBQWlDLENBQUMsVUFBa0M7UUFDaEYsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSw2QkFBNkI7WUFDekMsVUFBVTtZQUNWLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7SUFDSixDQUFDO0lBQ00sTUFBTSxDQUFDLG9CQUFvQixDQUFDLFVBQWtDO1FBQ25FLE9BQU8saURBQWEsQ0FBQyxvQkFBb0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBQ00sTUFBTSxDQUFDLHNCQUFzQixDQUFDLFVBQWtDO1FBQ3JFLE9BQU8saURBQWEsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ00sTUFBTSxDQUFDLHdDQUF3QyxDQUFDLFVBQWtDO1FBQ3ZGLE9BQU8saURBQWEsQ0FBQyx3Q0FBd0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBQ00sTUFBTSxDQUFDLHlDQUF5QyxDQUFDLFVBQWtDO1FBQ3hGLE9BQU8saURBQWEsQ0FBQyx5Q0FBeUMsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3RSxDQUFDO0NBQ0Y7QUF0SEQsd0NBc0hDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgS2luZXNpc01ldHJpY3MgYXMgQ2FubmVkTWV0cmljcyB9IGZyb20gJy4va2luZXNpcy1jYW5uZWQtbWV0cmljcy5nZW5lcmF0ZWQnO1xuXG4vKipcbiAqIFRoaXMgY2xhc3MgaXMgdG8gY29uc29saWRhdGUgYWxsIHRoZSBtZXRyaWNzIGZyb20gU3RyZWFtIGluIGp1c3Qgb25lIHBsYWNlLlxuICpcbiAqIEN1cnJlbnQgZ2VuZXJhdGVkIGNhbm5lZCBtZXRyaWNzIGRvbid0IG1hdGNoIHRoZSBwcm9wZXIgbWV0cmljcyBmcm9tIHRoZSBzZXJ2aWNlLiBJZiBpdCBpcyBmaXhlZFxuICogYXQgdGhlIHNvdXJjZSB0aGlzIGNsYXNzIGNhbiBiZSByZW1vdmVkIGFuZCBqdXN0IHVzZSB0aGUgZ2VuZXJhdGVkIG9uZSBkaXJlY3RseS5cbiAqXG4gKiBTdHJlYW0gTWV0cmljcyByZWZlcmVuY2U6IGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zdHJlYW1zL2xhdGVzdC9kZXYvbW9uaXRvcmluZy13aXRoLWNsb3Vkd2F0Y2guaHRtbFxuICovXG5leHBvcnQgY2xhc3MgS2luZXNpc01ldHJpY3Mge1xuICBwdWJsaWMgc3RhdGljIGdldFJlY29yZHNCeXRlc0F2ZXJhZ2UoZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvS2luZXNpcycsXG4gICAgICBtZXRyaWNOYW1lOiAnR2V0UmVjb3Jkcy5CeXRlcycsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGdldFJlY29yZHNTdWNjZXNzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9LaW5lc2lzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdHZXRSZWNvcmRzLlN1Y2Nlc3MnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBnZXRSZWNvcmRzUmVjb3Jkc0F2ZXJhZ2UoZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvS2luZXNpcycsXG4gICAgICBtZXRyaWNOYW1lOiAnR2V0UmVjb3Jkcy5SZWNvcmRzJyxcbiAgICAgIGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgZ2V0UmVjb3Jkc0xhdGVuY3lBdmVyYWdlKGRpbWVuc2lvbnM6IHsgU3RyZWFtTmFtZTogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL0tpbmVzaXMnLFxuICAgICAgbWV0cmljTmFtZTogJ0dldFJlY29yZHMuTGF0ZW5jeScsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHB1dFJlY29yZEJ5dGVzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9LaW5lc2lzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdQdXRSZWNvcmQuQnl0ZXMnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBwdXRSZWNvcmRMYXRlbmN5QXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9LaW5lc2lzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdQdXRSZWNvcmQuTGF0ZW5jeScsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGdldFJlY29yZHNJdGVyYXRvckFnZU1pbGxpc2Vjb25kc01heGltdW0oZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiBDYW5uZWRNZXRyaWNzLmdldFJlY29yZHNJdGVyYXRvckFnZU1pbGxpc2Vjb25kc01heGltdW0oZGltZW5zaW9ucyk7XG4gIH1cbiAgcHVibGljIHN0YXRpYyBwdXRSZWNvcmRTdWNjZXNzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIENhbm5lZE1ldHJpY3MucHV0UmVjb3JkU3VjY2Vzc0F2ZXJhZ2UoZGltZW5zaW9ucyk7XG4gIH1cbiAgcHVibGljIHN0YXRpYyBwdXRSZWNvcmRzQnl0ZXNBdmVyYWdlKGRpbWVuc2lvbnM6IHsgU3RyZWFtTmFtZTogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4gQ2FubmVkTWV0cmljcy5wdXRSZWNvcmRzQnl0ZXNBdmVyYWdlKGRpbWVuc2lvbnMpO1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgcHV0UmVjb3Jkc0xhdGVuY3lBdmVyYWdlKGRpbWVuc2lvbnM6IHsgU3RyZWFtTmFtZTogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL0tpbmVzaXMnLFxuICAgICAgbWV0cmljTmFtZTogJ1B1dFJlY29yZHMuTGF0ZW5jeScsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHB1dFJlY29yZHNTdWNjZXNzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9LaW5lc2lzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdQdXRSZWNvcmRzLlN1Y2Nlc3MnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBwdXRSZWNvcmRzVG90YWxSZWNvcmRzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9LaW5lc2lzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdQdXRSZWNvcmRzLlRvdGFsUmVjb3JkcycsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHB1dFJlY29yZHNTdWNjZXNzZnVsUmVjb3Jkc0F2ZXJhZ2UoZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvS2luZXNpcycsXG4gICAgICBtZXRyaWNOYW1lOiAnUHV0UmVjb3Jkcy5TdWNjZXNzZnVsUmVjb3JkcycsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHB1dFJlY29yZHNGYWlsZWRSZWNvcmRzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9LaW5lc2lzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdQdXRSZWNvcmRzLkZhaWxlZFJlY29yZHMnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBwdXRSZWNvcmRzVGhyb3R0bGVkUmVjb3Jkc0F2ZXJhZ2UoZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvS2luZXNpcycsXG4gICAgICBtZXRyaWNOYW1lOiAnUHV0UmVjb3Jkcy5UaHJvdHRsZWRSZWNvcmRzJyxcbiAgICAgIGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgaW5jb21pbmdCeXRlc0F2ZXJhZ2UoZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiBDYW5uZWRNZXRyaWNzLmluY29taW5nQnl0ZXNBdmVyYWdlKGRpbWVuc2lvbnMpO1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgaW5jb21pbmdSZWNvcmRzQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIENhbm5lZE1ldHJpY3MuaW5jb21pbmdSZWNvcmRzQXZlcmFnZShkaW1lbnNpb25zKTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHJlYWRQcm92aXNpb25lZFRocm91Z2hwdXRFeGNlZWRlZEF2ZXJhZ2UoZGltZW5zaW9uczogeyBTdHJlYW1OYW1lOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiBDYW5uZWRNZXRyaWNzLnJlYWRQcm92aXNpb25lZFRocm91Z2hwdXRFeGNlZWRlZEF2ZXJhZ2UoZGltZW5zaW9ucyk7XG4gIH1cbiAgcHVibGljIHN0YXRpYyB3cml0ZVByb3Zpc2lvbmVkVGhyb3VnaHB1dEV4Y2VlZGVkQXZlcmFnZShkaW1lbnNpb25zOiB7IFN0cmVhbU5hbWU6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIENhbm5lZE1ldHJpY3Mud3JpdGVQcm92aXNpb25lZFRocm91Z2hwdXRFeGNlZWRlZEF2ZXJhZ2UoZGltZW5zaW9ucyk7XG4gIH1cbn1cbiJdfQ==