/* -*- c++ -*-
 * Copyright (c) 2012-2022 by the GalSim developers team on GitHub
 * https://github.com/GalSim-developers
 *
 * This file is part of GalSim: The modular galaxy image simulation toolkit.
 * https://github.com/GalSim-developers/GalSim
 *
 * GalSim is free software: redistribution and use in source and binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions, and the disclaimer given in the accompanying LICENSE
 *    file.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions, and the disclaimer given in the documentation
 *    and/or other materials provided with the distribution.
 */
// This just includes the relevant header files from the galsim directory.

#ifndef GalSim_H
#define GalSim_H

// Image classes
#include "galsim/Image.h"
#include "galsim/ImageArith.h"

// The basic SBProfile stuff:
#include "galsim/SBProfile.h"
#include "galsim/SBAdd.h"
#include "galsim/SBAiry.h"
#include "galsim/SBBox.h"
#include "galsim/SBConvolve.h"
#include "galsim/SBDeconvolve.h"
#include "galsim/SBDeltaFunction.h"
#include "galsim/SBExponential.h"
#include "galsim/SBFourierSqrt.h"
#include "galsim/SBGaussian.h"
#include "galsim/SBInclinedExponential.h"
#include "galsim/SBInclinedSersic.h"
#include "galsim/SBInterpolatedImage.h"
#include "galsim/SBKolmogorov.h"
#include "galsim/SBMoffat.h"
#include "galsim/SBSecondKick.h"
#include "galsim/SBSersic.h"
#include "galsim/SBShapelet.h"
#include "galsim/SBSpergel.h"
#include "galsim/SBTransform.h"
#include "galsim/SBVonKarman.h"
#include "galsim/GSParams.h"

// Positions and Bounds
#include "galsim/Bounds.h"

// Noise
#include "galsim/Random.h"
#include "galsim/CorrelatedNoise.h"

// Photons and Sensor Effects
#include "galsim/PhotonArray.h"
#include "galsim/Silicon.h"
#include "galsim/CDModel.h"

// Interpolation
#include "galsim/Interpolant.h"
#include "galsim/Table.h"

// Adaptive moments code by Hirata, Seljak, and Mandelbaum
#include "galsim/hsm/PSFCorr.h"

// Math
#include "galsim/Solve.h"
#include "galsim/integ/Int.h"
#include "galsim/math/Angle.h"
#include "galsim/math/Bessel.h"
#include "galsim/math/Gamma.h"
#include "galsim/math/Hankel.h"
#include "galsim/math/Horner.h"
#include "galsim/math/Nan.h"
#include "galsim/math/Sinc.h"

// Version information.
// Note: This file is automatically generated by SCons using the current version info.
#include "galsim/Version.h"

#endif
