"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyPlatformSpecificPipeline = exports.EmptyGenericPipeline = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const ui_components_1 = require("@elyra/ui-components");
const HEADER_CLASS = 'empty-pipeline-header';
const EmptyGenericPipeline = () => {
    return (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx(ui_components_1.dragDropIcon.react, { className: "drag-drop-icon", tag: "div", elementPosition: "center", height: "120px" }, void 0),
            jsx_runtime_1.jsx("h3", Object.assign({ className: HEADER_CLASS }, { children: "Start your new pipeline by dragging files from the file browser pane" }), void 0)] }, void 0));
};
exports.EmptyGenericPipeline = EmptyGenericPipeline;
const EmptyPlatformSpecificPipeline = ({ onOpenCatalog }) => {
    const componentExamplesURL = 'https://github.com/elyra-ai/examples#custom-pipeline-component-examples';
    return (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx(exports.EmptyGenericPipeline, {}, void 0),
            jsx_runtime_1.jsxs("h3", Object.assign({ className: HEADER_CLASS }, { children: ["or add custom components by clicking the", ' ', jsx_runtime_1.jsx("button", Object.assign({ className: 'open-component-catalog-button', onClick: onOpenCatalog }, { children: jsx_runtime_1.jsx(ui_components_1.componentCatalogIcon.react, { className: "component-catalog-icon", tag: "div", height: "24px" }, void 0) }), void 0), ' ', "button.", jsx_runtime_1.jsx("br", {}, void 0),
                    jsx_runtime_1.jsx("br", {}, void 0)] }), void 0),
            jsx_runtime_1.jsxs("h4", Object.assign({ className: HEADER_CLASS }, { children: ["Refer to", jsx_runtime_1.jsxs("a", Object.assign({ href: componentExamplesURL, target: "_blank", rel: "noopener noreferrer" }, { children: [' ', "component examples", ' '] }), void 0), "for more details about adding custom components."] }), void 0)] }, void 0));
};
exports.EmptyPlatformSpecificPipeline = EmptyPlatformSpecificPipeline;
//# sourceMappingURL=EmptyPipelineContent.js.map