import { DocumentRegistry, DocumentWidget } from '@jupyterlab/docregistry';
import { IDisposable } from '@lumino/disposable';
/**
 * Submit notebook button extension
 *  - Attach button to notebook toolbar and launch a dialog requesting
 *  information about the remote location to where submit the notebook
 *  for execution
 */
export declare class SubmitFileButtonExtension<T extends DocumentWidget, U extends DocumentRegistry.IModel> implements DocumentRegistry.IWidgetExtension<T, U> {
    showWidget: (document: T) => Promise<void>;
    createNew(editor: T): IDisposable;
}
