"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1alpha.healthcheck_pb2
import google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing
import vdp.connector.v1alpha.connector_definition_pb2
import vdp.connector.v1alpha.connector_pb2
import vdp.pipeline.v1alpha.common_pb2
import vdp.pipeline.v1alpha.operator_definition_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ComponentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ComponentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ComponentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COMPONENT_TYPE_UNSPECIFIED: _ComponentType.ValueType  # 0
    """TYPE_UNSPECIFIED"""
    COMPONENT_TYPE_CONNECTOR_AI: _ComponentType.ValueType  # 1
    """CONNECTOR_AI"""
    COMPONENT_TYPE_CONNECTOR_DATA: _ComponentType.ValueType  # 2
    """CONNECTOR_DATA"""
    COMPONENT_TYPE_CONNECTOR_BLOCKCHAIN: _ComponentType.ValueType  # 3
    """CONNECTOR_BLOCKCHAIN"""
    COMPONENT_TYPE_OPERATOR: _ComponentType.ValueType  # 4
    """CONNECTOR_OPERATOR"""

class ComponentType(_ComponentType, metaclass=_ComponentTypeEnumTypeWrapper):
    """ComponentType"""

COMPONENT_TYPE_UNSPECIFIED: ComponentType.ValueType  # 0
"""TYPE_UNSPECIFIED"""
COMPONENT_TYPE_CONNECTOR_AI: ComponentType.ValueType  # 1
"""CONNECTOR_AI"""
COMPONENT_TYPE_CONNECTOR_DATA: ComponentType.ValueType  # 2
"""CONNECTOR_DATA"""
COMPONENT_TYPE_CONNECTOR_BLOCKCHAIN: ComponentType.ValueType  # 3
"""CONNECTOR_BLOCKCHAIN"""
COMPONENT_TYPE_OPERATOR: ComponentType.ValueType  # 4
"""CONNECTOR_OPERATOR"""
global___ComponentType = ComponentType

class _State:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATE_UNSPECIFIED: _State.ValueType  # 0
    """State: UNSPECIFIED"""
    STATE_INACTIVE: _State.ValueType  # 1
    """State INACTIVE indicates the pipeline is inactive"""
    STATE_ACTIVE: _State.ValueType  # 2
    """State ACTIVE indicates the pipeline is active"""
    STATE_ERROR: _State.ValueType  # 3
    """State ERROR indicates the pipeline has error"""

class State(_State, metaclass=_StateEnumTypeWrapper):
    """State enumerates the state of a pipeline"""

STATE_UNSPECIFIED: State.ValueType  # 0
"""State: UNSPECIFIED"""
STATE_INACTIVE: State.ValueType  # 1
"""State INACTIVE indicates the pipeline is inactive"""
STATE_ACTIVE: State.ValueType  # 2
"""State ACTIVE indicates the pipeline is active"""
STATE_ERROR: State.ValueType  # 3
"""State ERROR indicates the pipeline has error"""
global___State = State

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class Component(google.protobuf.message.Message):
    """Represents a pipeline component"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    RESOURCE_NAME_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DEFINITION_NAME_FIELD_NUMBER: builtins.int
    OPERATOR_DEFINITION_FIELD_NUMBER: builtins.int
    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Component id that is given by the users"""
    resource_name: builtins.str
    """A pipeline component resource name"""
    @property
    def resource(self) -> vdp.connector.v1alpha.connector_pb2.ConnectorResource:
        """A pipeline component resource detail"""
    @property
    def configuration(self) -> google.protobuf.struct_pb2.Struct:
        """Configuration for the pipeline component"""
    type: global___ComponentType.ValueType
    """Resource Type"""
    definition_name: builtins.str
    """A pipeline component definition name"""
    @property
    def operator_definition(self) -> vdp.pipeline.v1alpha.operator_definition_pb2.OperatorDefinition:
        """operator definition detail"""
    @property
    def connector_definition(self) -> vdp.connector.v1alpha.connector_definition_pb2.ConnectorDefinition:
        """connector definition detail"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        resource_name: builtins.str = ...,
        resource: vdp.connector.v1alpha.connector_pb2.ConnectorResource | None = ...,
        configuration: google.protobuf.struct_pb2.Struct | None = ...,
        type: global___ComponentType.ValueType = ...,
        definition_name: builtins.str = ...,
        operator_definition: vdp.pipeline.v1alpha.operator_definition_pb2.OperatorDefinition | None = ...,
        connector_definition: vdp.connector.v1alpha.connector_definition_pb2.ConnectorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["configuration", b"configuration", "connector_definition", b"connector_definition", "definition", b"definition", "operator_definition", b"operator_definition", "resource", b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["configuration", b"configuration", "connector_definition", b"connector_definition", "definition", b"definition", "definition_name", b"definition_name", "id", b"id", "operator_definition", b"operator_definition", "resource", b"resource", "resource_name", b"resource_name", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["definition", b"definition"]) -> typing_extensions.Literal["operator_definition", "connector_definition"] | None: ...

global___Component = Component

@typing_extensions.final
class Recipe(google.protobuf.message.Message):
    """Pipeline represents a pipeline recipe"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    COMPONENTS_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Recipe schema version"""
    @property
    def components(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Component]:
        """List of pipeline components"""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        components: collections.abc.Iterable[global___Component] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "version", b"version"]) -> None: ...

global___Recipe = Recipe

@typing_extensions.final
class Pipeline(google.protobuf.message.Message):
    """Pipeline represents the content of a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RECIPE_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    ORG_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    OPENAPI_SCHEMA_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/{user}/pipelines/*" """
    uid: builtins.str
    """Pipeline UUID"""
    id: builtins.str
    """Pipeline resource ID (the last segment of the resource name) used to
    construct the resource name. This conforms to RFC-1034, which restricts to
    letters, numbers, and hyphen, with the first character a letter, the last a
    letter or a number, and a 63 character maximum.
    """
    description: builtins.str
    """Pipeline description"""
    @property
    def recipe(self) -> global___Recipe:
        """Pipeline recipe"""
    user: builtins.str
    """The resource name with UUID of a user, e.g.,
    "users/bfb978f8-78d3-4338-aa2b-a6c699cb07c5".
    """
    org: builtins.str
    """The resource name with UUID of an organization"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline creation time"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline update time"""
    @property
    def openapi_schema(self) -> google.protobuf.struct_pb2.Struct:
        """OpenAPI schema"""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline delete time"""
    @property
    def permission(self) -> vdp.pipeline.v1alpha.common_pb2.Permission:
        """Pipeline permission"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Metadata: store Console-related data such as pipeline builder layout"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        recipe: global___Recipe | None = ...,
        user: builtins.str = ...,
        org: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        openapi_schema: google.protobuf.struct_pb2.Struct | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        permission: vdp.pipeline.v1alpha.common_pb2.Permission | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "metadata", b"metadata", "openapi_schema", b"openapi_schema", "org", b"org", "owner", b"owner", "permission", b"permission", "recipe", b"recipe", "update_time", b"update_time", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "metadata", b"metadata", "name", b"name", "openapi_schema", b"openapi_schema", "org", b"org", "owner", b"owner", "permission", b"permission", "recipe", b"recipe", "uid", b"uid", "update_time", b"update_time", "user", b"user"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["owner", b"owner"]) -> typing_extensions.Literal["user", "org"] | None: ...

global___Pipeline = Pipeline

@typing_extensions.final
class TriggerMetadata(google.protobuf.message.Message):
    """The metadata"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class TracesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Trace: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Trace | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRACES_FIELD_NUMBER: builtins.int
    @property
    def traces(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Trace]:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        traces: collections.abc.Mapping[builtins.str, global___Trace] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["traces", b"traces"]) -> None: ...

global___TriggerMetadata = TriggerMetadata

@typing_extensions.final
class Trace(google.protobuf.message.Message):
    """Trace for the intermediate component"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_IN_SECONDS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    """Success or not"""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Inputs of the component"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Outputs of the component"""
    @property
    def error(self) -> google.protobuf.struct_pb2.Struct:
        """Error of the component"""
    compute_time_in_seconds: builtins.float
    """Compute Time"""
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        error: google.protobuf.struct_pb2.Struct | None = ...,
        compute_time_in_seconds: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_in_seconds", b"compute_time_in_seconds", "error", b"error", "inputs", b"inputs", "outputs", b"outputs", "success", b"success"]) -> None: ...

global___Trace = Trace

@typing_extensions.final
class PipelineRelease(google.protobuf.message.Message):
    """PipelineRelease represents the content of a pipeline release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RECIPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    OPENAPI_SCHEMA_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    uid: builtins.str
    """PipelineRelease UUID"""
    id: builtins.str
    """PipelineRelease resource ID (the last segment of the resource name) used to
    construct the resource name. Must be a sematic version vX.Y.Z
    """
    description: builtins.str
    """PipelineRelease description"""
    @property
    def recipe(self) -> global___Recipe:
        """Pipeline recipe snapshot"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline creation time"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline update time"""
    @property
    def openapi_schema(self) -> google.protobuf.struct_pb2.Struct:
        """OpenAPI schema"""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline delete time"""
    alias: builtins.str
    """Alias"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Metadata: store Console-related data such as pipeline builder layout"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        recipe: global___Recipe | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        openapi_schema: google.protobuf.struct_pb2.Struct | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        alias: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "metadata", b"metadata", "openapi_schema", b"openapi_schema", "recipe", b"recipe", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "alias", b"alias", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "metadata", b"metadata", "name", b"name", "openapi_schema", b"openapi_schema", "recipe", b"recipe", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...

global___PipelineRelease = PipelineRelease

@typing_extensions.final
class ListPipelinesRequest(google.protobuf.message.Message):
    """ListPipelinesRequest represents a request to list pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelinesRequest = ListPipelinesRequest

@typing_extensions.final
class ListPipelinesResponse(google.protobuf.message.Message):
    """ListPipelinesResponse represents a response for a list of pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListPipelinesResponse = ListPipelinesResponse

@typing_extensions.final
class CreateUserPipelineRequest(google.protobuf.message.Message):
    """CreateUserPipelineRequest represents a request to create a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource to create"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "pipeline", b"pipeline"]) -> None: ...

global___CreateUserPipelineRequest = CreateUserPipelineRequest

@typing_extensions.final
class CreateUserPipelineResponse(google.protobuf.message.Message):
    """CreateUserPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The created pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CreateUserPipelineResponse = CreateUserPipelineResponse

@typing_extensions.final
class ListUserPipelinesRequest(google.protobuf.message.Message):
    """ListUserPipelinesRequest represents a request to list pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    show_deleted: builtins.bool
    """Return soft_deleted pipeline releases"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserPipelinesRequest = ListUserPipelinesRequest

@typing_extensions.final
class ListUserPipelinesResponse(google.protobuf.message.Message):
    """ListUserPipelinesResponse represents a response for a list of pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListUserPipelinesResponse = ListUserPipelinesResponse

@typing_extensions.final
class LookUpPipelineRequest(google.protobuf.message.Message):
    """LookUpPipelineRequest represents a request to query a pipeline via permalink"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a pipeline. For example:
    "pipelines/{uid}"
    """
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpPipelineRequest = LookUpPipelineRequest

@typing_extensions.final
class LookUpPipelineResponse(google.protobuf.message.Message):
    """LookUpPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___LookUpPipelineResponse = LookUpPipelineResponse

@typing_extensions.final
class GetUserPipelineRequest(google.protobuf.message.Message):
    """GetUserPipelineRequest represents a request to query a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """Pipeline resource view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserPipelineRequest = GetUserPipelineRequest

@typing_extensions.final
class GetUserPipelineResponse(google.protobuf.message.Message):
    """GetUserPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___GetUserPipelineResponse = GetUserPipelineResponse

@typing_extensions.final
class UpdateUserPipelineRequest(google.protobuf.message.Message):
    """UpdateUserPipelineRequest represents a request to update a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserPipelineRequest = UpdateUserPipelineRequest

@typing_extensions.final
class UpdateUserPipelineResponse(google.protobuf.message.Message):
    """UpdateUserPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """An updated pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___UpdateUserPipelineResponse = UpdateUserPipelineResponse

@typing_extensions.final
class DeleteUserPipelineRequest(google.protobuf.message.Message):
    """DeleteUserPipelineRequest represents a request to delete a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserPipelineRequest = DeleteUserPipelineRequest

@typing_extensions.final
class DeleteUserPipelineResponse(google.protobuf.message.Message):
    """DeleteUserPipelineResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserPipelineResponse = DeleteUserPipelineResponse

@typing_extensions.final
class ValidateUserPipelineRequest(google.protobuf.message.Message):
    """ValidatePUseripelineRequest represents a request to validate a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ValidateUserPipelineRequest = ValidateUserPipelineRequest

@typing_extensions.final
class ValidateUserPipelineResponse(google.protobuf.message.Message):
    """ValidateUserPipelineResponse represents an response of validated pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___ValidateUserPipelineResponse = ValidateUserPipelineResponse

@typing_extensions.final
class RenameUserPipelineRequest(google.protobuf.message.Message):
    """RenameUserPipelineRequest represents a request to rename the pipeline resource
    name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    new_pipeline_id: builtins.str
    """Pipeline new resource id to replace with the pipeline resource name to be
    "users/*/pipelines/{new_pipeline_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_id", b"new_pipeline_id"]) -> None: ...

global___RenameUserPipelineRequest = RenameUserPipelineRequest

@typing_extensions.final
class RenameUserPipelineResponse(google.protobuf.message.Message):
    """RenameUserPipelineResponse represents a renamed pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___RenameUserPipelineResponse = RenameUserPipelineResponse

@typing_extensions.final
class TriggerUserPipelineRequest(google.protobuf.message.Message):
    """TriggerUserPipelineRequest represents a request to trigger a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerUserPipelineRequest = TriggerUserPipelineRequest

@typing_extensions.final
class TriggerUserPipelineResponse(google.protobuf.message.Message):
    """TriggerUserPipelineResponse represents a response for the output
    of a pipeline, i.e., the multiple model inference outputs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """The multiple model inference outputs"""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerUserPipelineResponse = TriggerUserPipelineResponse

@typing_extensions.final
class TriggerAsyncUserPipelineRequest(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineRequest represents a request to trigger a async pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerAsyncUserPipelineRequest = TriggerAsyncUserPipelineRequest

@typing_extensions.final
class TriggerAsyncUserPipelineResponse(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineResponse represents a response for the longrunning
    operation of a pipeline
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Trigger async pipeline operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserPipelineResponse = TriggerAsyncUserPipelineResponse

@typing_extensions.final
class GetOperationRequest(google.protobuf.message.Message):
    """GetOperationRequest represents a request to query a longrunning
    operation
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetOperationRequest = GetOperationRequest

@typing_extensions.final
class GetOperationResponse(google.protobuf.message.Message):
    """GetOperationResponse represents a response for a longrunning
    operation
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The retrieved longrunning operation"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetOperationResponse = GetOperationResponse

@typing_extensions.final
class CreateUserPipelineReleaseRequest(google.protobuf.message.Message):
    """CreateUserPipelineReleaseRequest represents a request to create a pipeline_release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline_release resource to create"""
    parent: builtins.str
    """The parent resource where this pipeline_release will be created.
    Format: users/{user}/pipelines/{pipeline}
    """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "release", b"release"]) -> None: ...

global___CreateUserPipelineReleaseRequest = CreateUserPipelineReleaseRequest

@typing_extensions.final
class CreateUserPipelineReleaseResponse(google.protobuf.message.Message):
    """CreateUserPipelineReleaseResponse represents a response for a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The created pipeline_release resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___CreateUserPipelineReleaseResponse = CreateUserPipelineReleaseResponse

@typing_extensions.final
class ListUserPipelineReleasesRequest(google.protobuf.message.Message):
    """ListUserPipelineReleasesRequest represents a request to list pipeline_releases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipeline_releases to return. The service may return fewer
    than this value. If unspecified, at most 10 pipeline_release will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipeline_releases"""
    parent: builtins.str
    """The parent resource where this pipeline_release will be created.
    Format: users/{user}/pipelines/{pipeline}
    """
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserPipelineReleasesRequest = ListUserPipelineReleasesRequest

@typing_extensions.final
class ListUserPipelineReleasesResponse(google.protobuf.message.Message):
    """ListUserPipelineReleasesResponse represents a response for a list of pipeline_releases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline_release resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline_release resources"""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListUserPipelineReleasesResponse = ListUserPipelineReleasesResponse

@typing_extensions.final
class GetUserPipelineReleaseRequest(google.protobuf.message.Message):
    """GetUserPipelineReleaseRequest represents a request to query a pipeline_release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """PipelineRelease resource view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserPipelineReleaseRequest = GetUserPipelineReleaseRequest

@typing_extensions.final
class GetUserPipelineReleaseResponse(google.protobuf.message.Message):
    """GetUserPipelineReleaseResponse represents a response for a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline_release resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___GetUserPipelineReleaseResponse = GetUserPipelineReleaseResponse

@typing_extensions.final
class UpdateUserPipelineReleaseRequest(google.protobuf.message.Message):
    """UpdateUserPipelineReleaseRequest represents a request to update a pipeline release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline release resource to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserPipelineReleaseRequest = UpdateUserPipelineReleaseRequest

@typing_extensions.final
class UpdateUserPipelineReleaseResponse(google.protobuf.message.Message):
    """UpdateUserPipelineReleaseResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """An updated pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___UpdateUserPipelineReleaseResponse = UpdateUserPipelineReleaseResponse

@typing_extensions.final
class DeleteUserPipelineReleaseRequest(google.protobuf.message.Message):
    """DeleteUserPipelineReleaseRequest represents a request to delete a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserPipelineReleaseRequest = DeleteUserPipelineReleaseRequest

@typing_extensions.final
class DeleteUserPipelineReleaseResponse(google.protobuf.message.Message):
    """DeleteUserPipelineReleaseResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserPipelineReleaseResponse = DeleteUserPipelineReleaseResponse

@typing_extensions.final
class SetDefaultUserPipelineReleaseRequest(google.protobuf.message.Message):
    """SetDefaultUserPipelineReleaseRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___SetDefaultUserPipelineReleaseRequest = SetDefaultUserPipelineReleaseRequest

@typing_extensions.final
class SetDefaultUserPipelineReleaseResponse(google.protobuf.message.Message):
    """SetDefaultUserPipelineReleaseResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___SetDefaultUserPipelineReleaseResponse = SetDefaultUserPipelineReleaseResponse

@typing_extensions.final
class RestoreUserPipelineReleaseRequest(google.protobuf.message.Message):
    """RestoreUserPipelineReleaseRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___RestoreUserPipelineReleaseRequest = RestoreUserPipelineReleaseRequest

@typing_extensions.final
class RestoreUserPipelineReleaseResponse(google.protobuf.message.Message):
    """RestoreUserPipelineReleaseResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RestoreUserPipelineReleaseResponse = RestoreUserPipelineReleaseResponse

@typing_extensions.final
class RenameUserPipelineReleaseRequest(google.protobuf.message.Message):
    """RenameUserPipelineReleaseRequest represents a request to rename the pipeline release resource
    name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline release resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    new_pipeline_release_id: builtins.str
    """Pipeline new resource id to replace with the pipeline resource name to be
    "users/*/pipelines/*/releases/{new_pipeline_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_release_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_release_id", b"new_pipeline_release_id"]) -> None: ...

global___RenameUserPipelineReleaseRequest = RenameUserPipelineReleaseRequest

@typing_extensions.final
class RenameUserPipelineReleaseResponse(google.protobuf.message.Message):
    """RenameUserPipelineReleaseResponse represents a renamed pipeline release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RenameUserPipelineReleaseResponse = RenameUserPipelineReleaseResponse

@typing_extensions.final
class WatchUserPipelineReleaseRequest(google.protobuf.message.Message):
    """WatchUserPipelineReleaseRequest represents a public request to query
    a pipeline's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchUserPipelineReleaseRequest = WatchUserPipelineReleaseRequest

@typing_extensions.final
class WatchUserPipelineReleaseResponse(google.protobuf.message.Message):
    """WatchUserPipelineReleaseResponse represents a response to fetch a pipeline's
    current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """Retrieved pipeline state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___WatchUserPipelineReleaseResponse = WatchUserPipelineReleaseResponse

@typing_extensions.final
class TriggerUserPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseRequest represents a request to trigger a pipeline_released pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerUserPipelineReleaseRequest = TriggerUserPipelineReleaseRequest

@typing_extensions.final
class TriggerUserPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseResponse represents a response for the output
    of a pipeline, i.e., the multiple model inference outputs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """The multiple model inference outputs"""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerUserPipelineReleaseResponse = TriggerUserPipelineReleaseResponse

@typing_extensions.final
class TriggerAsyncUserPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineReleaseRequest represents a request to trigger a pipeline_released pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerAsyncUserPipelineReleaseRequest = TriggerAsyncUserPipelineReleaseRequest

@typing_extensions.final
class TriggerAsyncUserPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineReleaseResponse represents a response for the longrunning
    operation of a pipeline
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Trigger async pipeline operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserPipelineReleaseResponse = TriggerAsyncUserPipelineReleaseResponse

@typing_extensions.final
class ListPipelinesAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListPipelinesAdminRequest represents a request to list all pipelines from all
    users by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelinesAdminRequest = ListPipelinesAdminRequest

@typing_extensions.final
class ListPipelinesAdminResponse(google.protobuf.message.Message):
    """ListPipelinesAdminResponse represents a response for a list of pipelines
    The recipe returned will be permaLinks instead of resourceName temporary,
    this will be refactored soon
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListPipelinesAdminResponse = ListPipelinesAdminResponse

@typing_extensions.final
class ListPipelineReleasesAdminRequest(google.protobuf.message.Message):
    """ListPipelinesReleaseAdminRequest represents a request to list all pipeline_releases from all
    users by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelineReleasesAdminRequest = ListPipelineReleasesAdminRequest

@typing_extensions.final
class ListPipelineReleasesAdminResponse(google.protobuf.message.Message):
    """ListPipelineReleasesAdminResponse represents a response for a list of pipeline_releases
    The recipe returned will be permaLinks instead of resourceName temporary,
    this will be refactored soon
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListPipelineReleasesAdminResponse = ListPipelineReleasesAdminResponse

@typing_extensions.final
class LookUpPipelineAdminRequest(google.protobuf.message.Message):
    """LookUpPipelineAdminRequest represents a request to query a user's pipeline
    via permalink by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a pipeline. For example:
    "pipelines/{uid}"
    """
    view: vdp.pipeline.v1alpha.common_pb2.View.ValueType
    """View view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: vdp.pipeline.v1alpha.common_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpPipelineAdminRequest = LookUpPipelineAdminRequest

@typing_extensions.final
class LookUpPipelineAdminResponse(google.protobuf.message.Message):
    """LookUpPipelineAdminResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___LookUpPipelineAdminResponse = LookUpPipelineAdminResponse
