#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from castellan_ui.content.x509_certificates import views
from django.conf.urls import url

urlpatterns = [
    url(r'^$', views.IndexView.as_view(), name='index'),
    url(r'^import/$', views.ImportView.as_view(), name='import'),
    url(r'^(?P<object_id>[^/]+)/$',
        views.DetailView.as_view(),
        name='detail'),
    url(r'^download/$', views.download_cert, name='download'),
    url(r'^(?P<object_id>[^/]+)/download$',
        views.download_cert,
        name='download'),
]
