from os import path

from seqfold.fold import dg, fold

import seqfold

print(seqfold.__file__)

DIR = path.dirname(path.realpath(__file__))

DNA_EXAMPLES = {
    "GGGAGGTCGTTACATCTGGGTAACACCGGTACTGATCCGGTGACCTCCC": -10.9,  # three branched structure
    "GGGAGGTCGCTCCAGCTGGGAGGAGCGTTGGGGGTATATACCCCCAACACCGGTACTGATCCGGTGACCTCCC": -23.4,  # four branched structure
    "CGCAGGGAUACCCGCG": -3.8,
    "TAGCTCAGCTGGGAGAGCGCCTGCTTTGCACGCAGGAGGT": -6.9,
    "GGGGGCATAGCTCAGCTGGGAGAGCGCCTGCTTTGCACGCAGGAGGTCTGCGGTTCGATCCCGCGCGCTCCCACCA": -15.5,
    "TGAGACGGAAGGGGATGATTGTCCCCTTCCGTCTCA": -18.1,
    "ACCCCCTCCTTCCTTGGATCAAGGGGCTCAA": -3.7,
    "TGTCAGAAGTTTCCAAATGGCCAGCAATCAACCCATTCCATTGGGGATACAATGGTACAGTTTCGCATATTGTCGGTGAAAATGGTTCCATTAAACTCC": -9.4,
}

# writing results to examples for comparison
DNA_RESULTS = {}

for seq, ufold in DNA_EXAMPLES.items():
    ss = fold(seq, temp=37.0)
    cdg = round(sum(s.e for s in ss), 2)
    DNA_RESULTS[seq] = (cdg, ufold)

# save DNA_RESULTS to examples
with open(path.join(DIR, "..", "examples", "dna.csv"), "w") as ex:
    ex.write("seqfold,UNAFold,seq\n")

    for seq, (sf, uf) in DNA_RESULTS.items():
        ex.write(",".join([str(sf), str(uf), seq]) + "\n")


RNA_EXAMPLES = {
    "ACCCCCUCCUUCCUUGGAUCAAGGGGCUCAA": -9.5,
    "AAGGGGUUGGUCGCCUCGACUAAGCGGCUUGGAAUUCC": -10.1,
    "UUGGAGUACACAACCUGUACACUCUUUC": -4.3,
    "UGCCUGGCGGCCGUAGCGCGGUGGUCCCACCUGACCCCAUGCCGAACUCAGAAGUGAAACGCCGUAGCGCCGAUGGUAGUGUGGGGUCUCCCCAUGCGAGAGUAGGGAACUGCCAGGCAU": -54.9,
    "AGGGAAAAUCCC": -3.3,
    "GCUUACGAGCAAGUUAAGCAAC": -4.6,
    "UGGGAGGUCGUCUAACGGUAGGACGGCGGACUCUGGAUCCGCUGGUGGAGGUUCGAGUCCUCCCCUCCCAGCCA": -32.8,
    "GGGCGAUGAGGCCCGCCCAAACUGCCCUGAAAAGGGCUGAUGGCCUCUACUG": -20.7,
    "GGGGGCAUAGCUCAGCUGGGAGAGCGCCUGCUUUGCACGCAGGAGGUCUGCGGUUCGAUCCCGCGCGCUCCCACCA": -31.4,
    "CCGGACGAGGUGCGCCGUACCCGGUCAGGACAAGACGGCGC": -14.4,
    "CUUAGAAAGCAAACCUAUAACCGUUCACCGCCGCACAGGCGG": -9.5,
    "GGGAGUACGGUGAGGGUCGGGUCCAGUAGGUACGCCUACUGUUGAGUAGAGUGUGGGCUCCGUACUCCC": -32.2,
    "AAGUUUGCUAGGGUUCCGCGUCAAGGUGGUCUGGUCCAAGAGCAAACGGCUUUCACAAAGCCACACGGAAGGAUAAAAGCCUGGGAGAU": -24.0,
    "GAAGAUAGCCCAAGAAAGAGGGCAAUAACCAGAUAUAGCCUG": -7.9,
    "CACCCCAAUAUCGAAGGGGACUAAAACGACAAUCAAACUC": -6.6,
    "GCUUUAGAGAUCGUUUCGAAUGAUAAUCGUUCGAAACGUUCUCCGAAGC": -27.0,
    "AAAAAGGAAAUGAAAGUUGGAACUGCUCUCAUUUUGGAGGGUAAUCACAACA": -12.9,
    "GUGAAAGUGUACCUAGGGUUCCAGCCUAUUUGUAGGUGUUCGGACCGAGCGGUACAGGUAUAUUAUAUACCACACCUUAGGGACAAAAGCCCGAGAGGAUGGUUUCACG": -36.8,
    "GGAUGUGAGGCUUCGGCCUCACCGCUCCAUGUGCGA": -18.7,
    "GGAAGUGUACCUAGGGAUCCACCUCGAGAGAGGAAGGACCAAGCGGUACAGGCCUACUUCGGUAGGUUACACCGUGGGGAUAAAAGACCCGUGGCAAGUUUCG": -41.1,
    "AGGCGCAUUUGAACUGUAUUGUACGCCUUGCAGCAAAAGUACUAAAAAA": -6.8,
}


# writing results to examples for comparison
RNA_RESULTS = {}

for seq, ufold in RNA_EXAMPLES.items():
    cdg = dg(seq, temp=37.0)
    RNA_RESULTS[seq] = (cdg, ufold)

# save RNA_RESULTS to examples
with open(path.join(DIR, "..", "examples", "rna.csv"), "w") as ex:
    ex.write("seqfold,UNAFold,seq\n")

    for seq, (sf, uf) in RNA_RESULTS.items():
        ex.write(",".join([str(round(sf, 2)), str(uf), seq]) + "\n")

