"""
This module defines the base class for vulnerabilities.
"""

from typing import Set

from pydantic import Field

from euvd.models.customfieldtypes import EUVDIdType, EPSSScoreValueType
from euvd.models.enisaidproductref import EnisaIdProductRef
from euvd.models.enisaidvendorref import EnisaIdVendorRef
from euvd.models._baserecord import _BaseRecord


class _BaseVulnerability(_BaseRecord):
    """
    Base class for vulnerabilities.
    """
    id: EUVDIdType
    assigner: str
    epss: EPSSScoreValueType

    products: Set[EnisaIdProductRef] = Field(default_factory=set)
    vendors: Set[EnisaIdVendorRef] = Field(default_factory=set)

    def __hash__(self):
        return hash(
            (
                self.id,
                self.description,
            )
        )


__all__ = [
    '_BaseVulnerability',
]
