"""
This module defines the EnisaIdVulnerabilityRef class, which represents a reference to an ENISA vulnerability.
"""

from typing import Any
import uuid

from euvd.models._baseenisaidreference import _BaseEnisaIdReference
from euvd.models.vulnerability import Vulnerability


class EnisaIdVulnerabilityRef(_BaseEnisaIdReference):
    """
    Represents a reference to an ENISA vulnerability.
    """

    vulnerability: Vulnerability

    def __hash__(self):
                return hash((self.id, self.vulnerability))

    @classmethod
    def from_dict(cls, data: dict[str, Any]) -> 'EnisaIdVulnerabilityRef':
        """
        Parses a product dictionary into an EnisaIdVulnerabilityRef model.

        Args:
            data (dict[str, Any]): The vulnerability reference data to parse.

        Returns:
            EnisaIdVulnerabilityRef: An instance of the EnisaIdVulnerabilityRef class.
        """
        return EnisaIdVulnerabilityRef(
            id=uuid.UUID(data['id']),
            vulnerability=Vulnerability.from_dict(data['vulnerability']),
        )


__all__ = [
    'EnisaIdVulnerabilityRef',
]
