# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, Field, constr

from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    org_v2 = 'org/v2'


class Kind(Enum):
    environment = 'Environment'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/org/v2/environments/e-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=e-12345'
        ],
    )


class KindModel(Enum):
    organization = 'Organization'


class MetadataModel(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/org/v2/organizations/o-12345']
    )
    resource_name: Optional[Any] = Field(
        None, examples=['crn://confluent.cloud/organization=o-12345']
    )


class Organization(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel] = None
    display_name: Optional[constr(pattern=r'^[^<>#%\'*^`{|}~\"]{1,31}$')] = Field(
        None,
        description='A human-readable name for the Organization',
        examples=['Finance Org'],
    )
    jit_enabled: Optional[bool] = Field(
        None,
        description='The flag to toggle Just-In-Time user provisioning for SSO-enabled organization. Available for early access only.',
    )


class StreamGovernanceConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    package: str = Field(
        ...,
        description='Stream Governance Package. Supported values are ESSENTIALS and ADVANCED.\nPackage comparison can be found\n[here](https://docs.confluent.io/cloud/current/stream-governance/packages.html#features-by-package-type).\n',
    )


class KindModel1(Enum):
    environment_list = 'EnvironmentList'


class MetadataModel1(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/org/v2/environments']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/org/v2/environments?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/org/v2/environments?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/org/v2/environments?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class KindModel2(Enum):
    organization_list = 'OrganizationList'


class MetadataModel2(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/org/v2/organizations']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/org/v2/organizations?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/org/v2/organizations?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/org/v2/organizations?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class OrganizationList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel2 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel2
    data: List[Organization] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Environment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    display_name: Optional[str] = Field(
        None,
        description='A human-readable name for the Environment',
        examples=['prod-finance01'],
    )
    stream_governance_config: Optional[StreamGovernanceConfig] = Field(
        None, description='Stream Governance configurations for the environment'
    )


class EnvironmentList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel1 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel1
    data: List[Environment] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
