# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.11.2593
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from vrt_lss_account.models.account_audit_result import AccountAuditResult
from vrt_lss_account.models.calculation_status import CalculationStatus
from vrt_lss_account.models.process_type import ProcessType
from vrt_lss_account.models.service import Service

from vrt_lss_account.api_client import ApiClient, RequestSerialized
from vrt_lss_account.api_response import ApiResponse
from vrt_lss_account.rest import RESTResponseType


class AuditApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def read_audit(
        self,
        offset: Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None,
        var_from: Annotated[Optional[datetime], Field(description="Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. ")] = None,
        to: Annotated[Optional[datetime], Field(description="Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. ")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        operation: Annotated[Optional[Annotated[str, Field(min_length=3, strict=True, max_length=256)]], Field(description="Operation name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        status: Annotated[Optional[CalculationStatus], Field(description="Process status.")] = None,
        sort_field: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=64)]], Field(description="Field to sort by.")] = None,
        sort_direction: Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AccountAuditResult:
        """Actions for the period

        User actions for the period.  If the period is not specified, data for the current day is returned - from the beginning of the day to the current time inclusive. If the beginning of the time period is not specified, data from the beginning of the current day is returned. If the end of the time period is not specified, data up to the current time is returned. 

        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param var_from: Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. 
        :type var_from: datetime
        :param to: Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. 
        :type to: datetime
        :param service: Service name.
        :type service: Service
        :param operation: Operation name.
        :type operation: str
        :param process_type: Process type.
        :type process_type: ProcessType
        :param status: Process status.
        :type status: CalculationStatus
        :param sort_field: Field to sort by.
        :type sort_field: str
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_audit_serialize(
            offset=offset,
            limit=limit,
            var_from=var_from,
            to=to,
            service=service,
            operation=operation,
            process_type=process_type,
            status=status,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccountAuditResult",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_audit_with_http_info(
        self,
        offset: Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None,
        var_from: Annotated[Optional[datetime], Field(description="Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. ")] = None,
        to: Annotated[Optional[datetime], Field(description="Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. ")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        operation: Annotated[Optional[Annotated[str, Field(min_length=3, strict=True, max_length=256)]], Field(description="Operation name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        status: Annotated[Optional[CalculationStatus], Field(description="Process status.")] = None,
        sort_field: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=64)]], Field(description="Field to sort by.")] = None,
        sort_direction: Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AccountAuditResult]:
        """Actions for the period

        User actions for the period.  If the period is not specified, data for the current day is returned - from the beginning of the day to the current time inclusive. If the beginning of the time period is not specified, data from the beginning of the current day is returned. If the end of the time period is not specified, data up to the current time is returned. 

        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param var_from: Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. 
        :type var_from: datetime
        :param to: Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. 
        :type to: datetime
        :param service: Service name.
        :type service: Service
        :param operation: Operation name.
        :type operation: str
        :param process_type: Process type.
        :type process_type: ProcessType
        :param status: Process status.
        :type status: CalculationStatus
        :param sort_field: Field to sort by.
        :type sort_field: str
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_audit_serialize(
            offset=offset,
            limit=limit,
            var_from=var_from,
            to=to,
            service=service,
            operation=operation,
            process_type=process_type,
            status=status,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccountAuditResult",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_audit_without_preload_content(
        self,
        offset: Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None,
        var_from: Annotated[Optional[datetime], Field(description="Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. ")] = None,
        to: Annotated[Optional[datetime], Field(description="Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. ")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        operation: Annotated[Optional[Annotated[str, Field(min_length=3, strict=True, max_length=256)]], Field(description="Operation name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        status: Annotated[Optional[CalculationStatus], Field(description="Process status.")] = None,
        sort_field: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=64)]], Field(description="Field to sort by.")] = None,
        sort_direction: Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Actions for the period

        User actions for the period.  If the period is not specified, data for the current day is returned - from the beginning of the day to the current time inclusive. If the beginning of the time period is not specified, data from the beginning of the current day is returned. If the end of the time period is not specified, data up to the current time is returned. 

        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param var_from: Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If no datetime is specified, audit data are returned from the beginning of the day. 
        :type var_from: datetime
        :param to: Date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. If not specified, data up to the current time is returned. 
        :type to: datetime
        :param service: Service name.
        :type service: Service
        :param operation: Operation name.
        :type operation: str
        :param process_type: Process type.
        :type process_type: ProcessType
        :param status: Process status.
        :type status: CalculationStatus
        :param sort_field: Field to sort by.
        :type sort_field: str
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_audit_serialize(
            offset=offset,
            limit=limit,
            var_from=var_from,
            to=to,
            service=service,
            operation=operation,
            process_type=process_type,
            status=status,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccountAuditResult",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_audit_serialize(
        self,
        offset,
        limit,
        var_from,
        to,
        service,
        operation,
        process_type,
        status,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if operation is not None:
            
            _query_params.append(('operation', operation))
            
        if process_type is not None:
            
            _query_params.append(('process_type', process_type.value))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if sort_field is not None:
            
            _query_params.append(('sort_field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort_direction', sort_direction))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/account/audit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


