# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

"""LessEqual op"""
from mindspore.ops.op_info_register import op_info_register, TBERegOp, DataType

less_equal_op_info = TBERegOp("LessEqual") \
    .fusion_type("OPAQUE") \
    .async_flag(False) \
    .binfile_name("less_equal.so") \
    .compute_cost(10) \
    .kernel_name("less_equal") \
    .partial_flag(True) \
    .attr("begin_norm_axis", "required", "int", "all") \
    .attr("begin_params_axis", "required", "int", "all") \
    .input(0, "x1", False, "required", "all") \
    .input(1, "x2", False, "required", "all") \
    .output(0, "y", False, "required", "all") \
    .dtype_format(DataType.I8_Default, DataType.I8_Default, DataType.BOOL_Default) \
    .dtype_format(DataType.I8_5HD, DataType.I8_5HD, DataType.BOOL_5HD) \
    .dtype_format(DataType.U8_Default, DataType.U8_Default, DataType.BOOL_Default) \
    .dtype_format(DataType.U8_5HD, DataType.U8_5HD, DataType.BOOL_5HD) \
    .dtype_format(DataType.I32_Default, DataType.I32_Default, DataType.BOOL_Default) \
    .dtype_format(DataType.I32_5HD, DataType.I32_5HD, DataType.BOOL_5HD) \
    .dtype_format(DataType.F16_Default, DataType.F16_Default, DataType.BOOL_Default) \
    .dtype_format(DataType.F16_5HD, DataType.F16_5HD, DataType.BOOL_5HD) \
    .dtype_format(DataType.F32_Default, DataType.F32_Default, DataType.BOOL_Default) \
    .dtype_format(DataType.F32_5HD, DataType.F32_5HD, DataType.BOOL_5HD) \
    .get_op_info()


@op_info_register(less_equal_op_info)
def _less_equal_tbe():
    """LessEqual TBE register"""
    return
