"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .url import URL, URLTypedDict
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityInvoiceStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Status of the invoice."""

    OPEN = "open"
    PAID = "paid"
    OVERDUE = "overdue"


class NetAmountTypedDict(TypedDict):
    r"""Total amount of the invoice, excluding VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class NetAmount(BaseModel):
    r"""Total amount of the invoice, excluding VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class VatAmountTypedDict(TypedDict):
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will
    be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside
    the EU, no VAT will be charged.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class VatAmount(BaseModel):
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will
    be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside
    the EU, no VAT will be charged.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GrossAmountTypedDict(TypedDict):
    r"""Total amount of the invoice, including VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GrossAmount(BaseModel):
    r"""Total amount of the invoice, including VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class EntityInvoiceLineTypedDict(TypedDict):
    period: str
    r"""The administrative period in `YYYY-MM` on which the line should be booked."""
    description: str
    r"""Description of the product."""
    count: int
    r"""Number of products invoiced. For example, the number of payments."""
    vat_percentage: int
    r"""VAT percentage rate that applies to this product."""
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class EntityInvoiceLine(BaseModel):
    period: str
    r"""The administrative period in `YYYY-MM` on which the line should be booked."""

    description: str
    r"""Description of the product."""

    count: int
    r"""Number of products invoiced. For example, the number of payments."""

    vat_percentage: Annotated[int, pydantic.Field(alias="vatPercentage")]
    r"""VAT percentage rate that applies to this product."""

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class EntityInvoiceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    pdf: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityInvoiceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    pdf: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityInvoiceTypedDict(TypedDict):
    resource: str
    r"""Indicates that the response contains an invoice object.
    Will always contain the string `invoice` for this endpoint.
    """
    id: str
    reference: str
    r"""The reference number of the invoice. An example value would be: `2024.10000`."""
    vat_number: Nullable[str]
    r"""The VAT number to which the invoice was issued to, if applicable."""
    status: EntityInvoiceStatus
    net_amount: NetAmountTypedDict
    r"""Total amount of the invoice, excluding VAT."""
    vat_amount: VatAmountTypedDict
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will
    be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside
    the EU, no VAT will be charged.
    """
    gross_amount: GrossAmountTypedDict
    r"""Total amount of the invoice, including VAT."""
    lines: List[EntityInvoiceLineTypedDict]
    r"""The collection of products which make up the invoice."""
    issued_at: str
    r"""The invoice date in `YYYY-MM-DD` format."""
    links: EntityInvoiceLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    paid_at: NotRequired[Nullable[str]]
    r"""The date on which the invoice was paid, if applicable, in `YYYY-MM-DD` format."""
    due_at: NotRequired[Nullable[str]]
    r"""The date on which the invoice is due, if applicable, in `YYYY-MM-DD` format."""


class EntityInvoice(BaseModel):
    resource: str
    r"""Indicates that the response contains an invoice object.
    Will always contain the string `invoice` for this endpoint.
    """

    id: str

    reference: str
    r"""The reference number of the invoice. An example value would be: `2024.10000`."""

    vat_number: Annotated[Nullable[str], pydantic.Field(alias="vatNumber")]
    r"""The VAT number to which the invoice was issued to, if applicable."""

    status: Annotated[EntityInvoiceStatus, PlainValidator(validate_open_enum(False))]

    net_amount: Annotated[NetAmount, pydantic.Field(alias="netAmount")]
    r"""Total amount of the invoice, excluding VAT."""

    vat_amount: Annotated[VatAmount, pydantic.Field(alias="vatAmount")]
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will
    be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside
    the EU, no VAT will be charged.
    """

    gross_amount: Annotated[GrossAmount, pydantic.Field(alias="grossAmount")]
    r"""Total amount of the invoice, including VAT."""

    lines: List[EntityInvoiceLine]
    r"""The collection of products which make up the invoice."""

    issued_at: Annotated[str, pydantic.Field(alias="issuedAt")]
    r"""The invoice date in `YYYY-MM-DD` format."""

    links: Annotated[EntityInvoiceLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date on which the invoice was paid, if applicable, in `YYYY-MM-DD` format."""

    due_at: Annotated[OptionalNullable[str], pydantic.Field(alias="dueAt")] = UNSET
    r"""The date on which the invoice is due, if applicable, in `YYYY-MM-DD` format."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["paidAt", "dueAt"]
        nullable_fields = ["vatNumber", "paidAt", "dueAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
