# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceFirewallSettingsArgs', 'ApplianceFirewallSettings']

@pulumi.input_type
class ApplianceFirewallSettingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 spoofing_protection: Optional[pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs']] = None):
        """
        The set of arguments for constructing a ApplianceFirewallSettings resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs'] spoofing_protection: Spoofing protection settings
        """
        pulumi.set(__self__, "network_id", network_id)
        if spoofing_protection is not None:
            pulumi.set(__self__, "spoofing_protection", spoofing_protection)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="spoofingProtection")
    def spoofing_protection(self) -> Optional[pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs']]:
        """
        Spoofing protection settings
        """
        return pulumi.get(self, "spoofing_protection")

    @spoofing_protection.setter
    def spoofing_protection(self, value: Optional[pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs']]):
        pulumi.set(self, "spoofing_protection", value)


@pulumi.input_type
class _ApplianceFirewallSettingsState:
    def __init__(__self__, *,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 spoofing_protection: Optional[pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs']] = None):
        """
        Input properties used for looking up and filtering ApplianceFirewallSettings resources.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs'] spoofing_protection: Spoofing protection settings
        """
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if spoofing_protection is not None:
            pulumi.set(__self__, "spoofing_protection", spoofing_protection)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="spoofingProtection")
    def spoofing_protection(self) -> Optional[pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs']]:
        """
        Spoofing protection settings
        """
        return pulumi.get(self, "spoofing_protection")

    @spoofing_protection.setter
    def spoofing_protection(self, value: Optional[pulumi.Input['ApplianceFirewallSettingsSpoofingProtectionArgs']]):
        pulumi.set(self, "spoofing_protection", value)


class ApplianceFirewallSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 spoofing_protection: Optional[pulumi.Input[Union['ApplianceFirewallSettingsSpoofingProtectionArgs', 'ApplianceFirewallSettingsSpoofingProtectionArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceFirewallSettings:ApplianceFirewallSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['ApplianceFirewallSettingsSpoofingProtectionArgs', 'ApplianceFirewallSettingsSpoofingProtectionArgsDict']] spoofing_protection: Spoofing protection settings
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceFirewallSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceFirewallSettings:ApplianceFirewallSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceFirewallSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceFirewallSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 spoofing_protection: Optional[pulumi.Input[Union['ApplianceFirewallSettingsSpoofingProtectionArgs', 'ApplianceFirewallSettingsSpoofingProtectionArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceFirewallSettingsArgs.__new__(ApplianceFirewallSettingsArgs)

            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["spoofing_protection"] = spoofing_protection
        super(ApplianceFirewallSettings, __self__).__init__(
            'meraki:networks/applianceFirewallSettings:ApplianceFirewallSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            spoofing_protection: Optional[pulumi.Input[Union['ApplianceFirewallSettingsSpoofingProtectionArgs', 'ApplianceFirewallSettingsSpoofingProtectionArgsDict']]] = None) -> 'ApplianceFirewallSettings':
        """
        Get an existing ApplianceFirewallSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['ApplianceFirewallSettingsSpoofingProtectionArgs', 'ApplianceFirewallSettingsSpoofingProtectionArgsDict']] spoofing_protection: Spoofing protection settings
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceFirewallSettingsState.__new__(_ApplianceFirewallSettingsState)

        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["spoofing_protection"] = spoofing_protection
        return ApplianceFirewallSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="spoofingProtection")
    def spoofing_protection(self) -> pulumi.Output['outputs.ApplianceFirewallSettingsSpoofingProtection']:
        """
        Spoofing protection settings
        """
        return pulumi.get(self, "spoofing_protection")

